/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.svg;

import com.powsybl.diagram.util.ValueFormatter;
import com.powsybl.sld.layout.LayoutParameters;
import com.powsybl.sld.library.AnchorPoint;
import com.powsybl.sld.library.Component;
import com.powsybl.sld.library.ComponentLibrary;
import com.powsybl.sld.library.ComponentSize;
import com.powsybl.sld.model.cells.Cell;
import com.powsybl.sld.model.coordinate.Direction;
import com.powsybl.sld.model.coordinate.Orientation;
import com.powsybl.sld.model.coordinate.Point;
import com.powsybl.sld.model.coordinate.Side;
import com.powsybl.sld.model.graphs.BaseGraph;
import com.powsybl.sld.model.graphs.Graph;
import com.powsybl.sld.model.graphs.SubstationGraph;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.graphs.VoltageLevelInfos;
import com.powsybl.sld.model.graphs.ZoneGraph;
import com.powsybl.sld.model.nodes.BranchEdge;
import com.powsybl.sld.model.nodes.BusNode;
import com.powsybl.sld.model.nodes.Edge;
import com.powsybl.sld.model.nodes.EquipmentNode;
import com.powsybl.sld.model.nodes.FeederNode;
import com.powsybl.sld.model.nodes.Node;
import com.powsybl.sld.model.nodes.SwitchNode;
import com.powsybl.sld.model.nodes.feeders.FeederWithSides;
import com.powsybl.sld.svg.BusInfo;
import com.powsybl.sld.svg.DiagramLabelProvider;
import com.powsybl.sld.svg.ElectricalNodeInfo;
import com.powsybl.sld.svg.FeederInfo;
import com.powsybl.sld.svg.GraphMetadata;
import com.powsybl.sld.svg.LabelPosition;
import com.powsybl.sld.svg.SVGWriter;
import com.powsybl.sld.svg.WireConnection;
import com.powsybl.sld.svg.styles.StyleProvider;
import com.powsybl.sld.util.DomUtil;
import com.powsybl.sld.util.IdUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.util.Precision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class DefaultSVGWriter
implements SVGWriter {
    private static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    private static final String SVG_QUALIFIED_NAME = "svg";
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultSVGWriter.class);
    protected static final String GROUP = "g";
    protected static final String CLASS = "class";
    protected static final String STYLE = "style";
    protected static final String TRANSFORM = "transform";
    protected static final String TRANSLATE = "translate";
    protected static final String ROTATE = "rotate";
    protected static final String SCALE = "scale";
    protected static final double LABEL_OFFSET = 5.0;
    protected static final String POLYLINE = "polyline";
    protected static final String POINTS = "points";
    protected static final String TEXT_ANCHOR = "text-anchor";
    protected static final String MIDDLE = "middle";
    protected static final int CIRCLE_RADIUS_NODE_INFOS_SIZE = 10;
    protected static final String WIDTH = "width";
    protected static final String HEIGHT = "height";
    protected final ComponentLibrary componentLibrary;
    protected final LayoutParameters layoutParameters;
    private final ValueFormatter valueFormatter;

    public DefaultSVGWriter(ComponentLibrary componentLibrary, LayoutParameters layoutParameters) {
        this.componentLibrary = Objects.requireNonNull(componentLibrary);
        this.layoutParameters = Objects.requireNonNull(layoutParameters);
        this.valueFormatter = layoutParameters.createValueFormatter();
    }

    @Override
    public GraphMetadata write(String prefixId, Graph graph, DiagramLabelProvider labelProvider, StyleProvider styleProvider, Writer writer) {
        DOMImplementation domImpl = DomUtil.getDocumentBuilder().getDOMImplementation();
        Document document = domImpl.createDocument(SVG_NAMESPACE, SVG_QUALIFIED_NAME, null);
        this.setDocumentSize(graph, document);
        HashSet<String> listUsedComponentSVG = new HashSet<String>();
        this.addStyle(document, styleProvider, labelProvider, graph, listUsedComponentSVG);
        if (graph instanceof BaseGraph) {
            ((BaseGraph)graph).getMultiTermNodes().forEach(n -> listUsedComponentSVG.add(n.getComponentType()));
        }
        this.createDefsSVGComponents(document, listUsedComponentSVG);
        this.addFrame(document);
        GraphMetadata metadata = this.writeGraph(prefixId, graph, document, labelProvider, styleProvider);
        DomUtil.transformDocument(document, writer);
        return metadata;
    }

    private void setDocumentSize(Graph graph, Document document) {
        document.getDocumentElement().setAttribute("viewBox", "0 0 " + this.getDiagramWidth(graph, this.layoutParameters) + " " + this.getDiagramHeight(graph, this.layoutParameters));
        if (this.layoutParameters.isSvgWidthAndHeightAdded()) {
            document.getDocumentElement().setAttribute(WIDTH, Double.toString(this.getDiagramWidth(graph, this.layoutParameters)));
            document.getDocumentElement().setAttribute(HEIGHT, Double.toString(this.getDiagramHeight(graph, this.layoutParameters)));
        }
    }

    private double getDiagramWidth(Graph graph, LayoutParameters layoutParameters) {
        return graph.getWidth() + layoutParameters.getDiagramPadding().getLeft() + layoutParameters.getDiagramPadding().getRight();
    }

    private double getDiagramHeight(Graph graph, LayoutParameters layoutParameters) {
        double height = graph.getHeight() + layoutParameters.getDiagramPadding().getTop() + layoutParameters.getDiagramPadding().getBottom();
        if (graph instanceof VoltageLevelGraph && layoutParameters.isAddNodesInfos()) {
            height += 60.0;
        }
        return height;
    }

    protected void addStyle(Document document, StyleProvider styleProvider, DiagramLabelProvider labelProvider, Graph graph, Set<String> listUsedComponentSVG) {
        graph.getAllNodesStream().forEach(n -> {
            listUsedComponentSVG.add(n.getComponentType());
            List<DiagramLabelProvider.NodeDecorator> nodeDecorators = labelProvider.getNodeDecorators((Node)n, graph.getDirection((Node)n));
            if (nodeDecorators != null) {
                nodeDecorators.forEach(nodeDecorator -> listUsedComponentSVG.add(nodeDecorator.getType()));
            }
        });
        Element style = document.createElement(STYLE);
        switch (this.layoutParameters.getCssLocation()) {
            case INSERTED_IN_SVG: {
                List<URL> urls = styleProvider.getCssUrls();
                urls.addAll(this.componentLibrary.getCssUrls());
                style.appendChild(this.getCdataSection(document, urls));
                document.adoptNode(style);
                document.getDocumentElement().appendChild(style);
                break;
            }
            case EXTERNAL_IMPORTED: {
                styleProvider.getCssFilenames().forEach(name -> this.addStyleImportTextNode(document, style, (String)name));
                this.componentLibrary.getCssFilenames().forEach(name -> this.addStyleImportTextNode(document, style, (String)name));
                document.adoptNode(style);
                document.getDocumentElement().appendChild(style);
                break;
            }
            case EXTERNAL_NO_IMPORT: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected CSS location: " + this.layoutParameters.getCssLocation()));
            }
        }
    }

    private org.w3c.dom.Node addStyleImportTextNode(Document document, Element style, String name) {
        return style.appendChild(document.createTextNode("@import url(" + name + ");"));
    }

    private CDATASection getCdataSection(Document document, List<URL> cssUrls) {
        StringBuilder styleSheetBuilder = new StringBuilder();
        for (URL cssUrl : cssUrls) {
            try {
                styleSheetBuilder.append(new String(IOUtils.toByteArray((URL)cssUrl), StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Can't read css file " + cssUrl.getPath(), e);
            }
        }
        String graphStyle = "\n" + styleSheetBuilder + "\n";
        String cssStr = graphStyle.replace("\r\n", "\n").replace("\r", "\n");
        return document.createCDATASection(cssStr);
    }

    private void addFrame(Document document) {
        Element rect = document.createElement("rect");
        rect.setAttribute(WIDTH, "100%");
        rect.setAttribute(HEIGHT, "100%");
        rect.setAttribute(CLASS, "sld-frame");
        document.adoptNode(rect);
        document.getDocumentElement().appendChild(rect);
    }

    protected GraphMetadata writeGraph(String prefixId, Graph graph, Document document, DiagramLabelProvider initProvider, StyleProvider styleProvider) {
        GraphMetadata metadata = new GraphMetadata(this.layoutParameters);
        Element root = document.createElement(GROUP);
        this.drawGrid(prefixId, graph, document, metadata, root);
        if (graph instanceof VoltageLevelGraph) {
            this.drawVoltageLevel(prefixId, (VoltageLevelGraph)graph, root, metadata, initProvider, styleProvider);
        } else if (graph instanceof SubstationGraph) {
            this.drawSubstation(prefixId, (SubstationGraph)graph, root, metadata, initProvider, styleProvider);
        } else if (graph instanceof ZoneGraph) {
            this.drawZone(prefixId, (ZoneGraph)graph, root, metadata, initProvider, styleProvider);
        }
        document.adoptNode(root);
        document.getDocumentElement().appendChild(root);
        return metadata;
    }

    private void drawGrid(String prefixId, Graph graph, Document document, GraphMetadata metadata, Element root) {
        if (this.layoutParameters.isShowGrid()) {
            for (VoltageLevelGraph vlGraph : graph.getVoltageLevels()) {
                if (!vlGraph.isPositionNodeBusesCalculated()) continue;
                this.drawGrid(prefixId, vlGraph, document, metadata, root);
            }
        }
    }

    protected void drawVoltageLevel(String prefixId, VoltageLevelGraph graph, Element root, GraphMetadata metadata, DiagramLabelProvider initProvider, StyleProvider styleProvider) {
        if (!graph.isForVoltageLevelDiagram()) {
            this.drawGraphLabel(prefixId, root, graph, metadata);
        }
        Set<Node> remainingNodesToDraw = graph.getNodeSet();
        Set<Edge> remainingEdgesToDraw = graph.getEdgeSet();
        this.drawBuses(prefixId, root, graph, metadata, initProvider, styleProvider, remainingNodesToDraw);
        graph.getCellStream().forEach(cell -> this.drawCell(prefixId, root, graph, (Cell)cell, metadata, initProvider, styleProvider, remainingEdgesToDraw, remainingNodesToDraw));
        this.drawEdges(prefixId, root, graph, metadata, initProvider, styleProvider, remainingEdgesToDraw);
        this.drawNodes(prefixId, root, graph, graph.getCoord(), metadata, initProvider, styleProvider, remainingNodesToDraw);
        this.drawSnakeLines(prefixId, root, graph, metadata, styleProvider);
        this.drawNodes(prefixId, root, graph, new Point(0.0, 0.0), metadata, initProvider, styleProvider, graph.getMultiTermNodes());
        if (graph.isForVoltageLevelDiagram() && this.layoutParameters.isAddNodesInfos()) {
            this.drawNodesInfos(prefixId, root, graph, metadata, initProvider, styleProvider);
        }
    }

    private void drawCell(String prefixId, Element root, VoltageLevelGraph graph, Cell cell, GraphMetadata metadata, DiagramLabelProvider initProvider, StyleProvider styleProvider, Set<Edge> remainingEdgesToDraw, Set<Node> remainingNodesToDraw) {
        String cellId = IdUtil.escapeId(prefixId + cell.getId());
        Element g = root.getOwnerDocument().createElement(GROUP);
        g.setAttribute("id", cellId);
        g.setAttribute(CLASS, String.join((CharSequence)" ", styleProvider.getCellStyles(cell)));
        List<Node> cellNodes = cell.getNodes();
        List nodesToDraw = cellNodes.stream().filter(n -> !(n instanceof BusNode)).collect(Collectors.toList());
        Collection edgesToDraw = nodesToDraw.stream().flatMap(n -> n.getAdjacentEdges().stream()).filter(e -> cellNodes.contains(e.getNode1()) && cellNodes.contains(e.getNode2())).collect(Collectors.toCollection(LinkedHashSet::new));
        this.drawEdges(prefixId, g, graph, metadata, initProvider, styleProvider, edgesToDraw);
        this.drawNodes(prefixId, g, graph, graph.getCoord(), metadata, initProvider, styleProvider, nodesToDraw);
        remainingEdgesToDraw.removeAll(edgesToDraw);
        remainingNodesToDraw.removeAll(nodesToDraw);
        root.appendChild(g);
    }

    protected void drawSubstation(String prefixId, SubstationGraph graph, Element root, GraphMetadata metadata, DiagramLabelProvider initProvider, StyleProvider styleProvider) {
        for (VoltageLevelGraph vlGraph : graph.getVoltageLevels()) {
            this.drawVoltageLevel(prefixId, vlGraph, root, metadata, initProvider, styleProvider);
        }
        this.drawSnakeLines(prefixId, root, graph, metadata, styleProvider);
        this.drawNodes(prefixId, root, graph, new Point(0.0, 0.0), metadata, initProvider, styleProvider, graph.getMultiTermNodes());
    }

    protected void drawGrid(String prefixId, VoltageLevelGraph graph, Document document, GraphMetadata metadata, Element root) {
        int maxH = graph.getMaxH();
        int maxV = graph.getMaxV();
        Element gridRoot = document.createElement(GROUP);
        String gridId = prefixId + "GRID_" + graph.getVoltageLevelInfos().getId();
        gridRoot.setAttribute("id", gridId);
        gridRoot.setAttribute(CLASS, "sld-grid");
        for (int iCell = 0; iCell < maxH / 2 + 1; ++iCell) {
            this.drawGridVerticalLine(document, graph, maxV, graph.getX() + (double)iCell * this.layoutParameters.getCellWidth(), gridRoot);
        }
        if (graph.getExternCellHeight(Direction.TOP) > 0.0) {
            this.drawGridHorizontalLine(document, graph, maxH, graph.getY() + graph.getFirstBusY() - this.layoutParameters.getStackHeight(), gridRoot);
            this.drawGridHorizontalLine(document, graph, maxH, graph.getY() + graph.getFirstBusY() - this.layoutParameters.getInternCellHeight(), gridRoot);
            this.drawGridHorizontalLine(document, graph, maxH, graph.getY() + this.layoutParameters.getFeederSpan(), gridRoot);
        }
        if (graph.getExternCellHeight(Direction.BOTTOM) > 0.0) {
            this.drawGridHorizontalLine(document, graph, maxH, graph.getY() + graph.getFirstBusY() + this.layoutParameters.getStackHeight() + this.layoutParameters.getVerticalSpaceBus() * (double)maxV, gridRoot);
            this.drawGridHorizontalLine(document, graph, maxH, graph.getY() + graph.getFirstBusY() + this.layoutParameters.getInternCellHeight() + this.layoutParameters.getVerticalSpaceBus() * (double)maxV, gridRoot);
            this.drawGridHorizontalLine(document, graph, maxH, graph.getY() + graph.getFirstBusY() + graph.getExternCellHeight(Direction.BOTTOM) - this.layoutParameters.getFeederSpan() + this.layoutParameters.getVerticalSpaceBus() * (double)maxV, gridRoot);
        }
        metadata.addNodeMetadata(new GraphMetadata.NodeMetadata(gridId, graph.getVoltageLevelInfos().getId(), null, null, false, Direction.UNDEFINED, false, null, Collections.emptyList()));
        root.appendChild(gridRoot);
    }

    protected void drawGridHorizontalLine(Document document, VoltageLevelGraph graph, int maxH, double y, Element root) {
        this.drawGridLine(document, graph.getX(), y, (double)maxH / 2.0 * this.layoutParameters.getCellWidth() + graph.getX(), y, root);
    }

    protected void drawGridVerticalLine(Document document, VoltageLevelGraph graph, int maxV, double x, Element root) {
        this.drawGridLine(document, x, graph.getY() + graph.getFirstBusY() - graph.getExternCellHeight(Direction.TOP), x, graph.getY() + graph.getFirstBusY() + graph.getExternCellHeight(Direction.BOTTOM) + this.layoutParameters.getVerticalSpaceBus() * (double)maxV, root);
    }

    protected void drawGridLine(Document document, double x1, double y1, double x2, double y2, Element root) {
        Element line = document.createElement("line");
        line.setAttribute("x1", Double.toString(x1));
        line.setAttribute("x2", Double.toString(x2));
        line.setAttribute("y1", Double.toString(y1));
        line.setAttribute("y2", Double.toString(y2));
        root.appendChild(line);
    }

    protected void drawBuses(String prefixId, Element root, VoltageLevelGraph graph, GraphMetadata metadata, DiagramLabelProvider initProvider, StyleProvider styleProvider, Set<Node> remainingNodesToDraw) {
        for (BusNode busNode : graph.getNodeBuses()) {
            String nodeId = IdUtil.escapeId(prefixId + busNode.getId());
            Element g = root.getOwnerDocument().createElement(GROUP);
            g.setAttribute("id", nodeId);
            g.setAttribute(CLASS, String.join((CharSequence)" ", styleProvider.getNodeStyles(graph, busNode, this.componentLibrary, this.layoutParameters.isShowInternalNodes())));
            this.drawBus(graph, busNode, g);
            List<DiagramLabelProvider.NodeLabel> nodeLabels = initProvider.getNodeLabels(busNode, graph.getDirection(busNode));
            this.drawNodeLabel(prefixId, g, busNode, nodeLabels);
            this.drawNodeDecorators(prefixId, g, graph, busNode, initProvider, styleProvider);
            this.insertBusInfo(prefixId, g, busNode, metadata, initProvider, styleProvider);
            root.appendChild(g);
            metadata.addNodeMetadata(new GraphMetadata.NodeMetadata(nodeId, graph.getVoltageLevelInfos().getId(), null, "BUSBAR_SECTION", false, Direction.UNDEFINED, false, busNode.getEquipmentId(), this.createNodeLabelMetadata(prefixId, busNode, nodeLabels)));
            if (metadata.getComponentMetadata("BUSBAR_SECTION") == null) {
                metadata.addComponent(new Component("BUSBAR_SECTION", null, null, this.componentLibrary.getComponentStyleClass("BUSBAR_SECTION").orElse(null), this.componentLibrary.getTransformations("BUSBAR_SECTION"), null));
            }
            remainingNodesToDraw.remove(busNode);
        }
    }

    protected List<GraphMetadata.NodeLabelMetadata> createNodeLabelMetadata(String prefixId, Node node, List<DiagramLabelProvider.NodeLabel> nodeLabels) {
        ArrayList<GraphMetadata.NodeLabelMetadata> labelsMetadata = new ArrayList<GraphMetadata.NodeLabelMetadata>();
        for (DiagramLabelProvider.NodeLabel nodeLabel : nodeLabels) {
            LabelPosition labelPosition = nodeLabel.getPosition();
            String svgId = DefaultSVGWriter.getNodeLabelId(prefixId, node, labelPosition);
            labelsMetadata.add(new GraphMetadata.NodeLabelMetadata(svgId, labelPosition.getPositionName(), nodeLabel.getUserDefinedId()));
        }
        return labelsMetadata;
    }

    protected void drawNodes(String prefixId, Element root, BaseGraph graph, Point shift, GraphMetadata metadata, DiagramLabelProvider labelProvider, StyleProvider styleProvider, Collection<? extends Node> nodes) {
        for (Node node : nodes) {
            String nodeId = IdUtil.escapeId(prefixId + node.getId());
            Element g = root.getOwnerDocument().createElement(GROUP);
            g.setAttribute("id", nodeId);
            g.setAttribute(CLASS, String.join((CharSequence)" ", styleProvider.getNodeStyles(graph.getVoltageLevelGraph(node), node, this.componentLibrary, this.layoutParameters.isShowInternalNodes())));
            this.incorporateComponents(prefixId, graph, node, shift, g, labelProvider, styleProvider);
            List<DiagramLabelProvider.NodeLabel> nodeLabels = labelProvider.getNodeLabels(node, graph.getDirection(node));
            this.drawNodeLabel(prefixId, g, node, nodeLabels);
            this.drawNodeDecorators(prefixId, g, graph, node, labelProvider, styleProvider);
            root.appendChild(g);
            Direction direction = node instanceof FeederNode ? graph.getDirection(node) : Direction.UNDEFINED;
            this.setMetadata(prefixId, metadata, node, nodeId, graph, direction, nodeLabels);
        }
    }

    protected void setMetadata(String prefixId, GraphMetadata metadata, Node node, String nodeId, BaseGraph graph, Direction direction, List<DiagramLabelProvider.NodeLabel> nodeLabels) {
        FeederWithSides feederWs;
        VoltageLevelInfos otherSideVoltageLevelInfos;
        String nextVId = null;
        if (node instanceof FeederNode && ((FeederNode)node).getFeeder() instanceof FeederWithSides && (otherSideVoltageLevelInfos = (feederWs = (FeederWithSides)((FeederNode)node).getFeeder()).getOtherSideVoltageLevelInfos()) != null) {
            nextVId = otherSideVoltageLevelInfos.getId();
        }
        String id = graph instanceof VoltageLevelGraph ? ((VoltageLevelGraph)graph).getVoltageLevelInfos().getId() : "";
        boolean isOpen = node.getType() == Node.NodeType.SWITCH && ((SwitchNode)node).isOpen();
        metadata.addNodeMetadata(new GraphMetadata.NodeMetadata(nodeId, id, nextVId, node.getComponentType(), isOpen, direction, false, node instanceof EquipmentNode ? ((EquipmentNode)node).getEquipmentId() : null, this.createNodeLabelMetadata(prefixId, node, nodeLabels)));
        this.addInfoComponentMetadata(metadata, node.getComponentType());
    }

    protected void drawNodeLabel(String prefixId, Element g, Node node, List<DiagramLabelProvider.NodeLabel> nodeLabels) {
        for (DiagramLabelProvider.NodeLabel nodeLabel : nodeLabels) {
            LabelPosition labelPosition = nodeLabel.getPosition();
            Element label = this.createLabelElement(nodeLabel.getLabel(), labelPosition.getdX(), labelPosition.getdY(), labelPosition.getShiftAngle(), g);
            String svgId = DefaultSVGWriter.getNodeLabelId(prefixId, node, labelPosition);
            label.setAttribute("id", svgId);
            if (labelPosition.isCentered()) {
                label.setAttribute(TEXT_ANCHOR, MIDDLE);
            }
            g.appendChild(label);
        }
    }

    protected void drawNodeDecorators(String prefixId, Element root, Graph graph, Node node, DiagramLabelProvider labelProvider, StyleProvider styleProvider) {
        for (DiagramLabelProvider.NodeDecorator nodeDecorator : labelProvider.getNodeDecorators(node, graph.getDirection(node))) {
            Element g = root.getOwnerDocument().createElement(GROUP);
            g.setAttribute(CLASS, String.join((CharSequence)" ", styleProvider.getNodeDecoratorStyles(nodeDecorator, node, this.componentLibrary)));
            this.insertDecoratorSVGIntoDocumentSVG(prefixId, nodeDecorator, g, graph, node, styleProvider);
            root.appendChild(g);
        }
    }

    protected void drawGraphLabel(String prefixId, Element root, VoltageLevelGraph graph, GraphMetadata metadata) {
        String idLabelVoltageLevel = prefixId + "LABEL_VL_" + graph.getVoltageLevelInfos().getId();
        Element gLabel = root.getOwnerDocument().createElement(GROUP);
        gLabel.setAttribute("id", idLabelVoltageLevel);
        double yPos = graph.getY() - 20.0;
        String graphName = this.layoutParameters.isUseName() ? graph.getVoltageLevelInfos().getName() : graph.getVoltageLevelInfos().getId();
        Element label = this.createLabelElement(graphName, graph.getX(), yPos, 0, gLabel);
        label.setAttribute(CLASS, "sld-graph-label");
        gLabel.appendChild(label);
        root.appendChild(gLabel);
        metadata.addNodeMetadata(new GraphMetadata.NodeMetadata(idLabelVoltageLevel, graph.getVoltageLevelInfos().getId(), null, null, false, Direction.UNDEFINED, true, null, Collections.emptyList()));
    }

    protected void drawBus(VoltageLevelGraph graph, BusNode node, Element g) {
        Element line = g.getOwnerDocument().createElement("line");
        line.setAttribute("x1", "0");
        line.setAttribute("y1", "0");
        if (node.getOrientation().isHorizontal()) {
            line.setAttribute("x2", String.valueOf(node.getPxWidth()));
            line.setAttribute("y2", "0");
        } else {
            line.setAttribute("x2", "0");
            line.setAttribute("y2", String.valueOf(node.getPxWidth()));
        }
        g.appendChild(line);
        g.setAttribute(TRANSFORM, String.format("%s(%s,%s)", TRANSLATE, graph.getX() + node.getX(), graph.getY() + node.getY()));
    }

    protected Element createLabelElement(String str, double xShift, double yShift, int shiftAngle, Element g) {
        Element label = g.getOwnerDocument().createElement("text");
        label.setAttribute("x", String.valueOf(xShift));
        label.setAttribute("y", String.valueOf(yShift));
        if (shiftAngle != 0) {
            label.setAttribute(TRANSFORM, "rotate(" + shiftAngle + ",0,0)");
        }
        label.setAttribute(CLASS, "sld-label");
        Text text = g.getOwnerDocument().createTextNode(str);
        label.appendChild(text);
        return label;
    }

    protected void incorporateComponents(String prefixId, Graph graph, Node node, Point shift, Element g, DiagramLabelProvider labelProvider, StyleProvider styleProvider) {
        String componentType = node.getComponentType();
        this.transformComponent(node, shift, g);
        if (this.componentLibrary.getSvgElements(componentType) != null) {
            this.insertComponentSVGIntoDocumentSVG(prefixId, componentType, g, graph, node, labelProvider, styleProvider);
        }
    }

    protected void insertComponentSVGIntoDocumentSVG(String prefixId, String componentType, Element g, Graph graph, Node node, DiagramLabelProvider labelProvider, StyleProvider styleProvider) {
        BiConsumer<Element, String> elementAttributesSetter = (elt, subComponent) -> this.setComponentAttributes(prefixId, g, graph, node, styleProvider, (Element)elt, componentType, (String)subComponent);
        String tooltipContent = this.layoutParameters.isTooltipEnabled() ? labelProvider.getTooltip(node) : null;
        this.insertSVGIntoDocumentSVG(componentType, g, tooltipContent, elementAttributesSetter);
    }

    protected void insertFeederInfoSVGIntoDocumentSVG(FeederInfo feederInfo, String prefixId, Element g, double angle) {
        BiConsumer<Element, String> elementAttributesSetter = (e, subComponent) -> this.setInfoAttributes(feederInfo.getComponentType(), prefixId, g, (Element)e, (String)subComponent, angle);
        this.insertSVGIntoDocumentSVG(feederInfo.getComponentType(), g, null, elementAttributesSetter);
    }

    protected void insertBusInfoSVGIntoDocumentSVG(BusInfo busInfo, String prefixId, Element g) {
        BiConsumer<Element, String> elementAttributesSetter = (e, subComponent) -> this.setInfoAttributes(busInfo.getComponentType(), prefixId, g, (Element)e, (String)subComponent, 0.0);
        this.insertSVGIntoDocumentSVG(busInfo.getComponentType(), g, null, elementAttributesSetter);
    }

    private void setInfoAttributes(String infoType, String prefixId, Element g, Element e, String subComponent, double angle) {
        this.replaceId(g, e, prefixId);
        this.componentLibrary.getSubComponentStyleClass(infoType, subComponent).ifPresent(style -> e.setAttribute(CLASS, (String)style));
        if (Math.abs(angle) > 0.0) {
            ComponentSize componentSize = this.componentLibrary.getSize(infoType);
            double cx = componentSize.getWidth() / 2.0;
            double cy = componentSize.getHeight() / 2.0;
            e.setAttribute(TRANSFORM, "rotate(" + angle + "," + cx + "," + cy + ")");
        }
    }

    protected void insertDecoratorSVGIntoDocumentSVG(String prefixId, DiagramLabelProvider.NodeDecorator nodeDecorator, Element g, Graph graph, Node node, StyleProvider styleProvider) {
        BiConsumer<Element, String> elementAttributesSetter = (elt, subComponent) -> this.setDecoratorAttributes(prefixId, g, graph, node, nodeDecorator, styleProvider, (Element)elt, (String)subComponent);
        String nodeDecoratorType = nodeDecorator.getType();
        this.insertSVGIntoDocumentSVG(nodeDecoratorType, g, null, elementAttributesSetter);
    }

    protected void insertSVGIntoDocumentSVG(String componentType, Element g, String tooltip, BiConsumer<Element, String> elementAttributesSetter) {
        this.addToolTip(g, tooltip);
        Map<String, List<Element>> subComponents = this.componentLibrary.getSvgElements(componentType);
        subComponents.forEach(this.layoutParameters.isAvoidSVGComponentsDuplication() ? (subComponentName, svgSubComponent) -> this.insertSubcomponentReference(g, elementAttributesSetter, componentType, (String)subComponentName, subComponents.size()) : (subComponentName, svgSubComponent) -> this.insertDuplicatedSubcomponent(g, elementAttributesSetter, (String)subComponentName, (List<Element>)svgSubComponent));
    }

    private void insertDuplicatedSubcomponent(Element g, BiConsumer<Element, String> elementAttributesSetter, String subComponentName, List<Element> svgSubComponent) {
        svgSubComponent.forEach(e -> {
            Element clonedElement = (Element)e.cloneNode(true);
            this.setAttributesAndInsertElement(g, elementAttributesSetter, subComponentName, clonedElement);
        });
    }

    private void insertSubcomponentReference(Element g, BiConsumer<Element, String> elementAttributesSetter, String componentType, String subComponentName, int nbSubComponents) {
        Element eltUse = g.getOwnerDocument().createElement("use");
        eltUse.setAttribute("href", "#" + DefaultSVGWriter.getHRefValue(nbSubComponents, componentType, subComponentName));
        this.setAttributesAndInsertElement(g, elementAttributesSetter, subComponentName, eltUse);
    }

    private static String getHRefValue(int nbSubComponents, String componentType, String subComponentName) {
        return nbSubComponents > 1 ? componentType + "-" + subComponentName : componentType;
    }

    private void setAttributesAndInsertElement(Element g, BiConsumer<Element, String> elementAttributesSetter, String subComponentName, Element element) {
        elementAttributesSetter.accept(element, subComponentName);
        g.getOwnerDocument().adoptNode(element);
        g.appendChild(element);
    }

    private void addToolTip(Element g, String tooltip) {
        if (!StringUtils.isEmpty((CharSequence)tooltip)) {
            Document doc = g.getOwnerDocument();
            Element title = doc.createElement("title");
            title.appendChild(doc.createTextNode(tooltip));
            g.appendChild(title);
        }
    }

    private void setComponentAttributes(String prefixId, Element g, Graph graph, Node node, StyleProvider styleProvider, Element elt, String componentType, String subComponent) {
        this.replaceId(g, elt, prefixId);
        ComponentSize size = this.componentLibrary.getSize(componentType);
        Orientation nodeOrientation = node.getOrientation();
        Component.Transformation transformation = this.componentLibrary.getTransformations(node.getComponentType()).get((Object)nodeOrientation);
        if (transformation != null) {
            switch (transformation) {
                case ROTATION: {
                    elt.setAttribute(TRANSFORM, "rotate(" + nodeOrientation.toRotationAngle() + "," + size.getWidth() / 2.0 + "," + size.getHeight() / 2.0 + ")");
                    break;
                }
                case FLIP: {
                    if (nodeOrientation.isVertical()) {
                        elt.setAttribute(TRANSFORM, "scale(1, -1) translate(0, " + -size.getHeight() + ")");
                        break;
                    }
                    elt.setAttribute(TRANSFORM, "scale(-1, 1) translate(" + -size.getWidth() + ", 0)");
                    break;
                }
            }
        }
        List<String> subComponentStyles = styleProvider.getNodeSubcomponentStyles(graph, node, subComponent);
        this.componentLibrary.getSubComponentStyleClass(componentType, subComponent).ifPresent(subComponentStyles::add);
        if (!subComponentStyles.isEmpty()) {
            elt.setAttribute(CLASS, String.join((CharSequence)" ", subComponentStyles));
        }
    }

    private void setDecoratorAttributes(String prefixId, Element g, Graph graph, Node node, DiagramLabelProvider.NodeDecorator nodeDecorator, StyleProvider styleProvider, Element elt, String subComponentName) {
        this.replaceId(g, elt, prefixId);
        ComponentSize decoratorSize = this.componentLibrary.getSize(nodeDecorator.getType());
        LabelPosition decoratorPosition = nodeDecorator.getPosition();
        elt.setAttribute(TRANSFORM, this.getTransformStringDecorator(node, decoratorPosition, decoratorSize));
        List<String> svgNodeSubcomponentStyles = styleProvider.getNodeSubcomponentStyles(graph, node, subComponentName);
        this.componentLibrary.getSubComponentStyleClass(nodeDecorator.getType(), subComponentName).ifPresent(svgNodeSubcomponentStyles::add);
        if (!svgNodeSubcomponentStyles.isEmpty()) {
            elt.setAttribute(CLASS, String.join((CharSequence)" ", svgNodeSubcomponentStyles));
        }
    }

    private void replaceId(Element g, Element elt, String prefixId) {
        org.w3c.dom.Node nodeId = elt.getAttributes().getNamedItem("id");
        if (nodeId != null) {
            String nodeIdValue = nodeId.getTextContent();
            String gIdValue = StringUtils.removeStart((String)g.getAttribute("id"), (String)prefixId);
            nodeId.setTextContent(prefixId + gIdValue + "_" + nodeIdValue);
        }
    }

    private String getTransformStringDecorator(Node node, LabelPosition decoratorPosition, ComponentSize decoratorSize) {
        ComponentSize componentSize = this.componentLibrary.getSize(node.getComponentType());
        double dX = componentSize.getWidth() / 2.0 + decoratorPosition.getdX();
        double dY = componentSize.getHeight() / 2.0 + decoratorPosition.getdY();
        if (decoratorPosition.isCentered()) {
            dX -= decoratorSize.getWidth() / 2.0;
            dY -= decoratorSize.getHeight() / 2.0;
        }
        return "translate(" + dX + "," + dY + ")";
    }

    protected void transformComponent(Node node, Point shift, Element g) {
        double[] translate = this.getNodeTranslate(node, shift);
        g.setAttribute(TRANSFORM, "translate(" + translate[0] + "," + translate[1] + ")");
    }

    private double[] getNodeTranslate(Node node, Point shift) {
        ComponentSize componentSize = this.componentLibrary.getSize(node.getComponentType());
        double translateX = node.getX() + shift.getX() - componentSize.getWidth() / 2.0;
        double translateY = node.getY() + shift.getY() - componentSize.getHeight() / 2.0;
        return new double[]{translateX, translateY};
    }

    protected void transformFeederInfo(List<Point> points, ComponentSize componentSize, double shift, Element g) {
        double distancePoints23;
        Point pointA = points.get(0);
        Point pointB = points.get(1);
        double distancePoints = pointA.distance(pointB);
        if (points.size() > 2 && distancePoints < 3.0 * componentSize.getHeight() && (distancePoints23 = points.get(1).distance(points.get(2))) > 3.0 * componentSize.getHeight()) {
            distancePoints = distancePoints23;
            pointA = points.get(1);
            pointB = points.get(2);
        }
        if (distancePoints > 0.0) {
            double dx = pointB.getX() - pointA.getX();
            double dy = pointB.getY() - pointA.getY();
            double cosAngle = dx / distancePoints;
            double sinAngle = dy / distancePoints;
            double x = pointA.getX() + cosAngle * (this.layoutParameters.getFeederInfosOuterMargin() + shift);
            double y = pointA.getY() + sinAngle * (this.layoutParameters.getFeederInfosOuterMargin() + shift);
            double feederInfoRotationAngle = Math.atan(dy / dx) - 1.5707963267948966;
            if (feederInfoRotationAngle < -1.5707963267948966) {
                feederInfoRotationAngle += Math.PI;
            }
            g.setAttribute(TRANSFORM, this.getTransformString(x, y, feederInfoRotationAngle, componentSize));
        }
    }

    private String getTransformString(double centerPosX, double centerPosY, double angle, ComponentSize componentSize) {
        if (angle == 0.0) {
            double translateX = centerPosX - componentSize.getWidth() / 2.0;
            double translateY = centerPosY - componentSize.getHeight() / 2.0;
            return "translate(" + translateX + "," + translateY + ")";
        }
        double[] matrix = this.getTransformMatrix(componentSize.getWidth(), componentSize.getHeight(), angle, centerPosX, centerPosY);
        return DefaultSVGWriter.transformMatrixToString(matrix, 4);
    }

    private double[] getTransformMatrix(double width, double height, double angle, double centerPosX, double centerPosY) {
        double cosRo = Math.cos(angle);
        double sinRo = Math.sin(angle);
        double cdx = width / 2.0;
        double cdy = height / 2.0;
        double e1 = centerPosX - cdx * cosRo + cdy * sinRo;
        double f1 = centerPosY - cdx * sinRo - cdy * cosRo;
        return new double[]{cosRo, sinRo, -sinRo, cosRo, e1, f1};
    }

    private static String transformMatrixToString(double[] matrix, int precision) {
        double[] matrix2 = new double[matrix.length];
        for (int i = 0; i < matrix.length; ++i) {
            matrix2[i] = Precision.round((double)matrix[i], (int)precision);
        }
        return "matrix(" + matrix2[0] + "," + matrix2[1] + "," + matrix2[2] + "," + matrix2[3] + "," + matrix2[4] + "," + matrix2[5] + ")";
    }

    protected void insertFeederInfos(String prefixId, List<Point> points, Element root, VoltageLevelGraph graph, FeederNode feederNode, GraphMetadata metadata, DiagramLabelProvider labelProvider, StyleProvider styleProvider) {
        if (points.isEmpty()) {
            points.add(graph.getShiftedPoint(feederNode));
            points.add(graph.getShiftedPoint(feederNode));
        }
        double shiftFeederInfo = 0.0;
        for (FeederInfo feederInfo : labelProvider.getFeederInfos(feederNode)) {
            this.drawFeederInfo(prefixId, feederNode, points, root, feederInfo, shiftFeederInfo, metadata, styleProvider);
            this.addInfoComponentMetadata(metadata, feederInfo.getComponentType());
            double height = this.componentLibrary.getSize(feederInfo.getComponentType()).getHeight();
            shiftFeederInfo += this.layoutParameters.getFeederInfosIntraMargin() + height;
        }
    }

    private void addInfoComponentMetadata(GraphMetadata metadata, String componentType) {
        if (metadata.getComponentMetadata(componentType) == null) {
            metadata.addComponent(new Component(componentType, this.componentLibrary.getAnchorPoints(componentType), this.componentLibrary.getSize(componentType), this.componentLibrary.getComponentStyleClass(componentType).orElse(null), this.componentLibrary.getTransformations(componentType), null));
        }
    }

    private void drawFeederInfo(String prefixId, FeederNode feederNode, List<Point> points, Element root, FeederInfo feederInfo, double shift, GraphMetadata metadata, StyleProvider styleProvider) {
        Element g = root.getOwnerDocument().createElement(GROUP);
        ComponentSize size = this.componentLibrary.getSize(feederInfo.getComponentType());
        double shX = size.getWidth() + 5.0;
        double shY = size.getHeight() / 2.0;
        ArrayList<String> styles = new ArrayList<String>(3);
        this.componentLibrary.getComponentStyleClass(feederInfo.getComponentType()).ifPresent(styles::add);
        this.transformFeederInfo(points, size, shift, g);
        String svgId = IdUtil.escapeId(feederNode.getId()) + "_" + feederInfo.getComponentType();
        g.setAttribute("id", svgId);
        String componentType = feederInfo.getComponentType();
        String side = feederNode.getFeeder() instanceof FeederWithSides ? ((FeederWithSides)feederNode.getFeeder()).getSide().name() : null;
        metadata.addFeederInfoMetadata(new GraphMetadata.FeederInfoMetadata(svgId, feederNode.getEquipmentId(), side, componentType, feederInfo.getUserDefinedId()));
        double rotationAngle = points.get(0).getY() > points.get(1).getY() ? 180.0 : 0.0;
        this.insertFeederInfoSVGIntoDocumentSVG(feederInfo, prefixId, g, rotationAngle);
        styles.addAll(styleProvider.getFeederInfoStyles(feederInfo));
        feederInfo.getRightLabel().ifPresent(s -> {
            Element labelRight = this.createLabelElement((String)s, shX, shY, 0, g);
            g.appendChild(labelRight);
        });
        feederInfo.getLeftLabel().ifPresent(s -> {
            Element labelLeft = this.createLabelElement((String)s, -5.0, shY, 0, g);
            labelLeft.setAttribute(STYLE, "text-anchor:end");
            g.appendChild(labelLeft);
        });
        g.setAttribute(CLASS, String.join((CharSequence)" ", styles));
        root.appendChild(g);
    }

    protected void insertBusInfo(String prefixId, Element root, BusNode busNode, GraphMetadata metadata, DiagramLabelProvider labelProvider, StyleProvider styleProvider) {
        Optional<BusInfo> busInfo = labelProvider.getBusInfo(busNode);
        busInfo.ifPresent(info -> {
            this.drawBusInfo(prefixId, busNode, root, (BusInfo)info, styleProvider, metadata);
            this.addInfoComponentMetadata(metadata, ((BusInfo)busInfo.get()).getComponentType());
        });
    }

    private void drawBusInfo(String prefixId, BusNode busNode, Element root, BusInfo busInfo, StyleProvider styleProvider, GraphMetadata metadata) {
        Element g = root.getOwnerDocument().createElement(GROUP);
        ComponentSize size = this.componentLibrary.getSize(busInfo.getComponentType());
        double shiftX = this.layoutParameters.getBusInfoMargin();
        double dy = -size.getHeight() / 2.0;
        double dx = busInfo.getAnchor() == Side.RIGHT ? busNode.getPxWidth() - shiftX - size.getWidth() : shiftX;
        g.setAttribute(TRANSFORM, "translate(" + dx + "," + dy + ")");
        ArrayList<String> styles = new ArrayList<String>();
        this.componentLibrary.getComponentStyleClass(busInfo.getComponentType()).ifPresent(styles::add);
        styles.addAll(styleProvider.getBusInfoStyle(busInfo));
        g.setAttribute(CLASS, String.join((CharSequence)" ", styles));
        String svgId = IdUtil.escapeId(busNode.getId()) + "_" + busInfo.getComponentType();
        g.setAttribute("id", svgId);
        metadata.addBusInfoMetadata(new GraphMetadata.BusInfoMetadata(svgId, busNode.getId(), busInfo.getUserDefinedId()));
        this.insertBusInfoSVGIntoDocumentSVG(busInfo, prefixId, g);
        double shY = size.getHeight() + 5.0;
        busInfo.getBottomLabel().ifPresent(s -> {
            Element labelBottom = this.createLabelElement((String)s, 0.0, shY, 0, g);
            g.appendChild(labelBottom);
        });
        busInfo.getTopLabel().ifPresent(s -> {
            Element labelTop = this.createLabelElement((String)s, 0.0, -5.0, 0, g);
            g.appendChild(labelTop);
        });
        root.appendChild(g);
    }

    private static String getWireId(String prefixId, String containerId, Edge edge) {
        return IdUtil.escapeClassName(prefixId + "_" + containerId + "_" + edge.getNode1().getId() + "_" + edge.getNode2().getId());
    }

    private static String getNodeLabelId(String prefixId, Node node, LabelPosition labelPosition) {
        return prefixId + node.getId() + "_" + labelPosition.getPositionName();
    }

    protected void drawEdges(String prefixId, Element root, VoltageLevelGraph graph, GraphMetadata metadata, DiagramLabelProvider initProvider, StyleProvider styleProvider, Collection<Edge> edges) {
        String voltageLevelId = graph.getVoltageLevelInfos().getId();
        for (Edge edge : edges) {
            String wireId = DefaultSVGWriter.getWireId(prefixId, voltageLevelId, edge);
            List<Object> pol = new ArrayList();
            if (!edge.isZeroLength()) {
                Point shift = graph.getCoord();
                pol = WireConnection.searchBestAnchorPoints(this.componentLibrary, graph, edge.getNode1(), edge.getNode2()).calculatePolylinePoints(edge.getNode1(), edge.getNode2(), this.layoutParameters.isDrawStraightWires(), shift);
                if (!pol.isEmpty()) {
                    Element g = root.getOwnerDocument().createElement(GROUP);
                    g.setAttribute("id", wireId);
                    List<String> wireStyles = styleProvider.getEdgeStyles(graph, edge);
                    g.setAttribute(CLASS, String.join((CharSequence)" ", wireStyles));
                    Element polyline = root.getOwnerDocument().createElement(POLYLINE);
                    polyline.setAttribute(POINTS, this.pointsListToString(pol));
                    g.appendChild(polyline);
                    root.appendChild(g);
                }
            }
            metadata.addWireMetadata(new GraphMetadata.WireMetadata(wireId, IdUtil.escapeId(edge.getNode1().getId()), IdUtil.escapeId(edge.getNode2().getId()), this.layoutParameters.isDrawStraightWires(), false));
            if (edge.getNode1() instanceof FeederNode) {
                if (edge.getNode2() instanceof FeederNode) continue;
                this.insertFeederInfos(prefixId, pol, root, graph, (FeederNode)edge.getNode1(), metadata, initProvider, styleProvider);
                continue;
            }
            if (!(edge.getNode2() instanceof FeederNode)) continue;
            Collections.reverse(pol);
            this.insertFeederInfos(prefixId, pol, root, graph, (FeederNode)edge.getNode2(), metadata, initProvider, styleProvider);
        }
    }

    protected void drawSnakeLines(String prefixId, Element root, ZoneGraph graph, GraphMetadata metadata, StyleProvider styleProvider) {
        for (BranchEdge edge : graph.getLineEdges()) {
            this.drawSnakeLines(graph, edge, prefixId, root, metadata, styleProvider);
        }
    }

    protected void drawSnakeLines(String prefixId, Element root, BaseGraph graph, GraphMetadata metadata, StyleProvider styleProvider) {
        for (BranchEdge edge : graph.getLineEdges()) {
            this.drawSnakeLines(graph, edge, prefixId, root, metadata, styleProvider);
        }
        for (BranchEdge edge : graph.getTwtEdges()) {
            this.drawSnakeLines(graph, edge, prefixId, root, metadata, styleProvider);
        }
    }

    private void drawSnakeLines(Graph graph, BranchEdge edge, String prefixId, Element root, GraphMetadata metadata, StyleProvider styleProvider) {
        Element g = root.getOwnerDocument().createElement(GROUP);
        String snakeLineId = IdUtil.escapeId(prefixId + edge.getId());
        g.setAttribute("id", snakeLineId);
        List<String> wireStyles = styleProvider.getEdgeStyles(graph, edge);
        g.setAttribute(CLASS, String.join((CharSequence)" ", wireStyles));
        root.appendChild(g);
        List<Point> pol = edge.getSnakeLine();
        if (!pol.isEmpty() && graph.getVoltageLevelGraph(edge.getNode2()) == null) {
            this.adaptCoordSnakeLine(edge, pol, graph);
        }
        Element polyline = root.getOwnerDocument().createElement(POLYLINE);
        polyline.setAttribute(POINTS, this.pointsListToString(pol));
        g.appendChild(polyline);
        metadata.addWireMetadata(new GraphMetadata.WireMetadata(snakeLineId, IdUtil.escapeId(edge.getNode1().getId()), IdUtil.escapeId(edge.getNode2().getId()), this.layoutParameters.isDrawStraightWires(), true));
    }

    private void adaptCoordSnakeLine(BranchEdge edge, List<Point> pol, Graph graph) {
        Point multiTermPoint = pol.get(pol.size() - 1);
        Point pointBeforeNode = pol.get(Math.max(pol.size() - 2, 0));
        AnchorPoint bestAnchorPoint = WireConnection.getBestAnchorPoint(this.componentLibrary, graph, edge.getNode2(), pointBeforeNode);
        if (multiTermPoint.getX() == pointBeforeNode.getX()) {
            pointBeforeNode.shiftX(bestAnchorPoint.getX());
        } else if (multiTermPoint.getY() == pointBeforeNode.getY()) {
            pointBeforeNode.shiftY(bestAnchorPoint.getY());
        }
        multiTermPoint.shift(bestAnchorPoint);
    }

    protected String pointsListToString(List<Point> polyline) {
        return polyline.stream().map(pt -> pt.getX() + "," + pt.getY()).collect(Collectors.joining(","));
    }

    protected void createDefsSVGComponents(Document document, Set<String> listUsedComponentSVG) {
        if (this.layoutParameters.isAvoidSVGComponentsDuplication()) {
            listUsedComponentSVG.add("ARROW_ACTIVE");
            listUsedComponentSVG.add("ARROW_REACTIVE");
            Element defs = document.createElement("defs");
            listUsedComponentSVG.forEach(c -> {
                Map<String, List<Element>> subComponents = this.componentLibrary.getSvgElements((String)c);
                if (subComponents != null) {
                    Element group = document.createElement(GROUP);
                    group.setAttribute("id", (String)c);
                    this.insertSVGComponentIntoDefsArea((String)c, group, subComponents);
                    defs.getOwnerDocument().adoptNode(group);
                    defs.appendChild(group);
                }
            });
            document.adoptNode(defs);
            document.getDocumentElement().appendChild(defs);
        }
    }

    protected void insertSVGComponentIntoDefsArea(String componentType, Element group, Map<String, List<Element>> subComponents) {
        for (Map.Entry<String, List<Element>> subComponent : subComponents.entrySet()) {
            if (subComponents.size() > 1) {
                Element subComponentGroup = group.getOwnerDocument().createElement(GROUP);
                subComponentGroup.setAttribute("id", DefaultSVGWriter.getHRefValue(subComponents.size(), componentType, subComponent.getKey()));
                this.addSvgSubComponentsToElement(subComponent.getValue(), subComponentGroup);
                group.getOwnerDocument().adoptNode(subComponentGroup);
                group.appendChild(subComponentGroup);
                continue;
            }
            this.addSvgSubComponentsToElement(subComponent.getValue(), group);
        }
    }

    private void addSvgSubComponentsToElement(List<Element> subComponentElements, Element group) {
        for (Element subComponentElement : subComponentElements) {
            org.w3c.dom.Node n = subComponentElement.cloneNode(true);
            group.getOwnerDocument().adoptNode(n);
            group.appendChild(n);
        }
    }

    private void drawZone(String prefixId, ZoneGraph graph, Element root, GraphMetadata metadata, DiagramLabelProvider initProvider, StyleProvider styleProvider) {
        for (SubstationGraph sGraph : graph.getSubstations()) {
            this.drawSubstation(prefixId, sGraph, root, metadata, initProvider, styleProvider);
        }
        this.drawSnakeLines(prefixId, root, graph, metadata, styleProvider);
    }

    private void drawNodeInfos(ElectricalNodeInfo nodeInfo, double xShift, double yShift, Element g, String idNode, List<String> styles) {
        Element circle = g.getOwnerDocument().createElement("circle");
        circle.setAttribute("id", idNode + "_circle");
        circle.setAttribute("cx", String.valueOf(xShift));
        circle.setAttribute("cy", String.valueOf(yShift));
        circle.setAttribute("r", String.valueOf(10));
        circle.setAttribute("stroke-width", String.valueOf(10));
        circle.setAttribute(CLASS, String.join((CharSequence)" ", styles));
        g.appendChild(circle);
        Element labelV = g.getOwnerDocument().createElement("text");
        labelV.setAttribute("id", idNode + "_v");
        String valueV = this.valueFormatter.formatVoltage(nodeInfo.getV(), "kV");
        labelV.setAttribute("x", String.valueOf(xShift - 10.0));
        labelV.setAttribute("y", String.valueOf(yShift + 25.0));
        labelV.setAttribute(CLASS, "sld-voltage");
        Text textV = g.getOwnerDocument().createTextNode(valueV);
        labelV.appendChild(textV);
        g.appendChild(labelV);
        Element labelAngle = g.getOwnerDocument().createElement("text");
        labelAngle.setAttribute("id", idNode + "_angle");
        String valueAngle = this.valueFormatter.formatAngleInDegrees(nodeInfo.getAngle());
        labelAngle.setAttribute("x", String.valueOf(xShift - 10.0));
        labelAngle.setAttribute("y", String.valueOf(yShift + 40.0));
        labelAngle.setAttribute(CLASS, "sld-angle");
        Text textAngle = g.getOwnerDocument().createTextNode(valueAngle);
        labelAngle.appendChild(textAngle);
        g.appendChild(labelAngle);
    }

    private void drawNodesInfos(String prefixId, Element root, VoltageLevelGraph graph, GraphMetadata metadata, DiagramLabelProvider initProvider, StyleProvider styleProvider) {
        Element nodesInfosNode = root.getOwnerDocument().createElement(GROUP);
        root.appendChild(nodesInfosNode);
        nodesInfosNode.setAttribute(CLASS, "sld-legend");
        double xInitPos = this.layoutParameters.getDiagramPadding().getLeft() + 10.0;
        double yPos = graph.getY() - this.layoutParameters.getVoltageLevelPadding().getTop() + graph.getHeight() + 10.0;
        double xShift = graph.getX() + xInitPos;
        for (ElectricalNodeInfo node : initProvider.getElectricalNodesInfos(graph)) {
            String idNode = prefixId + "NODE_" + node.getBusId();
            Element gNode = nodesInfosNode.getOwnerDocument().createElement(GROUP);
            gNode.setAttribute("id", idNode);
            List<String> styles = styleProvider.getBusStyles(node.getBusId(), graph);
            this.drawNodeInfos(node, xShift, yPos, gNode, idNode, styles);
            nodesInfosNode.appendChild(gNode);
            metadata.addElectricalNodeInfoMetadata(new GraphMetadata.ElectricalNodeInfoMetadata(idNode, node.getUserDefinedId()));
            xShift += 70.0;
        }
    }
}

