/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.svg;

import com.powsybl.sld.model.coordinate.Direction;
import com.powsybl.sld.model.coordinate.Side;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.nodes.BusNode;
import com.powsybl.sld.model.nodes.FeederNode;
import com.powsybl.sld.model.nodes.Node;
import com.powsybl.sld.svg.BusInfo;
import com.powsybl.sld.svg.ElectricalNodeInfo;
import com.powsybl.sld.svg.FeederInfo;
import com.powsybl.sld.svg.LabelPosition;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface DiagramLabelProvider {
    public List<FeederInfo> getFeederInfos(FeederNode var1);

    public List<NodeLabel> getNodeLabels(Node var1, Direction var2);

    public String getTooltip(Node var1);

    public List<NodeDecorator> getNodeDecorators(Node var1, Direction var2);

    public List<ElectricalNodeInfo> getElectricalNodesInfos(VoltageLevelGraph var1);

    public Optional<BusInfo> getBusInfo(BusNode var1);

    public Map<String, Side> getBusInfoSides(VoltageLevelGraph var1);

    public static enum LabelDirection {
        OUT,
        IN;

    }

    public static class NodeDecorator {
        private final String type;
        private final LabelPosition position;

        public NodeDecorator(String type, LabelPosition labelPosition) {
            this.type = type;
            this.position = labelPosition;
        }

        public String getType() {
            return this.type;
        }

        public LabelPosition getPosition() {
            return this.position;
        }
    }

    public static class NodeLabel {
        private final String label;
        private final LabelPosition position;
        private final String userDefinedId;

        public NodeLabel(String label, LabelPosition labelPosition) {
            this(label, labelPosition, null);
        }

        public NodeLabel(String label, LabelPosition labelPosition, String userDefinedId) {
            this.label = label;
            this.position = labelPosition;
            this.userDefinedId = userDefinedId;
        }

        public String getLabel() {
            return this.label;
        }

        public LabelPosition getPosition() {
            return this.position;
        }

        public String getUserDefinedId() {
            return this.userDefinedId;
        }
    }
}

