/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.svg;

import com.powsybl.sld.svg.AbstractFeederInfo;
import com.powsybl.sld.svg.DiagramLabelProvider;
import java.util.Objects;
import java.util.function.DoubleFunction;

public class DirectionalFeederInfo
extends AbstractFeederInfo {
    private final DiagramLabelProvider.LabelDirection arrowDirection;
    private final double value;

    public DirectionalFeederInfo(String componentType, DiagramLabelProvider.LabelDirection arrowDirection, String leftLabel, String rightLabel) {
        this(componentType, arrowDirection, leftLabel, rightLabel, null);
    }

    public DirectionalFeederInfo(String componentType, DiagramLabelProvider.LabelDirection arrowDirection, String leftLabel, String rightLabel, String userDefinedId) {
        super(componentType, leftLabel, rightLabel, userDefinedId);
        this.arrowDirection = Objects.requireNonNull(arrowDirection);
        this.value = Double.NaN;
    }

    public DirectionalFeederInfo(String componentType, double value, DoubleFunction<String> formatter) {
        this(componentType, value, formatter, null);
    }

    public DirectionalFeederInfo(String componentType, double value, DoubleFunction<String> formatter, String userDefinedId) {
        super(componentType, null, formatter.apply(value), userDefinedId);
        this.arrowDirection = Objects.requireNonNull(DirectionalFeederInfo.getArrowDirection(value));
        this.value = value;
    }

    private static DiagramLabelProvider.LabelDirection getArrowDirection(double value) {
        return value > 0.0 ? DiagramLabelProvider.LabelDirection.OUT : DiagramLabelProvider.LabelDirection.IN;
    }

    public DiagramLabelProvider.LabelDirection getDirection() {
        return this.arrowDirection;
    }

    public double getValue() {
        return this.value;
    }
}

