/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.svg;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.sld.layout.LayoutParameters;
import com.powsybl.sld.library.AnchorOrientation;
import com.powsybl.sld.library.AnchorPoint;
import com.powsybl.sld.library.Component;
import com.powsybl.sld.model.coordinate.Direction;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GraphMetadata {
    private final Map<String, Component> componentByType = new HashMap<String, Component>();
    private final Map<String, NodeMetadata> nodeMetadataMap = new HashMap<String, NodeMetadata>();
    private final Map<String, WireMetadata> wireMetadataMap = new HashMap<String, WireMetadata>();
    private final Map<String, LineMetadata> lineMetadataMap = new HashMap<String, LineMetadata>();
    private final LayoutParameters layoutParameters;
    private final Map<String, FeederInfoMetadata> feederInfoMetadataMap = new HashMap<String, FeederInfoMetadata>();
    private final Map<String, ElectricalNodeInfoMetadata> electricalNodeInfoMetadataMap = new HashMap<String, ElectricalNodeInfoMetadata>();
    private final Map<String, BusInfoMetadata> busInfoMetadataMap = new HashMap<String, BusInfoMetadata>();

    public GraphMetadata(LayoutParameters layoutParameters) {
        this(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), layoutParameters);
    }

    @JsonCreator
    public GraphMetadata(@JsonProperty(value="components") List<Component> componentList, @JsonProperty(value="nodes") List<NodeMetadata> nodeMetadataList, @JsonProperty(value="wires") List<WireMetadata> wireMetadataList, @JsonProperty(value="lines") List<LineMetadata> lineMetadataList, @JsonProperty(value="feederInfos") List<FeederInfoMetadata> feederInfoMetadataList, @JsonProperty(value="electricalNodeInfos") List<ElectricalNodeInfoMetadata> electricalNodeInfoMetadataList, @JsonProperty(value="busInfos") List<BusInfoMetadata> busInfoMetadataList, @JsonProperty(value="layoutParams") LayoutParameters layoutParams) {
        for (Component component : componentList) {
            this.addComponent(component);
        }
        for (NodeMetadata nodeMetadata : nodeMetadataList) {
            this.addNodeMetadata(nodeMetadata);
        }
        for (WireMetadata wireMetadata : wireMetadataList) {
            this.addWireMetadata(wireMetadata);
        }
        for (LineMetadata lineMetadata : lineMetadataList) {
            this.addLineMetadata(lineMetadata);
        }
        for (FeederInfoMetadata feederInfoMetadata : feederInfoMetadataList) {
            this.addFeederInfoMetadata(feederInfoMetadata);
        }
        for (ElectricalNodeInfoMetadata electricalNodeInfoMetadata : electricalNodeInfoMetadataList) {
            this.addElectricalNodeInfoMetadata(electricalNodeInfoMetadata);
        }
        for (BusInfoMetadata busInfoMetadata : busInfoMetadataList) {
            this.addBusInfoMetadata(busInfoMetadata);
        }
        this.layoutParameters = layoutParams;
    }

    public static GraphMetadata parseJson(Path file) {
        GraphMetadata graphMetadata;
        block8: {
            BufferedReader reader = Files.newBufferedReader(file);
            try {
                graphMetadata = GraphMetadata.parseJson(reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            ((Reader)reader).close();
        }
        return graphMetadata;
    }

    public static GraphMetadata parseJson(InputStream inputStream) {
        Objects.requireNonNull(inputStream);
        ObjectMapper objectMapper = JsonUtil.createObjectMapper();
        try {
            return (GraphMetadata)objectMapper.readValue(inputStream, GraphMetadata.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static GraphMetadata parseJson(Reader reader) {
        Objects.requireNonNull(reader);
        ObjectMapper objectMapper = JsonUtil.createObjectMapper();
        try {
            return (GraphMetadata)objectMapper.readValue(reader, GraphMetadata.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void writeJson(Path file) {
        Objects.requireNonNull(file);
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.writeJson(writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void writeJson(Writer writer) {
        Objects.requireNonNull(writer);
        ObjectMapper objectMapper = JsonUtil.createObjectMapper();
        try {
            objectMapper.writerWithDefaultPrettyPrinter().writeValue(writer, (Object)this);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void addComponent(Component component) {
        Objects.requireNonNull(component);
        this.componentByType.put(component.getType(), component);
    }

    public Component getComponentMetadata(String componentType) {
        return componentType != null ? this.componentByType.get(componentType) : null;
    }

    public List<AnchorPoint> getAnchorPoints(String type) {
        Component component = this.getComponentMetadata(type);
        return component != null ? component.getAnchorPoints() : Collections.singletonList(new AnchorPoint(0.0, 0.0, AnchorOrientation.NONE));
    }

    @JsonProperty(value="components")
    public List<Component> getComponentMetadata() {
        return ImmutableList.copyOf(this.componentByType.values());
    }

    public void addNodeMetadata(NodeMetadata metadata) {
        Objects.requireNonNull(metadata);
        this.nodeMetadataMap.put(metadata.getId(), metadata);
    }

    public NodeMetadata getNodeMetadata(String id) {
        Objects.requireNonNull(id);
        return this.nodeMetadataMap.get(id);
    }

    @JsonProperty(value="nodes")
    public List<NodeMetadata> getNodeMetadata() {
        return ImmutableList.copyOf(this.nodeMetadataMap.values());
    }

    public void addWireMetadata(WireMetadata metadata) {
        Objects.requireNonNull(metadata);
        this.wireMetadataMap.put(metadata.getId(), metadata);
    }

    public WireMetadata getWireMetadata(String id) {
        Objects.requireNonNull(id);
        return this.wireMetadataMap.get(id);
    }

    @JsonProperty(value="wires")
    public List<WireMetadata> getWireMetadata() {
        return ImmutableList.copyOf(this.wireMetadataMap.values());
    }

    public void addLineMetadata(LineMetadata metadata) {
        Objects.requireNonNull(metadata);
        this.lineMetadataMap.put(metadata.getId(), metadata);
    }

    public LineMetadata getLineMetadata(String id) {
        Objects.requireNonNull(id);
        return this.lineMetadataMap.get(id);
    }

    @JsonProperty(value="lines")
    public List<LineMetadata> getLineMetadata() {
        return ImmutableList.copyOf(this.lineMetadataMap.values());
    }

    public void addFeederInfoMetadata(FeederInfoMetadata metadata) {
        Objects.requireNonNull(metadata);
        this.feederInfoMetadataMap.put(metadata.getId(), metadata);
    }

    public FeederInfoMetadata getFeederInfoMetadata(String id) {
        Objects.requireNonNull(id);
        return this.feederInfoMetadataMap.get(id);
    }

    @JsonProperty(value="feederInfos")
    public List<FeederInfoMetadata> getFeederInfoMetadata() {
        return ImmutableList.copyOf(this.feederInfoMetadataMap.values());
    }

    public void addBusInfoMetadata(BusInfoMetadata metadata) {
        Objects.requireNonNull(metadata);
        this.busInfoMetadataMap.put(metadata.getId(), metadata);
    }

    public BusInfoMetadata getBusInfoMetadata(String id) {
        Objects.requireNonNull(id);
        return this.busInfoMetadataMap.get(id);
    }

    @JsonProperty(value="busInfos")
    public List<BusInfoMetadata> getBusInfoMetadata() {
        return ImmutableList.copyOf(this.busInfoMetadataMap.values());
    }

    public void addElectricalNodeInfoMetadata(ElectricalNodeInfoMetadata metadata) {
        Objects.requireNonNull(metadata);
        this.electricalNodeInfoMetadataMap.put(metadata.getId(), metadata);
    }

    public ElectricalNodeInfoMetadata getElectricalNodeInfoMetadata(String id) {
        Objects.requireNonNull(id);
        return this.electricalNodeInfoMetadataMap.get(id);
    }

    @JsonProperty(value="electricalNodeInfos")
    public List<ElectricalNodeInfoMetadata> getElectricalNodeInfoMetadata() {
        return ImmutableList.copyOf(this.electricalNodeInfoMetadataMap.values());
    }

    @JsonProperty(value="layoutParams")
    public LayoutParameters getLayoutParameters() {
        return this.layoutParameters;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class ElectricalNodeInfoMetadata {
        private final String id;
        private final String userDefinedId;

        @JsonCreator
        public ElectricalNodeInfoMetadata(@JsonProperty(value="id") String id, @JsonProperty(value="userDefinedId") String userDefinedId) {
            this.id = Objects.requireNonNull(id);
            this.userDefinedId = userDefinedId;
        }

        public String getId() {
            return this.id;
        }

        public String getUserDefinedId() {
            return this.userDefinedId;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class BusInfoMetadata {
        private final String id;
        private final String busNodeId;
        private final String userDefinedId;

        @JsonCreator
        public BusInfoMetadata(@JsonProperty(value="id") String id, @JsonProperty(value="busNodeId") String busNodeId, @JsonProperty(value="userDefinedId") String userDefinedId) {
            this.id = Objects.requireNonNull(id);
            this.busNodeId = Objects.requireNonNull(busNodeId);
            this.userDefinedId = userDefinedId;
        }

        public String getId() {
            return this.id;
        }

        public String getBusNodeId() {
            return this.busNodeId;
        }

        public String getUserDefinedId() {
            return this.userDefinedId;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class FeederInfoMetadata {
        private final String id;
        private final String equipmentId;
        private final String side;
        private final String userDefinedId;
        private final String componentType;

        @JsonCreator
        public FeederInfoMetadata(@JsonProperty(value="id") String id, @JsonProperty(value="equipmentId") String equipmentId, @JsonProperty(value="side") String side, @JsonProperty(value="componentType") String componentType, @JsonProperty(value="userDefinedId") String userDefinedId) {
            this.id = Objects.requireNonNull(id);
            this.equipmentId = Objects.requireNonNull(equipmentId);
            this.side = side;
            this.componentType = componentType;
            this.userDefinedId = userDefinedId;
        }

        public String getId() {
            return this.id;
        }

        public String getEquipmentId() {
            return this.equipmentId;
        }

        public String getSide() {
            return this.side;
        }

        public String getComponentType() {
            return this.componentType;
        }

        public String getUserDefinedId() {
            return this.userDefinedId;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class LineMetadata {
        private final String id;
        private final String nodeId1;
        private final String nodeId2;

        @JsonCreator
        public LineMetadata(@JsonProperty(value="id") String id, @JsonProperty(value="nodeId1") String nodeId1, @JsonProperty(value="nodeId2") String nodeId2) {
            this.id = Objects.requireNonNull(id);
            this.nodeId1 = Objects.requireNonNull(nodeId1);
            this.nodeId2 = Objects.requireNonNull(nodeId2);
        }

        public String getId() {
            return this.id;
        }

        public String getNodeId1() {
            return this.nodeId1;
        }

        public String getNodeId2() {
            return this.nodeId2;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class WireMetadata {
        private final String id;
        private final String nodeId1;
        private final String nodeId2;
        private final boolean straight;
        private final boolean snakeLine;

        @JsonCreator
        public WireMetadata(@JsonProperty(value="id") String id, @JsonProperty(value="nodeId1") String nodeId1, @JsonProperty(value="nodeId2") String nodeId2, @JsonProperty(value="straight") boolean straight, @JsonProperty(value="snakeline") boolean snakeline) {
            this.id = Objects.requireNonNull(id);
            this.nodeId1 = Objects.requireNonNull(nodeId1);
            this.nodeId2 = Objects.requireNonNull(nodeId2);
            this.straight = straight;
            this.snakeLine = snakeline;
        }

        public String getId() {
            return this.id;
        }

        public String getNodeId1() {
            return this.nodeId1;
        }

        public String getNodeId2() {
            return this.nodeId2;
        }

        public boolean isStraight() {
            return this.straight;
        }

        public boolean isSnakeLine() {
            return this.snakeLine;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class NodeLabelMetadata {
        private final String id;
        private final String positionName;
        private final String userDefinedId;

        @JsonCreator
        public NodeLabelMetadata(@JsonProperty(value="id") String id, @JsonProperty(value="positionName") String positionName, @JsonProperty(value="userDefinedId") String userDefinedId) {
            this.id = Objects.requireNonNull(id);
            this.positionName = Objects.requireNonNull(positionName);
            this.userDefinedId = userDefinedId;
        }

        public String getId() {
            return this.id;
        }

        public String getUserDefinedId() {
            return this.userDefinedId;
        }

        public String getPositionName() {
            return this.positionName;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class NodeMetadata {
        private final String id;
        private final String componentType;
        private final boolean open;
        private final String vId;
        private final String nextVId;
        private final Direction direction;
        private final boolean vLabel;
        private final String equipmentId;
        private final List<NodeLabelMetadata> labels;

        @JsonCreator
        public NodeMetadata(@JsonProperty(value="id") String id, @JsonProperty(value="vid") String vId, @JsonProperty(value="nextVId") String nextVId, @JsonProperty(value="componentType") String componentType, @JsonProperty(value="open") boolean open, @JsonProperty(value="direction") Direction direction, @JsonProperty(value="vlabel") boolean vLabel, @JsonProperty(value="equipmentId") String equipmentId, @JsonProperty(value="labels") List<NodeLabelMetadata> labels) {
            this.id = Objects.requireNonNull(id);
            this.vId = Objects.requireNonNull(vId);
            this.nextVId = nextVId;
            this.componentType = componentType;
            this.open = Objects.requireNonNull(open);
            this.direction = direction;
            this.vLabel = vLabel;
            this.equipmentId = equipmentId;
            this.labels = Objects.requireNonNull(labels);
        }

        public String getId() {
            return this.id;
        }

        public String getVId() {
            return this.vId;
        }

        public String getNextVId() {
            return this.nextVId;
        }

        public String getComponentType() {
            return this.componentType;
        }

        public boolean isOpen() {
            return this.open;
        }

        public Direction getDirection() {
            return this.direction;
        }

        @JsonProperty(value="direction")
        public Direction getNullableDirection() {
            return this.direction == Direction.UNDEFINED ? null : this.direction;
        }

        public boolean isVLabel() {
            return this.vLabel;
        }

        public String getEquipmentId() {
            return this.equipmentId;
        }

        public List<NodeLabelMetadata> getLabels() {
            return this.labels;
        }
    }
}

