/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.svg.styles;

import com.powsybl.sld.library.ComponentLibrary;
import com.powsybl.sld.model.cells.Cell;
import com.powsybl.sld.model.cells.ExternCell;
import com.powsybl.sld.model.cells.InternCell;
import com.powsybl.sld.model.cells.ShuntCell;
import com.powsybl.sld.model.coordinate.Direction;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.nodes.BranchEdge;
import com.powsybl.sld.model.nodes.FeederNode;
import com.powsybl.sld.model.nodes.Node;
import com.powsybl.sld.model.nodes.SwitchNode;
import com.powsybl.sld.svg.DiagramLabelProvider;
import com.powsybl.sld.svg.DirectionalFeederInfo;
import com.powsybl.sld.svg.FeederInfo;
import com.powsybl.sld.svg.styles.StyleClassConstants;
import com.powsybl.sld.svg.styles.StyleProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractStyleProvider
implements StyleProvider {
    @Override
    public List<String> getNodeStyles(VoltageLevelGraph graph, Node node, ComponentLibrary componentLibrary, boolean showInternalNodes) {
        ArrayList<String> styles = new ArrayList<String>();
        componentLibrary.getComponentStyleClass(node.getComponentType()).ifPresent(styles::add);
        if (graph != null) {
            Direction direction = graph.getDirection(node);
            if (node instanceof FeederNode && direction != Direction.UNDEFINED) {
                styles.add(direction == Direction.BOTTOM ? "sld-bottom-feeder" : "sld-top-feeder");
            }
        }
        if (!showInternalNodes && AbstractStyleProvider.isEquivalentToInternalNode(node)) {
            styles.add("sld-hidden-node");
        }
        if (node.getType() == Node.NodeType.SWITCH) {
            styles.add(((SwitchNode)node).isOpen() ? "sld-open" : "sld-closed");
        }
        if (node.isFictitious()) {
            styles.add("sld-fictitious");
        }
        return styles;
    }

    private static boolean isEquivalentToInternalNode(Node node) {
        return node.getComponentType().equals("NODE");
    }

    @Override
    public List<String> getNodeDecoratorStyles(DiagramLabelProvider.NodeDecorator nodeDecorator, Node node, ComponentLibrary componentLibrary) {
        return componentLibrary.getComponentStyleClass(nodeDecorator.getType()).map(List::of).orElse(Collections.emptyList());
    }

    @Override
    public List<String> getBranchEdgeStyles(BranchEdge edge, ComponentLibrary componentLibrary) {
        ArrayList<String> styles = new ArrayList<String>();
        styles.add("sld-wire");
        return styles;
    }

    @Override
    public List<String> getCellStyles(Cell cell) {
        if (cell instanceof ExternCell) {
            return List.of("sld-extern-cell", StyleClassConstants.buildStyle(cell.getDirection()));
        }
        if (cell instanceof InternCell) {
            return List.of("sld-intern-cell", StyleClassConstants.buildStyle(((InternCell)cell).getShape()));
        }
        if (cell instanceof ShuntCell) {
            return List.of("sld-shunt-cell");
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getFeederInfoStyles(FeederInfo info) {
        ArrayList<String> styles = new ArrayList<String>();
        styles.add("sld-feeder-info");
        if (info instanceof DirectionalFeederInfo) {
            styles.add(((DirectionalFeederInfo)info).getDirection() == DiagramLabelProvider.LabelDirection.OUT ? "sld-out" : "sld-in");
        }
        return styles;
    }
}

