/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.svg.styles;

import com.powsybl.commons.config.BaseVoltagesConfig;
import com.powsybl.sld.library.ComponentLibrary;
import com.powsybl.sld.model.graphs.Graph;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.graphs.VoltageLevelInfos;
import com.powsybl.sld.model.nodes.Edge;
import com.powsybl.sld.model.nodes.Feeder;
import com.powsybl.sld.model.nodes.FeederNode;
import com.powsybl.sld.model.nodes.Middle2WTNode;
import com.powsybl.sld.model.nodes.Middle3WTNode;
import com.powsybl.sld.model.nodes.Node;
import com.powsybl.sld.model.nodes.NodeSide;
import com.powsybl.sld.model.nodes.feeders.FeederTwLeg;
import com.powsybl.sld.model.nodes.feeders.FeederWithSides;
import com.powsybl.sld.svg.BusInfo;
import com.powsybl.sld.svg.styles.AbstractStyleProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractVoltageStyleProvider
extends AbstractStyleProvider {
    protected static final String BASE_VOLTAGE_PROFILE = "Default";
    private static final String WINDING1 = "WINDING1";
    private static final String WINDING2 = "WINDING2";
    private static final String WINDING3 = "WINDING3";
    protected final BaseVoltagesConfig baseVoltagesConfig;

    protected AbstractVoltageStyleProvider(BaseVoltagesConfig baseVoltagesConfig) {
        this.baseVoltagesConfig = Objects.requireNonNull(baseVoltagesConfig);
    }

    @Override
    public List<String> getEdgeStyles(Graph graph, Edge edge) {
        return this.getVoltageLevelEdgeStyle(graph, edge).map(vlStyle -> List.of("sld-wire", vlStyle)).orElse(List.of("sld-wire"));
    }

    protected Optional<String> getVoltageLevelEdgeStyle(Graph graph, Edge edge) {
        Node nodeForStyle = this.isNodeSeparatingStyles(edge.getNode1()) ? edge.getNode2() : edge.getNode1();
        VoltageLevelInfos vLevelInfos = nodeForStyle instanceof FeederNode && ((FeederNode)nodeForStyle).getFeeder() instanceof FeederTwLeg ? ((FeederTwLeg)((FeederNode)nodeForStyle).getFeeder()).getVoltageLevelInfos() : graph.getVoltageLevelInfos(nodeForStyle);
        return this.getVoltageLevelNodeStyle(vLevelInfos, nodeForStyle);
    }

    @Override
    public List<String> getNodeStyles(VoltageLevelGraph graph, Node node, ComponentLibrary componentLibrary, boolean showInternalNodes) {
        List<String> styles = super.getNodeStyles(graph, node, componentLibrary, showInternalNodes);
        if (graph != null && !this.isNodeSeparatingStyles(node)) {
            this.getVoltageLevelNodeStyle(graph.getVoltageLevelInfos(), node).ifPresent(styles::add);
        }
        return styles;
    }

    protected abstract boolean isNodeSeparatingStyles(Node var1);

    @Override
    public List<String> getNodeSubcomponentStyles(Graph graph, Node node, String subComponentName) {
        ArrayList<String> styles = new ArrayList<String>();
        VoltageLevelGraph g = graph.getVoltageLevelGraph(node);
        if (g != null) {
            if (this.isNodeSeparatingStyles(node)) {
                if (node instanceof FeederNode) {
                    Feeder feeder = ((FeederNode)node).getFeeder();
                    if (feeder instanceof FeederWithSides) {
                        VoltageLevelInfos vlInfo = this.getSubComponentVoltageLevelInfos((FeederWithSides)feeder, subComponentName);
                        this.getVoltageLevelNodeStyle(vlInfo, node).ifPresent(styles::add);
                    }
                } else if (node instanceof Middle3WTNode) {
                    VoltageLevelInfos vlInfo = this.getSubComponentVoltageLevelInfos((Middle3WTNode)node, subComponentName);
                    this.getVoltageLevelNodeStyle(vlInfo, node).ifPresent(styles::add);
                } else {
                    VoltageLevelInfos vlInfo = graph.getVoltageLevelInfos(node);
                    this.getVoltageLevelNodeStyle(vlInfo, node, this.getSide(subComponentName)).ifPresent(styles::add);
                }
            }
        } else {
            Node feederNode = null;
            if (node instanceof Middle2WTNode) {
                feederNode = this.getFeederNode((Middle2WTNode)node, subComponentName);
            } else if (node instanceof Middle3WTNode) {
                feederNode = this.getFeederNode((Middle3WTNode)node, subComponentName);
            }
            if (feederNode != null) {
                this.getVoltageLevelNodeStyle(graph.getVoltageLevelInfos(feederNode), feederNode).ifPresent(styles::add);
            }
        }
        return styles;
    }

    public abstract Optional<String> getVoltageLevelNodeStyle(VoltageLevelInfos var1, Node var2);

    public abstract Optional<String> getVoltageLevelNodeStyle(VoltageLevelInfos var1, Node var2, NodeSide var3);

    private Node getFeederNode(Middle3WTNode node, String subComponentName) {
        switch (subComponentName) {
            case "WINDING1": {
                return node.getAdjacentNode(Middle3WTNode.Winding.UPPER_LEFT);
            }
            case "WINDING2": {
                return node.getAdjacentNode(Middle3WTNode.Winding.UPPER_RIGHT);
            }
            case "WINDING3": {
                return node.getAdjacentNode(Middle3WTNode.Winding.DOWN);
            }
        }
        throw new IllegalStateException("Unexpected subComponent name: " + subComponentName);
    }

    private Node getFeederNode(Middle2WTNode node, String subComponentName) {
        return node.getAdjacentNodes().get(subComponentName.equals(WINDING1) ? 0 : 1);
    }

    protected VoltageLevelInfos getSubComponentVoltageLevelInfos(FeederWithSides feederWs, String subComponentName) {
        if (subComponentName.equals(WINDING2)) {
            return feederWs.getOtherSideVoltageLevelInfos();
        }
        return feederWs.getVoltageLevelInfos();
    }

    protected NodeSide getSide(String subComponentName) {
        return subComponentName.equals(WINDING2) ? NodeSide.TWO : NodeSide.ONE;
    }

    protected VoltageLevelInfos getSubComponentVoltageLevelInfos(Middle3WTNode node, String subComponentName) {
        switch (subComponentName) {
            case "WINDING1": {
                return node.getVoltageLevelInfos(Middle3WTNode.Winding.UPPER_LEFT);
            }
            case "WINDING2": {
                return node.getVoltageLevelInfos(Middle3WTNode.Winding.UPPER_RIGHT);
            }
            case "WINDING3": {
                return node.getVoltageLevelInfos(Middle3WTNode.Winding.DOWN);
            }
        }
        return null;
    }

    @Override
    public List<String> getBusInfoStyle(BusInfo info) {
        return Collections.emptyList();
    }
}

