/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.svg.styles;

import com.powsybl.sld.svg.DirectionalFeederInfo;
import com.powsybl.sld.svg.FeederInfo;
import com.powsybl.sld.svg.styles.EmptyStyleProvider;
import java.util.ArrayList;
import java.util.List;

public class AnimatedFeederInfoStyleProvider
extends EmptyStyleProvider {
    private static final String ARROW_ANIMATION = "sld-arrow-animation";
    private static final String ARROW_SPEED = "speed";
    private static final String ARROW_ANIMATION_NO_SPEED = "sld-arrow-animation-no-speed";
    private static final String ARROW_ANIMATION_LOW_SPEED = "sld-arrow-animation-low-speed";
    private static final String ARROW_ANIMATION_AVERAGE_SPEED = "sld-arrow-animation-average-speed";
    private static final String ARROW_ANIMATION_HIGH_SPEED = "sld-arrow-animation-high-speed";
    private final double threshold1;
    private final double threshold2;

    public AnimatedFeederInfoStyleProvider(double threshold1, double threshold2) {
        this.threshold1 = threshold1;
        this.threshold2 = threshold2;
    }

    @Override
    public List<String> getFeederInfoStyles(FeederInfo info) {
        ArrayList<String> styles = new ArrayList<String>(super.getFeederInfoStyles(info));
        if (info instanceof DirectionalFeederInfo) {
            DirectionalFeederInfo feederInfo = (DirectionalFeederInfo)info;
            feederInfo.getRightLabel().ifPresent(label -> {
                double value = Math.abs(feederInfo.getValue());
                if (!Double.isNaN(value) && value > 0.0) {
                    if (value > this.threshold2) {
                        styles.add(ARROW_ANIMATION_HIGH_SPEED);
                    } else if (value > this.threshold1) {
                        styles.add(ARROW_ANIMATION_AVERAGE_SPEED);
                    } else {
                        styles.add(ARROW_ANIMATION_LOW_SPEED);
                    }
                } else {
                    styles.add(ARROW_ANIMATION_NO_SPEED);
                }
            });
        } else {
            styles.add(ARROW_ANIMATION_NO_SPEED);
        }
        return styles;
    }

    @Override
    public List<String> getCssFilenames() {
        return List.of("animations.css");
    }
}

