/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.svg.styles;

import com.powsybl.commons.config.BaseVoltagesConfig;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.graphs.VoltageLevelInfos;
import com.powsybl.sld.model.nodes.Feeder;
import com.powsybl.sld.model.nodes.FeederNode;
import com.powsybl.sld.model.nodes.Middle3WTNode;
import com.powsybl.sld.model.nodes.Node;
import com.powsybl.sld.model.nodes.NodeSide;
import com.powsybl.sld.model.nodes.feeders.FeederTwLeg;
import com.powsybl.sld.model.nodes.feeders.FeederWithSides;
import com.powsybl.sld.svg.BusInfo;
import com.powsybl.sld.svg.styles.AbstractVoltageStyleProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class NominalVoltageStyleProvider
extends AbstractVoltageStyleProvider {
    public NominalVoltageStyleProvider() {
        this(BaseVoltagesConfig.fromPlatformConfig());
    }

    public NominalVoltageStyleProvider(BaseVoltagesConfig baseVoltagesConfig) {
        super(baseVoltagesConfig);
    }

    @Override
    protected boolean isNodeSeparatingStyles(Node node) {
        if (node instanceof FeederNode) {
            Feeder feeder = ((FeederNode)node).getFeeder();
            return feeder instanceof FeederWithSides && !(feeder instanceof FeederTwLeg);
        }
        return node instanceof Middle3WTNode;
    }

    @Override
    public Optional<String> getVoltageLevelNodeStyle(VoltageLevelInfos vlInfo, Node node) {
        return this.baseVoltagesConfig.getBaseVoltageName(vlInfo.getNominalVoltage(), "Default").map(bvName -> "sld-" + bvName);
    }

    @Override
    public Optional<String> getVoltageLevelNodeStyle(VoltageLevelInfos vlInfo, Node node, NodeSide side) {
        return this.getVoltageLevelNodeStyle(vlInfo, node);
    }

    @Override
    public List<String> getBusStyles(String busId, VoltageLevelGraph graph) {
        return this.getVoltageLevelNodeStyle(graph.getVoltageLevelInfos(), null).map(vlStyle -> List.of(vlStyle, "sld-node-infos")).orElse(List.of("sld-node-infos"));
    }

    @Override
    public List<String> getBusInfoStyle(BusInfo info) {
        return Collections.emptyList();
    }

    @Override
    public void reset() {
    }

    @Override
    public List<String> getCssFilenames() {
        return Arrays.asList("tautologies.css", "baseVoltages.css");
    }
}

