/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.svg.styles.iidm;

import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.sld.model.graphs.Graph;
import com.powsybl.sld.model.nodes.Edge;
import com.powsybl.sld.model.nodes.FeederNode;
import com.powsybl.sld.model.nodes.FeederType;
import com.powsybl.sld.model.nodes.Node;
import com.powsybl.sld.model.nodes.NodeSide;
import com.powsybl.sld.model.nodes.feeders.FeederWithSides;
import com.powsybl.sld.svg.styles.EmptyStyleProvider;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HighlightLineStateStyleProvider
extends EmptyStyleProvider {
    private final Network network;

    public HighlightLineStateStyleProvider(Network network) {
        this.network = network;
    }

    @Override
    public List<String> getEdgeStyles(Graph graph, Edge edge) {
        return this.getHighlightLineStateStyle(graph, edge).map(List::of).orElse(Collections.emptyList());
    }

    private Optional<String> getHighlightLineStateStyle(Graph graph, Edge edge) {
        Node n1 = edge.getNode1();
        Node n2 = edge.getNode2();
        if (n1 instanceof FeederNode || n2 instanceof FeederNode) {
            FeederNode n = (FeederNode)(n1 instanceof FeederNode ? n1 : n2);
            if (n.getFeeder() instanceof FeederWithSides) {
                return this.getHighlightFeederStateStyle(graph, n);
            }
        } else {
            return Optional.empty();
        }
        return Optional.empty();
    }

    protected Optional<String> getHighlightFeederStateStyle(Graph graph, FeederNode n) {
        FeederWithSides feederWs = (FeederWithSides)n.getFeeder();
        Map<NodeSide, Boolean> connectionStatus = this.connectionStatus(n);
        NodeSide side = null;
        NodeSide otherSide = null;
        if (feederWs.getFeederType() == FeederType.BRANCH || feederWs.getFeederType() == FeederType.TWO_WINDINGS_TRANSFORMER_LEG) {
            side = feederWs.getSide();
            otherSide = HighlightLineStateStyleProvider.getOtherSide(side);
            if ("LINE".equals(n.getComponentType())) {
                side = Boolean.TRUE.equals(connectionStatus.get((Object)side)) ? side : otherSide;
                otherSide = HighlightLineStateStyleProvider.getOtherSide(side);
            }
        } else if (feederWs.getFeederType() == FeederType.THREE_WINDINGS_TRANSFORMER_LEG) {
            String idVl = graph.getVoltageLevelInfos(n).getId();
            ThreeWindingsTransformer transformer = this.network.getThreeWindingsTransformer(n.getEquipmentId());
            if (transformer != null) {
                side = HighlightLineStateStyleProvider.getTransformerSide(idVl, transformer);
            }
            otherSide = feederWs.getSide();
        }
        return HighlightLineStateStyleProvider.getFeederStateStyle(side, otherSide, connectionStatus);
    }

    protected Map<NodeSide, Boolean> connectionStatus(FeederNode node) {
        ThreeWindingsTransformer transformer;
        EnumMap<NodeSide, Boolean> res = new EnumMap<NodeSide, Boolean>(NodeSide.class);
        if (node.getFeeder().getFeederType() == FeederType.BRANCH || node.getFeeder().getFeederType() == FeederType.TWO_WINDINGS_TRANSFORMER_LEG) {
            Branch branch = this.network.getBranch(node.getEquipmentId());
            if (branch != null) {
                res.put(NodeSide.ONE, branch.getTerminal(Branch.Side.ONE).isConnected());
                res.put(NodeSide.TWO, branch.getTerminal(Branch.Side.TWO).isConnected());
            }
        } else if (node.getFeeder().getFeederType() == FeederType.THREE_WINDINGS_TRANSFORMER_LEG && (transformer = this.network.getThreeWindingsTransformer(node.getEquipmentId())) != null) {
            res.put(NodeSide.ONE, transformer.getTerminal(ThreeWindingsTransformer.Side.ONE).isConnected());
            res.put(NodeSide.TWO, transformer.getTerminal(ThreeWindingsTransformer.Side.TWO).isConnected());
            res.put(NodeSide.THREE, transformer.getTerminal(ThreeWindingsTransformer.Side.THREE).isConnected());
        }
        return res;
    }

    private static NodeSide getOtherSide(NodeSide side) {
        return side == NodeSide.ONE ? NodeSide.TWO : NodeSide.ONE;
    }

    private static NodeSide getTransformerSide(String idVl, ThreeWindingsTransformer transformer) {
        if (transformer.getTerminal(ThreeWindingsTransformer.Side.ONE).getVoltageLevel().getId().equals(idVl)) {
            return NodeSide.ONE;
        }
        if (transformer.getTerminal(ThreeWindingsTransformer.Side.TWO).getVoltageLevel().getId().equals(idVl)) {
            return NodeSide.TWO;
        }
        return NodeSide.THREE;
    }

    private static Optional<String> getFeederStateStyle(NodeSide side, NodeSide otherSide, Map<NodeSide, Boolean> connectionStatus) {
        if (side != null && otherSide != null) {
            if (Boolean.FALSE.equals(connectionStatus.get((Object)side)) && Boolean.FALSE.equals(connectionStatus.get((Object)otherSide))) {
                return Optional.of("sld-feeder-disconnected");
            }
            if (Boolean.TRUE.equals(connectionStatus.get((Object)side)) && Boolean.FALSE.equals(connectionStatus.get((Object)otherSide))) {
                return Optional.of("sld-feeder-connected-disconnected");
            }
            if (Boolean.FALSE.equals(connectionStatus.get((Object)side)) && Boolean.TRUE.equals(connectionStatus.get((Object)otherSide))) {
                return Optional.of("sld-feeder-disconnected-connected");
            }
        }
        return Optional.empty();
    }

    @Override
    public List<String> getCssFilenames() {
        return List.of("highlightLineStates.css");
    }
}

