/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.svg.styles.iidm;

import com.powsybl.commons.config.BaseVoltagesConfig;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.sld.model.graphs.Graph;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.graphs.VoltageLevelInfos;
import com.powsybl.sld.model.nodes.Edge;
import com.powsybl.sld.model.nodes.EquipmentNode;
import com.powsybl.sld.model.nodes.FeederNode;
import com.powsybl.sld.model.nodes.Node;
import com.powsybl.sld.model.nodes.NodeSide;
import com.powsybl.sld.model.nodes.SwitchNode;
import com.powsybl.sld.model.nodes.feeders.FeederTwLeg;
import com.powsybl.sld.svg.styles.AbstractVoltageStyleProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class TopologicalStyleProvider
extends AbstractVoltageStyleProvider {
    private final Map<String, Map<String, String>> vlNodeIdStyleMap = new HashMap<String, Map<String, String>>();
    private final Map<String, Map<String, String>> vlBusIdStyleMap = new HashMap<String, Map<String, String>>();
    private final Map<String, Integer> stylesIndices = new HashMap<String, Integer>();
    private final Network network;

    public TopologicalStyleProvider(Network network) {
        this(BaseVoltagesConfig.fromPlatformConfig(), network);
    }

    public TopologicalStyleProvider(BaseVoltagesConfig baseVoltagesConfig, Network network) {
        super(baseVoltagesConfig);
        this.network = network;
    }

    @Override
    protected Optional<String> getVoltageLevelEdgeStyle(Graph graph, Edge edge) {
        Node node1 = edge.getNode1();
        Node node2 = edge.getNode2();
        if (node1.getType() == Node.NodeType.SWITCH && ((SwitchNode)node1).isOpen()) {
            return this.getSwitchEdgeStyle(graph, node2);
        }
        if (node2.getType() == Node.NodeType.SWITCH && ((SwitchNode)node2).isOpen()) {
            return this.getSwitchEdgeStyle(graph, node1);
        }
        return super.getVoltageLevelEdgeStyle(graph, edge);
    }

    private Optional<String> getSwitchEdgeStyle(Graph graph, Node node) {
        return graph.getVoltageLevelInfos(node) != null ? this.getVoltageLevelNodeStyle(graph.getVoltageLevelInfos(node), node) : Optional.empty();
    }

    @Override
    protected boolean isNodeSeparatingStyles(Node node) {
        return this.isMultiTerminalNode(node) && (!(node instanceof FeederNode) || !(((FeederNode)node).getFeeder() instanceof FeederTwLeg));
    }

    private boolean isMultiTerminalNode(Node node) {
        Identifiable identifiable;
        if (node instanceof EquipmentNode && (identifiable = this.network.getIdentifiable(((EquipmentNode)node).getEquipmentId())) instanceof Connectable) {
            return ((Connectable)identifiable).getTerminals().size() > 1;
        }
        return false;
    }

    @Override
    public void reset() {
        this.vlNodeIdStyleMap.clear();
        this.vlBusIdStyleMap.clear();
    }

    private Map<String, String> createBusIdStyleMap(String baseVoltageLevelStyle, String vlId) {
        List buses = this.network.getVoltageLevel(vlId).getBusView().getBusStream().collect(Collectors.toList());
        HashMap<String, String> busIdStyleMap = new HashMap<String, String>();
        for (Bus b : buses) {
            int newIndex = this.stylesIndices.compute(baseVoltageLevelStyle, (s, i) -> i == null ? 0 : i + 1);
            String style = baseVoltageLevelStyle + "-" + newIndex;
            busIdStyleMap.put(b.getId(), style);
        }
        return busIdStyleMap;
    }

    private Optional<String> getNodeTopologicalStyle(String baseVoltageLevelStyle, String vlId, Node node) {
        Map busIdStyleMap = this.vlBusIdStyleMap.computeIfAbsent(vlId, k -> this.createBusIdStyleMap(baseVoltageLevelStyle, vlId));
        Map nodeIdStyleMap = this.vlNodeIdStyleMap.computeIfAbsent(vlId, k -> new HashMap());
        String nodeTopologicalStyle = (String)nodeIdStyleMap.get(node.getId());
        if (nodeTopologicalStyle == null) {
            nodeTopologicalStyle = this.findConnectedStyle(vlId, busIdStyleMap, nodeIdStyleMap, node);
        }
        return Optional.ofNullable(nodeTopologicalStyle);
    }

    private String findConnectedStyle(String vlId, Map<String, String> busIdStyleMap, Map<String, String> nodeIdStyleMap, Node node) {
        LinkedHashSet<Node> connectedNodes = new LinkedHashSet<Node>();
        this.findConnectedNodes(node, connectedNodes);
        String connectedStyle = this.getConnectedStyle(vlId, busIdStyleMap, connectedNodes);
        connectedNodes.forEach(n -> nodeIdStyleMap.put(n.getId(), connectedStyle));
        return connectedStyle;
    }

    private String getConnectedStyle(String vlId, Map<String, String> busIdStyleMap, Set<Node> connectedNodes) {
        return connectedNodes.stream().filter(EquipmentNode.class::isInstance).map(EquipmentNode.class::cast).map(en -> this.network.getIdentifiable(en.getEquipmentId())).filter(identifiable -> identifiable instanceof Connectable).map(i -> (Connectable)i).map(c -> {
            List terminals = c.getTerminals().stream().filter(t -> t.getVoltageLevel().getId().equals(vlId)).collect(Collectors.toList());
            if (terminals.size() == 1) {
                Bus bus = ((Terminal)terminals.get(0)).getBusView().getBus();
                return bus != null ? bus.getId() : null;
            }
            return null;
        }).filter(Objects::nonNull).map(busIdStyleMap::get).findFirst().orElse("sld-disconnected");
    }

    private void findConnectedNodes(Node node, Set<Node> visitedNodes) {
        if (visitedNodes.contains(node)) {
            return;
        }
        if (node.getType() == Node.NodeType.SWITCH && ((SwitchNode)node).isOpen()) {
            return;
        }
        if (this.isMultiTerminalInternalNode(node)) {
            visitedNodes.add(node);
            return;
        }
        visitedNodes.add(node);
        for (Node adjNode : node.getAdjacentNodes()) {
            this.findConnectedNodes(adjNode, visitedNodes);
        }
    }

    private boolean isMultiTerminalInternalNode(Node node) {
        return this.isMultiTerminalNode(node) && node.getAdjacentEdges().size() > 1;
    }

    @Override
    public Optional<String> getVoltageLevelNodeStyle(VoltageLevelInfos voltageLevelInfos, Node node) {
        if (node.getType() == Node.NodeType.SWITCH && ((SwitchNode)node).isOpen()) {
            return Optional.of("sld-disconnected");
        }
        String style = Optional.ofNullable(voltageLevelInfos).flatMap(vli -> this.baseVoltagesConfig.getBaseVoltageName(vli.getNominalVoltage(), "Default")).flatMap(baseVoltageName -> this.getNodeTopologicalStyle("sld-" + baseVoltageName, voltageLevelInfos.getId(), node)).orElse("sld-disconnected");
        return Optional.of(style);
    }

    @Override
    public Optional<String> getVoltageLevelNodeStyle(VoltageLevelInfos vlInfo, Node node, NodeSide side) {
        return this.getVoltageLevelNodeStyle(vlInfo, node.getAdjacentNodes().get(side.getIntValue() - 1));
    }

    @Override
    public List<String> getBusStyles(String busId, VoltageLevelGraph graph) {
        String busStyle = this.vlBusIdStyleMap.getOrDefault(graph.getVoltageLevelInfos().getId(), Collections.emptyMap()).getOrDefault(busId, null);
        return busStyle != null ? List.of(busStyle, "sld-node-infos") : List.of("sld-node-infos");
    }

    @Override
    public List<String> getCssFilenames() {
        return Arrays.asList("tautologies.css", "topologicalBaseVoltages.css");
    }
}

