/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public final class IdUtil {
    private static final String ID_PREFIX = "id";

    private IdUtil() {
    }

    public static String escapeClassName(String input) {
        Objects.requireNonNull(input);
        String temp = input;
        if (temp.length() < 2) {
            temp = StringUtils.leftPad((String)temp, (int)2, (String)"_");
        }
        return IdUtil.escape(temp);
    }

    public static String escapeId(String input) {
        Objects.requireNonNull(input);
        String temp = ID_PREFIX + input;
        return IdUtil.escape(temp);
    }

    public static String unescapeId(String input) {
        Objects.requireNonNull(input);
        return IdUtil.unescape(input.substring(ID_PREFIX.length()));
    }

    public static String escape(String input) {
        Objects.requireNonNull(input);
        StringBuilder sb = new StringBuilder();
        char[] chars = input.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isAlphabetic(chars[i]) || Character.isDigit(chars[i])) {
                sb.append(chars[i]);
                continue;
            }
            sb.append("_").append((int)chars[i]).append("_");
        }
        return sb.toString();
    }

    public static String unescape(String input) {
        Objects.requireNonNull(input);
        StringBuilder out = new StringBuilder();
        StringReader sr = new StringReader(input);
        try {
            int c = sr.read();
            while (c != -1) {
                if (c == 95) {
                    StringBuilder sb = new StringBuilder();
                    int n = sr.read();
                    while (n != 95 && n != -1) {
                        sb.append((char)n);
                        n = sr.read();
                    }
                    int x = Integer.parseInt(sb.toString());
                    out.append((char)x);
                } else {
                    out.append((char)c);
                }
                c = sr.read();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return out.toString();
    }
}

