/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.iidm.extensions;

import com.powsybl.commons.extensions.AbstractExtension;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.sld.iidm.extensions.ConnectablePosition;
import java.util.Objects;
import java.util.Optional;

public class ConnectablePositionImpl<C extends Connectable<C>>
extends AbstractExtension<C>
implements ConnectablePosition<C> {
    private FeederImpl feeder;
    private FeederImpl feeder1;
    private FeederImpl feeder2;
    private FeederImpl feeder3;

    public ConnectablePositionImpl(C connectable, FeederImpl feeder, FeederImpl feeder1, FeederImpl feeder2, FeederImpl feeder3) {
        super(connectable);
        ConnectablePosition.check(feeder, feeder1, feeder2, feeder3);
        this.feeder = feeder;
        this.feeder1 = feeder1;
        this.feeder2 = feeder2;
        this.feeder3 = feeder3;
    }

    @Override
    public FeederImpl getFeeder() {
        return this.feeder;
    }

    @Override
    public FeederImpl getFeeder1() {
        return this.feeder1;
    }

    @Override
    public FeederImpl getFeeder2() {
        return this.feeder2;
    }

    @Override
    public FeederImpl getFeeder3() {
        return this.feeder3;
    }

    public static class FeederImpl
    implements ConnectablePosition.Feeder {
        private String name;
        private Integer order;
        private ConnectablePosition.Direction direction;

        public FeederImpl(String name) {
            this(name, null, null);
        }

        public FeederImpl(String name, int order) {
            this(name, order, null);
        }

        public FeederImpl(String name, ConnectablePosition.Direction direction) {
            this(name, null, direction);
        }

        public FeederImpl(String name, Integer order, ConnectablePosition.Direction direction) {
            this.name = Objects.requireNonNull(name);
            this.order = order;
            this.direction = Objects.requireNonNullElse(direction, ConnectablePosition.Direction.UNDEFINED);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ConnectablePosition.Feeder setName(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        @Override
        public Optional<Integer> getOrder() {
            return Optional.ofNullable(this.order);
        }

        @Override
        public ConnectablePosition.Feeder setOrder(int order) {
            this.order = order;
            return this;
        }

        @Override
        public ConnectablePosition.Feeder removeOrder() {
            this.order = null;
            return this;
        }

        @Override
        public ConnectablePosition.Direction getDirection() {
            return this.direction;
        }

        @Override
        public ConnectablePosition.Feeder setDirection(ConnectablePosition.Direction direction) {
            this.direction = Objects.requireNonNull(direction);
            return this;
        }
    }
}

