/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.iidm.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.xml.XmlReaderContext;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.commons.xml.XmlWriterContext;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.sld.iidm.extensions.ConnectablePosition;
import com.powsybl.sld.iidm.extensions.ConnectablePositionAdder;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

@AutoService(value=ExtensionXmlSerializer.class)
public class ConnectablePositionXmlSerializer<C extends Connectable<C>>
implements ExtensionXmlSerializer<C, ConnectablePosition<C>> {
    public String getExtensionName() {
        return "position";
    }

    public String getCategoryName() {
        return "network";
    }

    public Class<? super ConnectablePosition> getExtensionClass() {
        return ConnectablePosition.class;
    }

    public boolean hasSubElements() {
        return true;
    }

    public InputStream getXsdAsStream() {
        return this.getClass().getResourceAsStream("/xsd/connectablePosition.xsd");
    }

    public String getNamespaceUri() {
        return "http://www.itesla_project.eu/schema/iidm/ext/connectable_position/1_0";
    }

    public String getNamespacePrefix() {
        return "cp";
    }

    private void writePosition(ConnectablePosition.Feeder feeder, Integer i, XmlWriterContext context) throws XMLStreamException {
        context.getExtensionsWriter().writeEmptyElement(this.getNamespaceUri(), "feeder" + (Serializable)(i != null ? i : ""));
        context.getExtensionsWriter().writeAttribute("name", feeder.getName());
        Optional<Integer> oOrder = feeder.getOrder();
        if (oOrder.isPresent()) {
            XmlUtil.writeInt((String)"order", (int)oOrder.get(), (XMLStreamWriter)context.getExtensionsWriter());
        }
        context.getExtensionsWriter().writeAttribute("direction", feeder.getDirection().name());
    }

    public void write(ConnectablePosition connectablePosition, XmlWriterContext context) throws XMLStreamException {
        if (connectablePosition.getFeeder() != null) {
            this.writePosition(connectablePosition.getFeeder(), null, context);
        }
        if (connectablePosition.getFeeder1() != null) {
            this.writePosition(connectablePosition.getFeeder1(), 1, context);
        }
        if (connectablePosition.getFeeder2() != null) {
            this.writePosition(connectablePosition.getFeeder2(), 2, context);
        }
        if (connectablePosition.getFeeder3() != null) {
            this.writePosition(connectablePosition.getFeeder3(), 3, context);
        }
    }

    private void readPosition(XmlReaderContext context, ConnectablePositionAdder.FeederAdder adder) {
        String name = context.getReader().getAttributeValue(null, "name");
        Optional.ofNullable(XmlUtil.readOptionalIntegerAttribute((XMLStreamReader)context.getReader(), (String)"order")).ifPresent(adder::withOrder);
        ConnectablePosition.Direction direction = ConnectablePosition.Direction.valueOf(context.getReader().getAttributeValue(null, "direction"));
        adder.withName(name).withDirection(direction).add();
    }

    public ConnectablePosition read(Connectable connectable, XmlReaderContext context) throws XMLStreamException {
        ConnectablePositionAdder adder = (ConnectablePositionAdder)connectable.newExtension(ConnectablePositionAdder.class);
        XmlUtil.readUntilEndElement((String)this.getExtensionName(), (XMLStreamReader)context.getReader(), () -> {
            switch (context.getReader().getLocalName()) {
                case "feeder": {
                    this.readPosition(context, adder.newFeeder());
                    break;
                }
                case "feeder1": {
                    this.readPosition(context, adder.newFeeder1());
                    break;
                }
                case "feeder2": {
                    this.readPosition(context, adder.newFeeder2());
                    break;
                }
                case "feeder3": {
                    this.readPosition(context, adder.newFeeder3());
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        });
        adder.add();
        return (ConnectablePosition)connectable.getExtension(ConnectablePosition.class);
    }
}

