/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.commons.json.JsonUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.stream.IntStream;

public abstract class AbstractCompressedDataChunk {
    protected final int offset;
    protected final int uncompressedLength;
    protected final int[] stepLengths;

    public AbstractCompressedDataChunk(int offset, int uncompressedLength, int[] stepLengths) {
        this.offset = offset;
        this.uncompressedLength = uncompressedLength;
        this.stepLengths = Objects.requireNonNull(stepLengths);
        AbstractCompressedDataChunk.check(uncompressedLength, stepLengths);
    }

    static void check(int offset, int uncompressedLength, int stepValuesLength, int stepLengthsLength) {
        if (offset < 0) {
            throw new IllegalArgumentException("Bad offset value " + offset);
        }
        if (uncompressedLength < 1) {
            throw new IllegalArgumentException("Bad uncompressed length value " + offset);
        }
        if (stepValuesLength != stepLengthsLength) {
            throw new IllegalArgumentException("Inconsistent step arrays size: " + stepValuesLength + " != " + stepLengthsLength);
        }
        if (stepValuesLength < 1) {
            throw new IllegalArgumentException("Bad step arrays length " + stepValuesLength);
        }
    }

    static void check(int uncompressedLength, int[] stepLengths) {
        if (IntStream.of(stepLengths).sum() != uncompressedLength) {
            throw new IllegalArgumentException("Inconsistent uncompressedLength length: " + uncompressedLength + " with sum of step length");
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public int[] getStepLengths() {
        return this.stepLengths;
    }

    public int getUncompressedLength() {
        return this.uncompressedLength;
    }

    public int getLength() {
        return this.uncompressedLength;
    }

    public boolean isCompressed() {
        return true;
    }

    protected abstract int getEstimatedSize();

    protected abstract int getUncompressedEstimatedSize();

    public double getCompressionFactor() {
        return (double)this.getEstimatedSize() / (double)this.getUncompressedEstimatedSize();
    }

    protected abstract void writeStepValuesJson(JsonGenerator var1) throws IOException;

    public void writeJson(JsonGenerator generator) {
        Objects.requireNonNull(generator);
        try {
            generator.writeStartObject();
            generator.writeNumberField("offset", this.offset);
            generator.writeNumberField("uncompressedLength", this.uncompressedLength);
            generator.writeFieldName("stepValues");
            this.writeStepValuesJson(generator);
            generator.writeFieldName("stepLengths");
            generator.writeArray(this.stepLengths, 0, this.stepLengths.length);
            generator.writeEndObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toJson() {
        return JsonUtil.toJson(this::writeJson);
    }
}

