/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.collect.Iterators;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.timeseries.AbstractPoint;
import com.powsybl.timeseries.DataChunk;
import com.powsybl.timeseries.TimeSeries;
import com.powsybl.timeseries.TimeSeriesException;
import com.powsybl.timeseries.TimeSeriesIndex;
import com.powsybl.timeseries.TimeSeriesMetadata;
import com.powsybl.timeseries.TimeSeriesNameResolver;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTimeSeries<P extends AbstractPoint, C extends DataChunk<P, C>, T extends TimeSeries<P, T>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTimeSeries.class);
    protected final TimeSeriesMetadata metadata;
    protected final List<C> chunks;

    protected AbstractTimeSeries(TimeSeriesMetadata metadata, C ... chunks) {
        this(metadata, Arrays.asList(chunks));
    }

    protected AbstractTimeSeries(TimeSeriesMetadata metadata, List<C> chunks) {
        this.metadata = Objects.requireNonNull(metadata);
        this.chunks = Objects.requireNonNull(chunks);
    }

    public void synchronize(TimeSeriesIndex newIndex) {
        Objects.requireNonNull(newIndex);
        if (!this.metadata.getIndex().equals(newIndex)) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }

    public void addChunk(C chunk) {
        Objects.requireNonNull(chunk);
        this.chunks.add(chunk);
    }

    public List<C> getChunks() {
        return this.chunks;
    }

    public TimeSeriesMetadata getMetadata() {
        return this.metadata;
    }

    protected abstract C createGapFillingChunk(int var1, int var2);

    private List<C> getSortedChunks() {
        return this.chunks.stream().sorted(Comparator.comparing(DataChunk::getOffset)).collect(Collectors.toList());
    }

    private List<C> getCheckedChunks(boolean fillGap) {
        List<C> sortedChunks = this.getSortedChunks();
        int pointCount = this.metadata.getIndex().getPointCount();
        int i = 0;
        ArrayList<Object> checkedChunks = new ArrayList<Object>(sortedChunks.size());
        for (DataChunk chunk : sortedChunks) {
            if (chunk.getOffset() > pointCount - 1) {
                throw new TimeSeriesException("Chunk offset " + chunk.getOffset() + " is out of index range [" + (pointCount - 1) + ", " + (i + chunk.getLength()) + "]");
            }
            if (chunk.getOffset() < i) {
                throw new TimeSeriesException("Chunk at offset " + chunk.getOffset() + " overlap with previous one");
            }
            if (i + chunk.getLength() > pointCount) {
                throw new TimeSeriesException("Chunk value at " + (i + chunk.getLength()) + " is out of index range [" + (pointCount - 1) + ", " + (i + chunk.getLength()) + "]");
            }
            if (chunk.getOffset() > i) {
                if (fillGap) {
                    checkedChunks.add(this.createGapFillingChunk(i, chunk.getOffset() - i));
                }
                i = chunk.getOffset();
            }
            checkedChunks.add(chunk);
            i += chunk.getLength();
        }
        if (fillGap && i < pointCount) {
            checkedChunks.add(this.createGapFillingChunk(i, pointCount - i));
        }
        return checkedChunks;
    }

    public Stream<P> stream() {
        return this.getCheckedChunks(true).stream().flatMap(chunk -> chunk.stream(this.metadata.getIndex()));
    }

    public Iterator<P> iterator() {
        return Iterators.concat(this.getCheckedChunks(true).stream().map(c -> c.iterator(this.metadata.getIndex())).collect(Collectors.toList()).iterator());
    }

    protected abstract T createTimeSeries(C var1);

    private void split(C chunkToSplit, List<C> splitChunks, int newChunkSize) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Split chunk [{}, {}]", (Object)chunkToSplit.getOffset(), (Object)(chunkToSplit.getOffset() + chunkToSplit.getLength() - 1));
        }
        boolean usePreviousChunk = false;
        DataChunk previousChunk = splitChunks.isEmpty() ? null : (DataChunk)splitChunks.get(splitChunks.size() - 1);
        int previousChunkSize = 0;
        if (previousChunk != null && previousChunk.getLength() < newChunkSize && chunkToSplit.getOffset() % newChunkSize != 0) {
            usePreviousChunk = true;
            previousChunkSize = previousChunk.getLength();
        }
        int correctedChunkSize = newChunkSize - previousChunkSize;
        if (usePreviousChunk) {
            LOGGER.trace("Previous output chunk's size is {} ; {} elements can be added.", (Object)previousChunkSize, (Object)correctedChunkSize);
        } else {
            LOGGER.trace("The previous chunk was complete (or there was no previous chunk). Starting a new one.");
        }
        if (chunkToSplit.getLength() > correctedChunkSize) {
            this.splitChunk(chunkToSplit, previousChunk, splitChunks, newChunkSize, correctedChunkSize, usePreviousChunk);
        } else {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("   Too small...");
            }
            if (usePreviousChunk) {
                C mergedChunk = previousChunk.append(chunkToSplit);
                splitChunks.remove(splitChunks.size() - 1);
                splitChunks.add(mergedChunk);
            } else {
                splitChunks.add(chunkToSplit);
            }
        }
    }

    private void splitChunk(C chunkToSplit, C previousChunk, List<C> splitChunks, int newChunkSize, int correctedChunkSize, boolean usePreviousChunk) {
        int newChunkLowIndex = (int)Math.round(0.5 + (double)chunkToSplit.getOffset() / (double)correctedChunkSize) * correctedChunkSize;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("   At index {}", (Object)newChunkLowIndex);
        }
        DataChunk.Split split = chunkToSplit.splitAt(newChunkLowIndex);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("   Adding chunk [{}, {}]", (Object)split.getChunk1().getOffset(), (Object)(split.getChunk1().getOffset() + split.getChunk1().getLength() - 1));
        }
        if (usePreviousChunk) {
            Object mergedChunk = previousChunk.append(split.getChunk1());
            splitChunks.remove(splitChunks.size() - 1);
            splitChunks.add(mergedChunk);
        } else {
            splitChunks.add(split.getChunk1());
        }
        this.split(split.getChunk2(), splitChunks, newChunkSize);
    }

    public List<T> split(int newChunkSize) {
        ArrayList splitNewChunks = new ArrayList();
        for (DataChunk chunkToSplit : this.getCheckedChunks(false)) {
            this.split(chunkToSplit, splitNewChunks, newChunkSize);
        }
        return splitNewChunks.stream().map(this::createTimeSeries).collect(Collectors.toList());
    }

    public void writeJson(JsonGenerator generator) {
        Objects.requireNonNull(generator);
        try {
            generator.writeStartObject();
            generator.writeFieldName("metadata");
            this.metadata.writeJson(generator);
            generator.writeFieldName("chunks");
            DataChunk.writeJson(generator, this.chunks);
            generator.writeEndObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toJson() {
        return JsonUtil.toJson(this::writeJson);
    }

    public void setTimeSeriesNameResolver(TimeSeriesNameResolver ignored) {
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.chunks);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractTimeSeries) {
            AbstractTimeSeries other = (AbstractTimeSeries)obj;
            return this.metadata.equals(other.metadata) && this.chunks.equals(other.chunks);
        }
        return false;
    }
}

