/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.commons.json.JsonUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;

public abstract class AbstractUncompressedDataChunk {
    private static final double COMPRESSION_FACTOR = 1.0;
    protected final int offset;

    public AbstractUncompressedDataChunk(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("Bad offset value " + offset);
        }
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isCompressed() {
        return false;
    }

    public double getCompressionFactor() {
        return 1.0;
    }

    protected abstract void writeValuesJson(JsonGenerator var1) throws IOException;

    public void writeJson(JsonGenerator generator) {
        Objects.requireNonNull(generator);
        try {
            generator.writeStartObject();
            generator.writeNumberField("offset", this.offset);
            generator.writeFieldName("values");
            this.writeValuesJson(generator);
            generator.writeEndObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toJson() {
        return JsonUtil.toJson(this::writeJson);
    }
}

