/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class BiList<E> {
    private final List<E> list = new ArrayList();
    private final TObjectIntMap<E> reverse = new TObjectIntHashMap();
    private final Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(E e) {
        Objects.requireNonNull(e);
        this.lock.lock();
        try {
            int i = this.list.size();
            this.list.add(e);
            this.reverse.put(e, i);
            int n = i;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addIfNotAlreadyExist(E e) {
        this.lock.lock();
        try {
            int i = this.indexOf(e);
            if (i == -1) {
                i = this.add(e);
            }
            int n = i;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public E get(int index) {
        this.lock.lock();
        try {
            E e = this.list.get(index);
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int indexOf(E e) {
        Objects.requireNonNull(e);
        this.lock.lock();
        try {
            if (!this.reverse.containsKey(e)) {
                int n = -1;
                return n;
            }
            int n = this.reverse.get(e);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    int size() {
        this.lock.lock();
        try {
            int n = this.list.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    void clear() {
        this.lock.lock();
        try {
            this.list.clear();
            this.reverse.clear();
        }
        finally {
            this.lock.unlock();
        }
    }
}

