/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.util.Objects;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;

public class BigDoubleBuffer {
    private static final int BUFFER_SHIFT = 27;
    private static final int BUFFER_SIZE_DOUBLES = 0x8000000;
    private static final int BUFFER_MASK = 0x7FFFFFF;
    private static final int BUFFER_SIZE_BYTES = 0x40000000;
    private DoubleBuffer[] buffers;
    private final long size;

    static void withSizes(long size, IntConsumer bufferContainerInitializer, IntIntBiConsumer bufferInitializer) {
        if (size < 0L) {
            throw new IllegalArgumentException("Invalid buffer size: " + size);
        }
        long computedBufferCount = size + 0x8000000L - 1L >> 27;
        if (computedBufferCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size " + size + " is bigger than max allowed value 18014398509481984");
        }
        int bufferCount = (int)computedBufferCount;
        long computedLastBufferSizeBytes = (size & 0x7FFFFFFL) * 8L;
        int lastBufferSizeBytes = (int)computedLastBufferSizeBytes;
        if (size > 0L && lastBufferSizeBytes == 0) {
            lastBufferSizeBytes = 0x40000000;
        }
        bufferContainerInitializer.accept(bufferCount);
        for (int i = 0; i < bufferCount - 1; ++i) {
            bufferInitializer.accept(i, 0x40000000);
        }
        if (lastBufferSizeBytes > 0) {
            bufferInitializer.accept(bufferCount - 1, lastBufferSizeBytes);
        }
    }

    public BigDoubleBuffer(IntFunction<ByteBuffer> byteBufferAllocator, long size) {
        Objects.requireNonNull(byteBufferAllocator);
        BigDoubleBuffer.withSizes(size, bufferCount -> {
            this.buffers = new DoubleBuffer[bufferCount];
        }, (i, bufferSize) -> {
            this.buffers[i] = ((ByteBuffer)byteBufferAllocator.apply(bufferSize)).asDoubleBuffer();
        });
        this.size = size;
    }

    static double withIndices(long index, IntIntToDoubleBiFunction indicesBiFunction) {
        long computedBufferIndex = index >> 27;
        long computedSecondIndex = index & 0x7FFFFFFL;
        int bufferIndex = (int)computedBufferIndex;
        int secondIndex = (int)computedSecondIndex;
        return indicesBiFunction.applyAsDouble(bufferIndex, secondIndex);
    }

    public void put(long index, double value) {
        BigDoubleBuffer.withIndices(index, (bufferIndex, secondIndex) -> {
            this.buffers[bufferIndex].put(secondIndex, value);
            return Double.NaN;
        });
    }

    public double get(long index) {
        return BigDoubleBuffer.withIndices(index, (bufferIndex, secondIndex) -> this.buffers[bufferIndex].get(secondIndex));
    }

    public long capacity() {
        return this.size;
    }

    @FunctionalInterface
    static interface IntIntBiConsumer {
        public void accept(int var1, int var2);
    }

    @FunctionalInterface
    static interface IntIntToDoubleBiFunction {
        public double applyAsDouble(int var1, int var2);
    }
}

