/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries;

import com.powsybl.timeseries.CompactStringBuffer;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;

public class BigStringBuffer {
    private static final int BUFFER_SHIFT = 28;
    private static final int BUFFER_SIZE_INTS = 0x10000000;
    private static final int BUFFER_MASK = 0xFFFFFFF;
    private CompactStringBuffer[] buffers;
    private final long size;

    static void withSizes(long size, IntConsumer bufferContainerInitializer, IntIntBiConsumer bufferInitializer) {
        if (size < 0L) {
            throw new IllegalArgumentException("Invalid buffer size: " + size);
        }
        long computedBufferCount = size + 0x10000000L - 1L >> 28;
        if (computedBufferCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size " + size + " is bigger than max allowed value 72057594037927936");
        }
        int bufferCount = (int)computedBufferCount;
        long computedLastBufferSizeInts = size & 0xFFFFFFFL;
        int lastBufferSizeInts = (int)computedLastBufferSizeInts;
        if (size > 0L && lastBufferSizeInts == 0) {
            lastBufferSizeInts = 0x10000000;
        }
        bufferContainerInitializer.accept(bufferCount);
        for (int i = 0; i < bufferCount - 1; ++i) {
            bufferInitializer.accept(i, 0x10000000);
        }
        if (lastBufferSizeInts > 0) {
            bufferInitializer.accept(bufferCount - 1, lastBufferSizeInts);
        }
    }

    public BigStringBuffer(IntFunction<ByteBuffer> byteBufferAllocator, long size) {
        Objects.requireNonNull(byteBufferAllocator);
        BigStringBuffer.withSizes(size, bufferCount -> {
            this.buffers = new CompactStringBuffer[bufferCount];
        }, (i, bufferSize) -> {
            this.buffers[i] = new CompactStringBuffer(byteBufferAllocator, bufferSize);
        });
        this.size = size;
    }

    static String withIndices(long index, IntIntBiFunction indicesBiFunction) {
        long computedBufferIndex = index >> 28;
        long computedSecondIndex = index & 0xFFFFFFFL;
        int bufferIndex = (int)computedBufferIndex;
        int secondIndex = (int)computedSecondIndex;
        return indicesBiFunction.apply(bufferIndex, secondIndex);
    }

    public void putString(long index, String value) {
        BigStringBuffer.withIndices(index, (bufferIndex, secondIndex) -> {
            this.buffers[bufferIndex].putString(secondIndex, value);
            return null;
        });
    }

    public String getString(long index) {
        return BigStringBuffer.withIndices(index, (bufferIndex, secondIndex) -> this.buffers[bufferIndex].getString(secondIndex));
    }

    public long capacity() {
        return this.size;
    }

    @FunctionalInterface
    static interface IntIntBiConsumer {
        public void accept(int var1, int var2);
    }

    @FunctionalInterface
    static interface IntIntBiFunction {
        public String apply(int var1, int var2);
    }
}

