/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.timeseries.AbstractPoint;
import com.powsybl.timeseries.BigDoubleBuffer;
import com.powsybl.timeseries.DoubleMultiPoint;
import com.powsybl.timeseries.DoublePoint;
import com.powsybl.timeseries.DoubleTimeSeries;
import com.powsybl.timeseries.InfiniteTimeSeriesIndex;
import com.powsybl.timeseries.TimeSeries;
import com.powsybl.timeseries.TimeSeriesDataType;
import com.powsybl.timeseries.TimeSeriesException;
import com.powsybl.timeseries.TimeSeriesIndex;
import com.powsybl.timeseries.TimeSeriesMetadata;
import com.powsybl.timeseries.TimeSeriesNameResolver;
import com.powsybl.timeseries.ast.NodeCalc;
import com.powsybl.timeseries.ast.NodeCalcEvaluator;
import com.powsybl.timeseries.ast.NodeCalcResolver;
import com.powsybl.timeseries.ast.NodeCalcSimplifier;
import com.powsybl.timeseries.ast.TimeSeriesNames;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.DoubleBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class CalculatedTimeSeries
implements DoubleTimeSeries {
    public static final TimeSeriesNameResolver EMPTY_RESOLVER = new TimeSeriesNameResolver(){

        @Override
        public List<TimeSeriesMetadata> getTimeSeriesMetadata(Set<String> timeSeriesNames) {
            return Collections.emptyList();
        }

        @Override
        public Set<Integer> getTimeSeriesDataVersions(String timeSeriesName) {
            return Collections.emptySet();
        }

        @Override
        public List<DoubleTimeSeries> getDoubleTimeSeries(Set<String> timeSeriesNames) {
            return Collections.emptyList();
        }
    };
    private final String name;
    private final NodeCalc nodeCalc;
    private TimeSeriesNameResolver resolver;
    private final TimeSeriesMetadata metadata;
    private TimeSeriesIndex index;

    public CalculatedTimeSeries(String name, NodeCalc nodeCalc, TimeSeriesNameResolver resolver) {
        this.name = Objects.requireNonNull(name);
        this.nodeCalc = Objects.requireNonNull(nodeCalc);
        this.resolver = Objects.requireNonNull(resolver);
        this.metadata = new TimeSeriesMetadata(name, TimeSeriesDataType.DOUBLE, (TimeSeriesIndex)InfiniteTimeSeriesIndex.INSTANCE){

            @Override
            public TimeSeriesIndex getIndex() {
                return CalculatedTimeSeries.this.getIndex();
            }
        };
    }

    public CalculatedTimeSeries(String name, NodeCalc nodeCalc) {
        this(name, nodeCalc, EMPTY_RESOLVER);
    }

    @Override
    public void setTimeSeriesNameResolver(TimeSeriesNameResolver resolver) {
        this.resolver = Objects.requireNonNull(resolver);
    }

    private List<DoubleTimeSeries> loadData() {
        Set<String> timeSeriesNames = TimeSeriesNames.list(this.nodeCalc);
        return timeSeriesNames.isEmpty() ? Collections.emptyList() : this.resolver.getDoubleTimeSeries(timeSeriesNames);
    }

    private NodeCalc resolve(List<DoubleTimeSeries> timeSeriesList) {
        NodeCalc simplifiedNodeCalc = NodeCalcSimplifier.simplify(this.nodeCalc);
        Map<String, Integer> timeSeriesNums = IntStream.range(0, timeSeriesList.size()).boxed().collect(Collectors.toMap(i -> ((DoubleTimeSeries)timeSeriesList.get((int)i)).getMetadata().getName(), Function.identity()));
        return NodeCalcResolver.resolve(simplifiedNodeCalc, timeSeriesNums);
    }

    public static TimeSeriesIndex computeIndex(NodeCalc nodeCalc, TimeSeriesNameResolver resolver) {
        TimeSeriesIndex index;
        Objects.requireNonNull(nodeCalc);
        Set<String> timeSeriesNames = TimeSeriesNames.list(nodeCalc);
        if (timeSeriesNames.isEmpty()) {
            index = InfiniteTimeSeriesIndex.INSTANCE;
        } else {
            if (resolver == null) {
                throw new TimeSeriesException("Time series name resolver is null");
            }
            Set indexes = resolver.getTimeSeriesMetadata(timeSeriesNames).stream().map(TimeSeriesMetadata::getIndex).collect(Collectors.toSet());
            if (indexes.size() > 1) {
                throw new TimeSeriesException("A calculated time series must depend on synchronized time series");
            }
            index = (TimeSeriesIndex)indexes.iterator().next();
        }
        return index;
    }

    public static Set<Integer> computeVersions(NodeCalc nodeCalc, TimeSeriesNameResolver resolver) {
        Objects.requireNonNull(nodeCalc);
        Set<String> timeSeriesNames = TimeSeriesNames.list(nodeCalc);
        if (timeSeriesNames.isEmpty()) {
            return Collections.emptySet();
        }
        if (resolver == null) {
            throw new TimeSeriesException("Time series name resolver is null");
        }
        Sets.SetView commonVersions = new HashSet<Integer>();
        for (String timeSeriesName : timeSeriesNames) {
            Set<Integer> versions = resolver.getTimeSeriesDataVersions(timeSeriesName);
            if (commonVersions.isEmpty()) {
                commonVersions = versions;
                continue;
            }
            commonVersions = Sets.intersection(commonVersions, versions);
        }
        return commonVersions;
    }

    public Set<Integer> getVersions() {
        return CalculatedTimeSeries.computeVersions(this.nodeCalc, this.resolver);
    }

    @Override
    public void synchronize(TimeSeriesIndex newIndex) {
        Objects.requireNonNull(newIndex);
        if (this.metadata.getIndex() == InfiniteTimeSeriesIndex.INSTANCE) {
            this.index = newIndex;
        } else if (!this.metadata.getIndex().equals(newIndex)) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }

    private void forEachMaterializedValueIndex(DoubleIntConsumer consumer) {
        if (this.metadata.getIndex() == InfiniteTimeSeriesIndex.INSTANCE) {
            throw new TimeSeriesException("Impossible to fill buffer because calculated time series has not been synchronized on a finite time index");
        }
        Iterator<DoublePoint> it = this.iterator();
        AbstractPoint prevPoint = null;
        while (it.hasNext()) {
            DoublePoint point = it.next();
            if (prevPoint != null) {
                for (int i = prevPoint.getIndex(); i < point.getIndex(); ++i) {
                    consumer.accept(((DoublePoint)prevPoint).getValue(), i);
                }
            }
            prevPoint = point;
        }
        if (prevPoint != null) {
            for (int i = prevPoint.getIndex(); i < this.metadata.getIndex().getPointCount(); ++i) {
                consumer.accept(((DoublePoint)prevPoint).getValue(), i);
            }
        }
    }

    @Override
    public void fillBuffer(DoubleBuffer buffer, int timeSeriesOffset) {
        Objects.requireNonNull(buffer);
        this.forEachMaterializedValueIndex((v, i) -> buffer.put(i + timeSeriesOffset, v));
    }

    @Override
    public void fillBuffer(BigDoubleBuffer buffer, long timeSeriesOffset) {
        Objects.requireNonNull(buffer);
        this.forEachMaterializedValueIndex((v, i) -> buffer.put((long)i + timeSeriesOffset, v));
    }

    @Override
    public double[] toArray() {
        DoubleBuffer buffer = DoubleBuffer.allocate(this.metadata.getIndex().getPointCount());
        this.fillBuffer(buffer, 0);
        return buffer.array();
    }

    @Override
    public TimeSeriesMetadata getMetadata() {
        return this.metadata;
    }

    public TimeSeriesIndex getIndex() {
        if (this.index == null) {
            this.index = CalculatedTimeSeries.computeIndex(this.nodeCalc, this.resolver);
        }
        return this.index;
    }

    private static DoublePoint evaluateMultiPoint(NodeCalc resolvedNodeCalc, DoubleMultiPoint multiPoint) {
        double value = NodeCalcEvaluator.eval(resolvedNodeCalc, multiPoint);
        return new DoublePoint(multiPoint.getIndex(), multiPoint.getInstant(), value);
    }

    private static DoublePoint evaluate(NodeCalc resolvedNodeCalc) {
        double value = NodeCalcEvaluator.eval(resolvedNodeCalc, null);
        return new DoublePoint(0, InfiniteTimeSeriesIndex.START_INSTANT, value);
    }

    @Override
    public Stream<DoublePoint> stream() {
        List<DoubleTimeSeries> timeSeriesList = this.loadData();
        NodeCalc resolvedNodeCalc = this.resolve(timeSeriesList);
        if (timeSeriesList.isEmpty()) {
            return Stream.of(CalculatedTimeSeries.evaluate(resolvedNodeCalc));
        }
        return DoubleTimeSeries.stream(timeSeriesList).map(multiPoint -> CalculatedTimeSeries.evaluateMultiPoint(resolvedNodeCalc, multiPoint));
    }

    @Override
    public Iterator<DoublePoint> iterator() {
        List<DoubleTimeSeries> timeSeriesList = this.loadData();
        NodeCalc resolvedNodeCalc = this.resolve(timeSeriesList);
        if (timeSeriesList.isEmpty()) {
            return Iterators.singletonIterator((Object)CalculatedTimeSeries.evaluate(resolvedNodeCalc));
        }
        return Iterators.transform(DoubleTimeSeries.iterator(timeSeriesList), multiPoint -> CalculatedTimeSeries.evaluateMultiPoint(resolvedNodeCalc, multiPoint));
    }

    @Override
    public List<DoubleTimeSeries> split(int newChunkSize) {
        int chunkCount = TimeSeries.computeChunkCount(this.index, newChunkSize);
        return Collections.nCopies(chunkCount, this);
    }

    @Override
    public void writeJson(JsonGenerator generator) {
        try {
            generator.writeStartObject();
            generator.writeStringField("name", this.name);
            generator.writeFieldName("expr");
            generator.writeStartObject();
            this.nodeCalc.writeJson(generator);
            generator.writeEndObject();
            generator.writeEndObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public String toJson() {
        return JsonUtil.toJson(this::writeJson);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.nodeCalc);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CalculatedTimeSeries) {
            CalculatedTimeSeries other = (CalculatedTimeSeries)obj;
            return this.name.equals(other.name) && this.nodeCalc.equals(other.nodeCalc);
        }
        return false;
    }

    @FunctionalInterface
    private static interface DoubleIntConsumer {
        public void accept(double var1, int var3);
    }
}

