/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries;

import com.google.common.math.IntMath;
import com.powsybl.timeseries.BiList;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Objects;
import java.util.function.IntFunction;

public class CompactStringBuffer {
    private final IntBuffer buffer;
    private final BiList<String> dict = new BiList();

    public CompactStringBuffer(IntFunction<ByteBuffer> byteBufferAllocator, int size) {
        Objects.requireNonNull(byteBufferAllocator);
        if (size < 0) {
            throw new IllegalArgumentException("Invalid buffer size: " + size);
        }
        this.buffer = byteBufferAllocator.apply(IntMath.checkedMultiply((int)size, (int)4)).asIntBuffer();
    }

    public void putString(int index, String value) {
        int num = value == null ? 0 : this.dict.addIfNotAlreadyExist(value) + 1;
        this.buffer.put(index, num);
    }

    public String getString(int index) {
        int num = this.buffer.get(index);
        if (num == 0) {
            return null;
        }
        return this.dict.get(num - 1);
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public String[] toArray() {
        String[] array = new String[this.buffer.capacity()];
        for (int i = 0; i < this.buffer.capacity(); ++i) {
            array[i] = this.getString(i);
        }
        return array;
    }
}

