/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.timeseries.AbstractCompressedDataChunk;
import com.powsybl.timeseries.BigDoubleBuffer;
import com.powsybl.timeseries.DataChunk;
import com.powsybl.timeseries.DoubleDataChunk;
import com.powsybl.timeseries.DoublePoint;
import com.powsybl.timeseries.TimeSeriesDataType;
import com.powsybl.timeseries.TimeSeriesIndex;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class CompressedDoubleDataChunk
extends AbstractCompressedDataChunk
implements DoubleDataChunk {
    private final double[] stepValues;

    public CompressedDoubleDataChunk(int offset, int uncompressedLength, double[] stepValues, int[] stepLengths) {
        super(offset, uncompressedLength, stepLengths);
        CompressedDoubleDataChunk.check(offset, uncompressedLength, stepValues.length, stepLengths.length);
        this.stepValues = Objects.requireNonNull(stepValues);
    }

    public double[] getStepValues() {
        return this.stepValues;
    }

    static int getEstimatedSize(int stepValuesLength, int stepLengthsLength) {
        return 8 * stepValuesLength + 4 * stepLengthsLength;
    }

    @Override
    public int getEstimatedSize() {
        return CompressedDoubleDataChunk.getEstimatedSize(this.stepValues.length, this.stepLengths.length);
    }

    @Override
    protected int getUncompressedEstimatedSize() {
        return 8 * this.uncompressedLength;
    }

    @Override
    public TimeSeriesDataType getDataType() {
        return TimeSeriesDataType.DOUBLE;
    }

    private void forEachMaterializedValueIndex(DoubleIntConsumer consumer) {
        int k = 0;
        for (int i = 0; i < this.stepValues.length; ++i) {
            double value = this.stepValues[i];
            for (int j = 0; j < this.stepLengths[i]; ++j) {
                consumer.accept(value, this.offset + k++);
            }
        }
    }

    @Override
    public void fillBuffer(DoubleBuffer buffer, int timeSeriesOffset) {
        Objects.requireNonNull(buffer);
        this.forEachMaterializedValueIndex((v, i) -> buffer.put(timeSeriesOffset + i, v));
    }

    @Override
    public void fillBuffer(BigDoubleBuffer buffer, long timeSeriesOffset) {
        Objects.requireNonNull(buffer);
        this.forEachMaterializedValueIndex((v, i) -> buffer.put(timeSeriesOffset + (long)i, v));
    }

    @Override
    public Iterator<DoublePoint> iterator(final TimeSeriesIndex index) {
        Objects.requireNonNull(index);
        return new Iterator<DoublePoint>(){
            private int i;
            private int step;
            {
                this.i = CompressedDoubleDataChunk.this.offset;
                this.step = 0;
            }

            @Override
            public boolean hasNext() {
                return this.i < CompressedDoubleDataChunk.this.offset + CompressedDoubleDataChunk.this.uncompressedLength;
            }

            @Override
            public DoublePoint next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                DoublePoint point = new DoublePoint(this.i, index.getInstantAt(this.i), CompressedDoubleDataChunk.this.stepValues[this.step]);
                this.i += CompressedDoubleDataChunk.this.stepLengths[this.step];
                ++this.step;
                return point;
            }
        };
    }

    @Override
    public Stream<DoublePoint> stream(TimeSeriesIndex index) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(index), 1040), false);
    }

    @Override
    public DoubleDataChunk tryToCompress() {
        return this;
    }

    @Override
    public DataChunk.Split<DoublePoint, DoubleDataChunk> splitAt(int splitIndex) {
        if (splitIndex <= this.offset || splitIndex > this.offset + this.uncompressedLength - 1) {
            throw new IllegalArgumentException("Split index " + splitIndex + " out of chunk range ]" + this.offset + ", " + (this.offset + this.uncompressedLength - 1) + "]");
        }
        int index = this.offset;
        for (int step = 0; step < this.stepLengths.length; ++step) {
            if (index + this.stepLengths[step] > splitIndex) {
                int[] stepLengths1 = new int[step + 1];
                double[] stepValues1 = new double[stepLengths1.length];
                System.arraycopy(this.stepLengths, 0, stepLengths1, 0, stepLengths1.length);
                System.arraycopy(this.stepValues, 0, stepValues1, 0, stepValues1.length);
                stepLengths1[step] = splitIndex - index;
                CompressedDoubleDataChunk chunk1 = new CompressedDoubleDataChunk(this.offset, splitIndex - this.offset, stepValues1, stepLengths1);
                int[] stepLengths2 = new int[this.stepLengths.length - step];
                double[] stepValues2 = new double[stepLengths2.length];
                System.arraycopy(this.stepLengths, step, stepLengths2, 0, stepLengths2.length);
                System.arraycopy(this.stepValues, step, stepValues2, 0, stepValues2.length);
                stepLengths2[0] = this.stepLengths[step] - stepLengths1[step];
                CompressedDoubleDataChunk chunk2 = new CompressedDoubleDataChunk(splitIndex, this.uncompressedLength - chunk1.uncompressedLength, stepValues2, stepLengths2);
                return new DataChunk.Split<DoublePoint, DoubleDataChunk>(chunk1, chunk2);
            }
            index += this.stepLengths[step];
        }
        throw new IllegalStateException("Should not happen");
    }

    @Override
    public DoubleDataChunk append(DoubleDataChunk otherChunk) {
        double[] newStepValues;
        int[] newStepLengths;
        if (this.getOffset() + this.getLength() != otherChunk.getOffset()) {
            throw new IllegalArgumentException("Chunks are not successive. First offset is " + this.getOffset() + " and first size is " + this.getLength() + "; second offset should be " + (this.getOffset() + this.getLength()) + "but is " + otherChunk.getOffset());
        }
        if (!(otherChunk instanceof CompressedDoubleDataChunk)) {
            throw new IllegalArgumentException("The chunks to merge have to have the same implentation. One of them is " + this.getClass() + ", the other one is " + otherChunk.getClass());
        }
        CompressedDoubleDataChunk chunk = (CompressedDoubleDataChunk)otherChunk;
        if (this.stepValues[this.stepValues.length - 1] == chunk.getStepValues()[0]) {
            newStepLengths = new int[this.stepLengths.length + chunk.getStepLengths().length - 1];
            System.arraycopy(this.stepLengths, 0, newStepLengths, 0, this.stepLengths.length);
            newStepLengths[this.stepLengths.length - 1] = this.stepLengths[this.stepLengths.length - 1] + chunk.getStepLengths()[0];
            System.arraycopy(chunk.getStepLengths(), 1, newStepLengths, this.stepLengths.length, chunk.getStepLengths().length - 1);
            newStepValues = new double[newStepLengths.length];
            System.arraycopy(this.stepValues, 0, newStepValues, 0, this.stepValues.length);
            System.arraycopy(chunk.getStepValues(), 1, newStepValues, this.stepValues.length, chunk.getStepValues().length - 1);
        } else {
            newStepLengths = new int[this.stepLengths.length + chunk.getStepLengths().length];
            System.arraycopy(this.stepLengths, 0, newStepLengths, 0, this.stepLengths.length);
            System.arraycopy(chunk.getStepLengths(), 0, newStepLengths, this.stepLengths.length, chunk.getStepLengths().length);
            newStepValues = new double[newStepLengths.length];
            System.arraycopy(this.stepValues, 0, newStepValues, 0, this.stepValues.length);
            System.arraycopy(chunk.getStepValues(), 0, newStepValues, this.stepValues.length, chunk.getStepValues().length);
        }
        return new CompressedDoubleDataChunk(this.offset, this.uncompressedLength + chunk.getUncompressedLength(), newStepValues, newStepLengths);
    }

    @Override
    protected void writeStepValuesJson(JsonGenerator generator) throws IOException {
        generator.writeArray(this.stepValues, 0, this.stepValues.length);
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.uncompressedLength, this.stepLengths, this.stepValues);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompressedDoubleDataChunk) {
            CompressedDoubleDataChunk other = (CompressedDoubleDataChunk)obj;
            return this.offset == other.offset && this.uncompressedLength == other.uncompressedLength && Arrays.equals(this.stepLengths, other.stepLengths) && Arrays.equals(this.stepValues, other.stepValues);
        }
        return false;
    }

    @FunctionalInterface
    private static interface DoubleIntConsumer {
        public void accept(double var1, int var3);
    }
}

