/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.timeseries.AbstractCompressedDataChunk;
import com.powsybl.timeseries.BigStringBuffer;
import com.powsybl.timeseries.CompactStringBuffer;
import com.powsybl.timeseries.DataChunk;
import com.powsybl.timeseries.StringDataChunk;
import com.powsybl.timeseries.StringPoint;
import com.powsybl.timeseries.TimeSeriesDataType;
import com.powsybl.timeseries.TimeSeriesIndex;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.ObjIntConsumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class CompressedStringDataChunk
extends AbstractCompressedDataChunk
implements StringDataChunk {
    private final String[] stepValues;
    private int estimatedSize;
    private int uncompressedEstimatedSize;

    public CompressedStringDataChunk(int offset, int uncompressedLength, String[] stepValues, int[] stepLengths) {
        super(offset, uncompressedLength, stepLengths);
        CompressedStringDataChunk.check(offset, uncompressedLength, stepValues.length, stepLengths.length);
        this.stepValues = Objects.requireNonNull(stepValues);
        this.updateEstimatedSize();
    }

    static int getStepEstimatedSize(String value) {
        int estimatedSize = 4;
        if (value != null) {
            estimatedSize += value.length() * 2;
        }
        return estimatedSize;
    }

    private void updateEstimatedSize() {
        this.estimatedSize = 0;
        this.uncompressedEstimatedSize = 0;
        for (int i = 0; i < this.stepValues.length; ++i) {
            String stepValue = this.stepValues[i];
            if (stepValue != null) {
                int stepLength = this.stepLengths[i];
                this.uncompressedEstimatedSize += stepValue.length() * 2 * stepLength;
            }
            this.estimatedSize += CompressedStringDataChunk.getStepEstimatedSize(stepValue);
        }
    }

    public String[] getStepValues() {
        return this.stepValues;
    }

    @Override
    public int getEstimatedSize() {
        return this.estimatedSize;
    }

    @Override
    public int getUncompressedEstimatedSize() {
        return this.uncompressedEstimatedSize;
    }

    @Override
    public TimeSeriesDataType getDataType() {
        return TimeSeriesDataType.STRING;
    }

    private void forEachMaterializedValueIndex(ObjIntConsumer<String> consumer) {
        int k = 0;
        for (int i = 0; i < this.stepValues.length; ++i) {
            String value = this.stepValues[i];
            for (int j = 0; j < this.stepLengths[i]; ++j) {
                consumer.accept(value, this.offset + k++);
            }
        }
    }

    @Override
    public void fillBuffer(CompactStringBuffer buffer, int timeSeriesOffset) {
        Objects.requireNonNull(buffer);
        this.forEachMaterializedValueIndex((v, i) -> buffer.putString(timeSeriesOffset + i, (String)v));
    }

    @Override
    public void fillBuffer(BigStringBuffer buffer, long timeSeriesOffset) {
        Objects.requireNonNull(buffer);
        this.forEachMaterializedValueIndex((v, i) -> buffer.putString(timeSeriesOffset + (long)i, (String)v));
    }

    @Override
    public Iterator<StringPoint> iterator(final TimeSeriesIndex index) {
        Objects.requireNonNull(index);
        return new Iterator<StringPoint>(){
            private int i;
            private int step;
            {
                this.i = CompressedStringDataChunk.this.offset;
                this.step = 0;
            }

            @Override
            public boolean hasNext() {
                return this.i < CompressedStringDataChunk.this.offset + CompressedStringDataChunk.this.uncompressedLength;
            }

            @Override
            public StringPoint next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                StringPoint point = new StringPoint(this.i, index.getInstantAt(this.i), CompressedStringDataChunk.this.stepValues[this.step]);
                this.i += CompressedStringDataChunk.this.stepLengths[this.step];
                ++this.step;
                return point;
            }
        };
    }

    @Override
    public Stream<StringPoint> stream(TimeSeriesIndex index) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(index), 1040), false);
    }

    @Override
    public StringDataChunk tryToCompress() {
        return this;
    }

    @Override
    public DataChunk.Split<StringPoint, StringDataChunk> splitAt(int splitIndex) {
        if (splitIndex <= this.offset || splitIndex > this.offset + this.uncompressedLength - 1) {
            throw new IllegalArgumentException("Split index " + splitIndex + " out of chunk range ]" + this.offset + ", " + (this.offset + this.uncompressedLength - 1) + "]");
        }
        int index = this.offset;
        for (int step = 0; step < this.stepLengths.length; ++step) {
            if (index + this.stepLengths[step] > splitIndex) {
                int[] stepLengths1 = new int[step + 1];
                String[] stepValues1 = new String[stepLengths1.length];
                System.arraycopy(this.stepLengths, 0, stepLengths1, 0, stepLengths1.length);
                System.arraycopy(this.stepValues, 0, stepValues1, 0, stepValues1.length);
                stepLengths1[step] = splitIndex - index;
                CompressedStringDataChunk chunk1 = new CompressedStringDataChunk(this.offset, splitIndex - this.offset, stepValues1, stepLengths1);
                int[] stepLengths2 = new int[this.stepLengths.length - step];
                String[] stepValues2 = new String[stepLengths2.length];
                System.arraycopy(this.stepLengths, step, stepLengths2, 0, stepLengths2.length);
                System.arraycopy(this.stepValues, step, stepValues2, 0, stepValues2.length);
                stepLengths2[0] = this.stepLengths[step] - stepLengths1[step];
                CompressedStringDataChunk chunk2 = new CompressedStringDataChunk(splitIndex, this.uncompressedLength - chunk1.uncompressedLength, stepValues2, stepLengths2);
                return new DataChunk.Split<StringPoint, StringDataChunk>(chunk1, chunk2);
            }
            index += this.stepLengths[step];
        }
        throw new IllegalStateException("Should not happen");
    }

    @Override
    public StringDataChunk append(StringDataChunk otherChunk) {
        String[] newStepValues;
        int[] newStepLengths;
        if (this.getOffset() + this.getLength() != otherChunk.getOffset()) {
            throw new IllegalArgumentException("Chunks are not successive. First offset is " + this.getOffset() + " and first size is " + this.getLength() + "; second offset should be " + (this.getOffset() + this.getLength()) + "but is " + otherChunk.getOffset());
        }
        if (!(otherChunk instanceof CompressedStringDataChunk)) {
            throw new IllegalArgumentException("The chunks to merge have to have the same implementation. One of them is " + this.getClass() + ", the other one is " + otherChunk.getClass());
        }
        CompressedStringDataChunk chunk = (CompressedStringDataChunk)otherChunk;
        if (this.stepValues[this.stepValues.length - 1].equals(chunk.getStepValues()[0])) {
            newStepLengths = new int[this.stepLengths.length + chunk.getStepLengths().length - 1];
            System.arraycopy(this.stepLengths, 0, newStepLengths, 0, this.stepLengths.length);
            newStepLengths[this.stepLengths.length - 1] = this.stepLengths[this.stepLengths.length - 1] + chunk.getStepLengths()[0];
            System.arraycopy(chunk.getStepLengths(), 1, newStepLengths, this.stepLengths.length, chunk.getStepLengths().length - 1);
            newStepValues = new String[newStepLengths.length];
            System.arraycopy(this.stepValues, 0, newStepValues, 0, this.stepValues.length);
            System.arraycopy(chunk.getStepValues(), 1, newStepValues, this.stepValues.length, chunk.getStepValues().length - 1);
        } else {
            newStepLengths = new int[this.stepLengths.length + chunk.getStepLengths().length];
            System.arraycopy(this.stepLengths, 0, newStepLengths, 0, this.stepLengths.length);
            System.arraycopy(chunk.getStepLengths(), 0, newStepLengths, this.stepLengths.length, chunk.getStepLengths().length);
            newStepValues = new String[newStepLengths.length];
            System.arraycopy(this.stepValues, 0, newStepValues, 0, this.stepValues.length);
            System.arraycopy(chunk.getStepValues(), 0, newStepValues, this.stepValues.length, chunk.getStepValues().length);
        }
        return new CompressedStringDataChunk(this.offset, this.uncompressedLength + chunk.getUncompressedLength(), newStepValues, newStepLengths);
    }

    @Override
    protected void writeStepValuesJson(JsonGenerator generator) throws IOException {
        generator.writeStartArray();
        for (String stepValue : this.stepValues) {
            generator.writeString(stepValue);
        }
        generator.writeEndArray();
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.uncompressedLength, this.stepLengths, this.stepValues);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompressedStringDataChunk) {
            CompressedStringDataChunk other = (CompressedStringDataChunk)obj;
            return this.offset == other.offset && this.uncompressedLength == other.uncompressedLength && Arrays.equals(this.stepLengths, other.stepLengths) && Arrays.equals(this.stepValues, other.stepValues);
        }
        return false;
    }
}

