/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.powsybl.timeseries.AbstractPoint;
import com.powsybl.timeseries.CompressedDoubleDataChunk;
import com.powsybl.timeseries.CompressedStringDataChunk;
import com.powsybl.timeseries.DoubleDataChunk;
import com.powsybl.timeseries.StringDataChunk;
import com.powsybl.timeseries.TimeSeriesDataType;
import com.powsybl.timeseries.TimeSeriesIndex;
import com.powsybl.timeseries.UncompressedDoubleDataChunk;
import com.powsybl.timeseries.UncompressedStringDataChunk;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public interface DataChunk<P extends AbstractPoint, A extends DataChunk<P, A>> {
    public int getOffset();

    public int getLength();

    public int getEstimatedSize();

    public double getCompressionFactor();

    public boolean isCompressed();

    public TimeSeriesDataType getDataType();

    public Stream<P> stream(TimeSeriesIndex var1);

    public Iterator<P> iterator(TimeSeriesIndex var1);

    public A tryToCompress();

    public Split<P, A> splitAt(int var1);

    public A append(A var1);

    public void writeJson(JsonGenerator var1);

    public static DoubleDataChunk create(int offset, double[] values) {
        return new UncompressedDoubleDataChunk(offset, values);
    }

    public static DoubleDataChunk create(double ... values) {
        return new UncompressedDoubleDataChunk(0, values);
    }

    public static StringDataChunk create(int offset, String[] values) {
        return new UncompressedStringDataChunk(offset, values);
    }

    public static StringDataChunk create(String ... values) {
        return new UncompressedStringDataChunk(0, values);
    }

    public static void writeJson(JsonGenerator generator, List<? extends DataChunk> chunks) {
        Objects.requireNonNull(generator);
        try {
            generator.writeStartArray();
            for (DataChunk dataChunk : chunks) {
                dataChunk.writeJson(generator);
            }
            generator.writeEndArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toJson();

    public static void parseFieldName(JsonParser parser, JsonParsingContext context) throws IOException {
        String fieldName;
        switch (fieldName = parser.currentName()) {
            case "offset": {
                context.offset = parser.nextIntValue(-1);
                context.doubleValues = null;
                context.stringValues = null;
                break;
            }
            case "uncompressedLength": {
                context.uncompressedLength = parser.nextIntValue(-1);
                break;
            }
            case "stepLengths": {
                context.stepLengths = new TIntArrayList();
                context.valuesOrLengthArray = true;
                break;
            }
            case "values": 
            case "stepValues": {
                context.valuesOrLengthArray = true;
                break;
            }
        }
    }

    public static void addUncompressedChunk(JsonParsingContext context) {
        if (context.doubleValues != null && context.stringValues == null) {
            context.doubleChunks.add(new UncompressedDoubleDataChunk(context.offset, context.doubleValues.toArray()));
        } else if (context.stringValues != null && context.doubleValues == null) {
            context.stringChunks.add(new UncompressedStringDataChunk(context.offset, context.stringValues.toArray(new String[0])));
        } else {
            if (context.stringValues != null) {
                throw new IllegalStateException("doubleValues and stringValues are not expected to be non null at the same time");
            }
            throw new IllegalStateException("doubleValues and stringValues are not expected to be null at the same time");
        }
    }

    public static void addCompressedChunk(JsonParsingContext context) {
        if (context.doubleValues != null && context.stringValues == null) {
            context.doubleChunks.add(new CompressedDoubleDataChunk(context.offset, context.uncompressedLength, context.doubleValues.toArray(), context.stepLengths.toArray()));
            context.doubleValues = null;
            context.stepLengths = null;
            context.uncompressedLength = -1;
        } else if (context.stringValues != null && context.doubleValues == null) {
            context.stringChunks.add(new CompressedStringDataChunk(context.offset, context.uncompressedLength, context.stringValues.toArray(new String[0]), context.stepLengths.toArray()));
            context.stringValues = null;
            context.stepLengths = null;
            context.uncompressedLength = -1;
        } else {
            if (context.stringValues != null) {
                throw new IllegalStateException("doubleValues and stringValues are not expected to be non null at the same time");
            }
            throw new IllegalStateException("doubleValues and stringValues are not expected to be null at the same time");
        }
    }

    public static void parseEndObject(JsonParsingContext context) {
        if (context.stepLengths == null) {
            DataChunk.addUncompressedChunk(context);
        } else {
            DataChunk.addCompressedChunk(context);
        }
        context.offset = -1;
    }

    public static void parseValueNumberInt(JsonParser parser, JsonParsingContext context) throws IOException {
        if (context.stepLengths != null) {
            context.stepLengths.add(parser.getIntValue());
        } else {
            context.addDoubleValue(parser.getIntValue());
        }
    }

    public static void parseJson(JsonParser parser, List<DoubleDataChunk> doubleChunks, List<StringDataChunk> stringChunks) {
        DataChunk.parseJson(parser, doubleChunks, stringChunks, false);
    }

    public static void parseJson(JsonParser parser, List<DoubleDataChunk> doubleChunks, List<StringDataChunk> stringChunks, boolean single) {
        Objects.requireNonNull(parser);
        try {
            JsonToken token;
            JsonParsingContext context = new JsonParsingContext(doubleChunks, stringChunks);
            block11: while ((token = parser.nextToken()) != null) {
                switch (token) {
                    case FIELD_NAME: {
                        DataChunk.parseFieldName(parser, context);
                        continue block11;
                    }
                    case END_OBJECT: {
                        DataChunk.parseEndObject(context);
                        if (!single) continue block11;
                        return;
                    }
                    case END_ARRAY: {
                        if (context.valuesOrLengthArray) {
                            context.valuesOrLengthArray = false;
                            continue block11;
                        }
                        return;
                    }
                    case VALUE_NUMBER_FLOAT: {
                        context.addDoubleValue(parser.getDoubleValue());
                        continue block11;
                    }
                    case VALUE_NUMBER_INT: {
                        DataChunk.parseValueNumberInt(parser, context);
                        continue block11;
                    }
                    case VALUE_STRING: {
                        context.addStringValue(parser.getValueAsString());
                        continue block11;
                    }
                    case VALUE_NULL: {
                        context.addStringValue(null);
                        continue block11;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class JsonParsingContext {
        private int offset = -1;
        private final List<DoubleDataChunk> doubleChunks;
        private final List<StringDataChunk> stringChunks;
        private TDoubleArrayList doubleValues;
        private List<String> stringValues;
        private TIntArrayList stepLengths;
        private int uncompressedLength = -1;
        private boolean valuesOrLengthArray = false;

        JsonParsingContext(List<DoubleDataChunk> doubleChunks, List<StringDataChunk> stringChunks) {
            this.doubleChunks = Objects.requireNonNull(doubleChunks);
            this.stringChunks = Objects.requireNonNull(stringChunks);
        }

        void addDoubleValue(double value) {
            if (this.doubleValues == null) {
                this.doubleValues = new TDoubleArrayList();
            }
            this.doubleValues.add(value);
        }

        void addStringValue(String value) {
            if (this.stringValues == null) {
                this.stringValues = new ArrayList<String>();
            }
            this.stringValues.add(value);
        }
    }

    public static class Split<P extends AbstractPoint, A extends DataChunk<P, A>> {
        private final A chunk1;
        private final A chunk2;

        Split(A chunk1, A chunk2) {
            this.chunk1 = (DataChunk)Objects.requireNonNull(chunk1);
            this.chunk2 = (DataChunk)Objects.requireNonNull(chunk2);
        }

        A getChunk1() {
            return this.chunk1;
        }

        A getChunk2() {
            return this.chunk2;
        }
    }
}

