/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries;

import com.powsybl.timeseries.BigDoubleBuffer;
import com.powsybl.timeseries.CalculatedTimeSeries;
import com.powsybl.timeseries.CalculatedTimeSeriesDslLoader;
import com.powsybl.timeseries.DoubleMultiPoint;
import com.powsybl.timeseries.DoublePoint;
import com.powsybl.timeseries.FromStoreTimeSeriesNameResolver;
import com.powsybl.timeseries.ReadOnlyTimeSeriesStoreCache;
import com.powsybl.timeseries.TimeSeries;
import com.powsybl.timeseries.TimeSeriesException;
import com.powsybl.timeseries.TimeSeriesMetadata;
import com.powsybl.timeseries.ast.NodeCalc;
import java.nio.DoubleBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface DoubleTimeSeries
extends TimeSeries<DoublePoint, DoubleTimeSeries> {
    public void fillBuffer(DoubleBuffer var1, int var2);

    public void fillBuffer(BigDoubleBuffer var1, long var2);

    public double[] toArray();

    public static Iterator<DoubleMultiPoint> iterator(final List<DoubleTimeSeries> timeSeriesList) {
        Objects.requireNonNull(timeSeriesList);
        if (timeSeriesList.isEmpty()) {
            return Collections.emptyIterator();
        }
        long indexCount = timeSeriesList.stream().map(TimeSeries::getMetadata).map(TimeSeriesMetadata::getIndex).distinct().count();
        if (indexCount > 1L) {
            throw new TimeSeriesException("Time series must have the same index");
        }
        HashMap<Integer, List> points = new HashMap<Integer, List>();
        for (int timeSeriesNum = 0; timeSeriesNum < timeSeriesList.size(); ++timeSeriesNum) {
            DoubleTimeSeries timeSeries = timeSeriesList.get(timeSeriesNum);
            for (DoublePoint point : timeSeries) {
                class DoublePointExt {
                    private final DoublePoint point;
                    private final int timeSeriesNum;

                    DoublePointExt(DoublePoint point, int timeSeriesNum) {
                        this.point = point;
                        this.timeSeriesNum = timeSeriesNum;
                    }

                    public DoublePoint getPoint() {
                        return this.point;
                    }

                    public int getTimeSeriesNum() {
                        return this.timeSeriesNum;
                    }
                }
                points.computeIfAbsent(point.getIndex(), key -> new ArrayList()).add(new DoublePointExt(point, timeSeriesNum));
            }
        }
        final Iterator it = points.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).iterator();
        return new Iterator<DoubleMultiPoint>(){
            private final double[] values;
            {
                this.values = new double[timeSeriesList.size()];
            }

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public DoubleMultiPoint next() {
                final Map.Entry e = (Map.Entry)it.next();
                for (DoublePointExt point : (List)e.getValue()) {
                    this.values[point.getTimeSeriesNum()] = point.getPoint().getValue();
                }
                return new DoubleMultiPoint(){

                    @Override
                    public int getIndex() {
                        return (Integer)e.getKey();
                    }

                    @Override
                    public long getTime() {
                        return this.getInstant().toEpochMilli();
                    }

                    @Override
                    public Instant getInstant() {
                        return ((DoublePointExt)((List)e.getValue()).get(0)).getPoint().getInstant();
                    }

                    @Override
                    public double getValue(int timeSeriesNum) {
                        return values[timeSeriesNum];
                    }
                };
            }
        };
    }

    public static Stream<DoubleMultiPoint> stream(List<DoubleTimeSeries> timeSeriesList) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(DoubleTimeSeries.iterator(timeSeriesList), 1040), false);
    }

    public static List<DoubleTimeSeries> build(String ... scriptLines) {
        return Builder.build(Collections.emptyList(), scriptLines);
    }

    public static Builder fromTimeSeries(List<DoubleTimeSeries> list) {
        return new Builder(list);
    }

    public static Builder fromTimeSeries(DoubleTimeSeries ... list) {
        return DoubleTimeSeries.fromTimeSeries(Arrays.asList(list));
    }

    public static class Builder {
        private final List<DoubleTimeSeries> list;

        Builder(List<DoubleTimeSeries> list) {
            this.list = Objects.requireNonNull(list);
        }

        private static List<DoubleTimeSeries> build(List<DoubleTimeSeries> list, String ... scriptLines) {
            String script = Arrays.stream(scriptLines).collect(Collectors.joining(System.lineSeparator()));
            ReadOnlyTimeSeriesStoreCache store = new ReadOnlyTimeSeriesStoreCache(list);
            return CalculatedTimeSeriesDslLoader.find().load(script, store).entrySet().stream().map(e -> new CalculatedTimeSeries((String)e.getKey(), (NodeCalc)e.getValue(), new FromStoreTimeSeriesNameResolver(store, -1))).collect(Collectors.toList());
        }

        public List<DoubleTimeSeries> build(String ... scriptLines) {
            return Builder.build(this.list, scriptLines);
        }
    }
}

