/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.powsybl.timeseries.AbstractTimeSeriesIndex;
import com.powsybl.timeseries.TimeSeriesException;
import com.powsybl.timeseries.TimeSeriesIndex;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;

public class InfiniteTimeSeriesIndex
extends AbstractTimeSeriesIndex {
    public static final InfiniteTimeSeriesIndex INSTANCE = new InfiniteTimeSeriesIndex();
    public static final String TYPE = "infiniteIndex";
    public static final Instant START_INSTANT = Instant.ofEpochMilli(0L);
    public static final Instant END_INSTANT = Instant.ofEpochMilli(Long.MAX_VALUE);

    @Override
    public int getPointCount() {
        return 2;
    }

    @Override
    @Deprecated(since="6.7.0")
    public long getTimeAt(int point) {
        return this.getInstantAt(point).toEpochMilli();
    }

    @Override
    public Instant getInstantAt(int point) {
        if (point == 0) {
            return START_INSTANT;
        }
        if (point == 1) {
            return END_INSTANT;
        }
        throw new TimeSeriesException("Point " + point + " not found");
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void writeJson(JsonGenerator generator, TimeSeriesIndex.ExportFormat timeFormat) {
        Objects.requireNonNull(generator);
        try {
            generator.writeStartObject();
            generator.writeEndObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static InfiniteTimeSeriesIndex parseJson(JsonParser parser) {
        Objects.requireNonNull(parser);
        try {
            JsonToken token;
            while ((token = parser.nextToken()) != null) {
                if (token != JsonToken.END_OBJECT) continue;
                return INSTANCE;
            }
            throw new IllegalStateException("Should not happen");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Iterator<Instant> iterator() {
        return Arrays.asList(START_INSTANT, END_INSTANT).iterator();
    }

    @Override
    public Stream<Instant> stream() {
        return Stream.of(START_INSTANT, END_INSTANT);
    }

    public String toString() {
        return "InfiniteTimeSeriesIndex()";
    }
}

