/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.powsybl.timeseries.AbstractTimeSeriesIndex;
import com.powsybl.timeseries.TimeSeries;
import com.powsybl.timeseries.TimeSeriesIndex;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class IrregularTimeSeriesIndex
extends AbstractTimeSeriesIndex {
    public static final String TYPE = "irregularIndex";
    private final Instant[] instants;

    public IrregularTimeSeriesIndex(Instant[] instants) {
        this.instants = Objects.requireNonNull(instants);
        if (instants.length == 0) {
            throw new IllegalArgumentException("Empty time list");
        }
    }

    @Deprecated(since="6.7.0")
    public IrregularTimeSeriesIndex(long[] times) {
        this((Instant[])Arrays.stream(times).mapToObj(Instant::ofEpochMilli).toArray(Instant[]::new));
    }

    public static IrregularTimeSeriesIndex create(Instant ... instants) {
        return new IrregularTimeSeriesIndex(instants);
    }

    public static IrregularTimeSeriesIndex create(List<Instant> instants) {
        Objects.requireNonNull(instants);
        return IrregularTimeSeriesIndex.create(instants.toArray(new Instant[0]));
    }

    public static IrregularTimeSeriesIndex parseJson(JsonParser parser) {
        return IrregularTimeSeriesIndex.parseJson(parser, TimeSeriesIndex.ExportFormat.MILLISECONDS);
    }

    public static IrregularTimeSeriesIndex parseJson(JsonParser parser, TimeSeriesIndex.ExportFormat timeFormat) {
        Objects.requireNonNull(parser);
        try {
            JsonToken token;
            ArrayList<Instant> instants = new ArrayList<Instant>();
            while ((token = parser.nextToken()) != null) {
                if (token == JsonToken.VALUE_NUMBER_INT) {
                    instants.add(timeFormat == TimeSeriesIndex.ExportFormat.MILLISECONDS ? Instant.ofEpochMilli(parser.getLongValue()) : TimeSeries.parseNanosToInstant(parser.getValueAsString()));
                    continue;
                }
                if (token != JsonToken.END_ARRAY) continue;
                return IrregularTimeSeriesIndex.create(instants);
            }
            throw new IllegalStateException("Should not happen");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public int getPointCount() {
        return this.instants.length;
    }

    @Override
    public Instant getInstantAt(int point) {
        return this.instants[point];
    }

    public int hashCode() {
        return Arrays.hashCode(this.instants);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IrregularTimeSeriesIndex) {
            IrregularTimeSeriesIndex otherIndex = (IrregularTimeSeriesIndex)obj;
            return Arrays.equals(this.instants, otherIndex.instants);
        }
        return false;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void writeJson(JsonGenerator generator, TimeSeriesIndex.ExportFormat timeFormat) {
        Objects.requireNonNull(generator);
        try {
            if (timeFormat == TimeSeriesIndex.ExportFormat.MILLISECONDS) {
                generator.writeArray(Arrays.stream(this.instants).mapToLong(Instant::toEpochMilli).toArray(), 0, this.instants.length);
            } else {
                generator.writeStartArray();
                for (Instant instant : this.instants) {
                    generator.writeNumber(new BigInteger(TimeSeries.writeInstantToNanoString(instant)));
                }
                generator.writeEndArray();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Iterator<Instant> iterator() {
        return this.stream().iterator();
    }

    @Override
    public Stream<Instant> stream() {
        return Arrays.stream(this.instants);
    }

    public String toString() {
        return "IrregularTimeSeriesIndex(times=" + this.stream().toList() + ")";
    }
}

