/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries;

import com.powsybl.timeseries.DoubleTimeSeries;
import com.powsybl.timeseries.ReadOnlyTimeSeriesStore;
import com.powsybl.timeseries.StringTimeSeries;
import com.powsybl.timeseries.TimeSeries;
import com.powsybl.timeseries.TimeSeriesFilter;
import com.powsybl.timeseries.TimeSeriesMetadata;
import com.powsybl.timeseries.TimeSeriesStoreListener;
import com.powsybl.timeseries.TimeSeriesVersions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ReadOnlyTimeSeriesStoreAggregator
implements ReadOnlyTimeSeriesStore {
    private final List<ReadOnlyTimeSeriesStore> stores;

    public ReadOnlyTimeSeriesStoreAggregator(ReadOnlyTimeSeriesStore ... stores) {
        this(Arrays.asList(stores));
    }

    public ReadOnlyTimeSeriesStoreAggregator(List<ReadOnlyTimeSeriesStore> stores) {
        this.stores = Objects.requireNonNull(stores);
    }

    @Override
    public Set<String> getTimeSeriesNames(TimeSeriesFilter filter) {
        HashSet<String> timeSeriesNames = new HashSet<String>();
        for (ReadOnlyTimeSeriesStore store : this.stores) {
            timeSeriesNames.addAll(store.getTimeSeriesNames(filter));
        }
        return timeSeriesNames;
    }

    @Override
    public boolean timeSeriesExists(String timeSeriesName) {
        Objects.requireNonNull(timeSeriesName);
        for (ReadOnlyTimeSeriesStore store : this.stores) {
            if (!store.timeSeriesExists(timeSeriesName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Optional<TimeSeriesMetadata> getTimeSeriesMetadata(String timeSeriesName) {
        Objects.requireNonNull(timeSeriesName);
        for (ReadOnlyTimeSeriesStore store : this.stores) {
            Optional<TimeSeriesMetadata> metadata = store.getTimeSeriesMetadata(timeSeriesName);
            if (!metadata.isPresent()) continue;
            return metadata;
        }
        return Optional.empty();
    }

    @Override
    public List<TimeSeriesMetadata> getTimeSeriesMetadata(Set<String> timeSeriesNames) {
        Objects.requireNonNull(timeSeriesNames);
        ArrayList<TimeSeriesMetadata> aggregatedMetadataList = new ArrayList<TimeSeriesMetadata>();
        HashSet<String> remainingTimeSeriesNames = new HashSet<String>(timeSeriesNames);
        for (ReadOnlyTimeSeriesStore store : this.stores) {
            List<TimeSeriesMetadata> metadataList = store.getTimeSeriesMetadata(remainingTimeSeriesNames);
            remainingTimeSeriesNames.removeAll(metadataList.stream().map(TimeSeriesMetadata::getName).collect(Collectors.toSet()));
            aggregatedMetadataList.addAll(metadataList);
            if (!remainingTimeSeriesNames.isEmpty()) continue;
            break;
        }
        return aggregatedMetadataList;
    }

    @Override
    public Set<Integer> getTimeSeriesDataVersions() {
        HashSet<Integer> versions = new HashSet<Integer>();
        for (ReadOnlyTimeSeriesStore store : this.stores) {
            versions.addAll(store.getTimeSeriesDataVersions());
        }
        return versions;
    }

    @Override
    public Set<Integer> getTimeSeriesDataVersions(String timeSeriesName) {
        Objects.requireNonNull(timeSeriesName);
        for (ReadOnlyTimeSeriesStore store : this.stores) {
            if (!store.timeSeriesExists(timeSeriesName)) continue;
            return store.getTimeSeriesDataVersions(timeSeriesName);
        }
        return Collections.emptySet();
    }

    @Override
    public Optional<DoubleTimeSeries> getDoubleTimeSeries(String timeSeriesName, int version) {
        Objects.requireNonNull(timeSeriesName);
        TimeSeriesVersions.check(version);
        for (ReadOnlyTimeSeriesStore store : this.stores) {
            Optional<DoubleTimeSeries> timeSeries = store.getDoubleTimeSeries(timeSeriesName, version);
            if (!timeSeries.isPresent()) continue;
            return timeSeries;
        }
        return Optional.empty();
    }

    @Override
    public List<DoubleTimeSeries> getDoubleTimeSeries(Set<String> timeSeriesNames, int version) {
        Objects.requireNonNull(timeSeriesNames);
        TimeSeriesVersions.check(version);
        ArrayList<DoubleTimeSeries> aggregatedTimeSeriesList = new ArrayList<DoubleTimeSeries>();
        HashSet<String> remainingTimeSeriesNames = new HashSet<String>(timeSeriesNames);
        for (ReadOnlyTimeSeriesStore store : this.stores) {
            List<DoubleTimeSeries> timeSeriesList = store.getDoubleTimeSeries(remainingTimeSeriesNames, version);
            remainingTimeSeriesNames.removeAll(timeSeriesList.stream().map(TimeSeries::getMetadata).map(TimeSeriesMetadata::getName).collect(Collectors.toSet()));
            aggregatedTimeSeriesList.addAll(timeSeriesList);
            if (!remainingTimeSeriesNames.isEmpty()) continue;
            break;
        }
        return aggregatedTimeSeriesList;
    }

    @Override
    public List<DoubleTimeSeries> getDoubleTimeSeries(int version) {
        return this.stores.stream().flatMap(store -> store.getDoubleTimeSeries(version).stream()).collect(Collectors.toList());
    }

    @Override
    public Optional<StringTimeSeries> getStringTimeSeries(String timeSeriesName, int version) {
        Objects.requireNonNull(timeSeriesName);
        TimeSeriesVersions.check(version);
        for (ReadOnlyTimeSeriesStore store : this.stores) {
            Optional<StringTimeSeries> timeSeries = store.getStringTimeSeries(timeSeriesName, version);
            if (!timeSeries.isPresent()) continue;
            return timeSeries;
        }
        return Optional.empty();
    }

    @Override
    public List<StringTimeSeries> getStringTimeSeries(Set<String> timeSeriesNames, int version) {
        Objects.requireNonNull(timeSeriesNames);
        TimeSeriesVersions.check(version);
        ArrayList<StringTimeSeries> aggregatedTimeSeriesList = new ArrayList<StringTimeSeries>();
        HashSet<String> remainingTimeSeriesNames = new HashSet<String>(timeSeriesNames);
        for (ReadOnlyTimeSeriesStore store : this.stores) {
            List<StringTimeSeries> timeSeriesList = store.getStringTimeSeries(remainingTimeSeriesNames, version);
            remainingTimeSeriesNames.removeAll(timeSeriesList.stream().map(TimeSeries::getMetadata).map(TimeSeriesMetadata::getName).collect(Collectors.toSet()));
            aggregatedTimeSeriesList.addAll(timeSeriesList);
            if (!remainingTimeSeriesNames.isEmpty()) continue;
            break;
        }
        return aggregatedTimeSeriesList;
    }

    @Override
    public void addListener(TimeSeriesStoreListener listener) {
        Objects.requireNonNull(listener);
        for (ReadOnlyTimeSeriesStore store : this.stores) {
            store.addListener(listener);
        }
    }

    @Override
    public void removeListener(TimeSeriesStoreListener listener) {
        Objects.requireNonNull(listener);
        for (ReadOnlyTimeSeriesStore store : this.stores) {
            store.removeListener(listener);
        }
    }
}

