/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries;

import com.powsybl.timeseries.DoubleTimeSeries;
import com.powsybl.timeseries.ReadOnlyTimeSeriesStore;
import com.powsybl.timeseries.StringTimeSeries;
import com.powsybl.timeseries.TimeSeries;
import com.powsybl.timeseries.TimeSeriesFilter;
import com.powsybl.timeseries.TimeSeriesMetadata;
import com.powsybl.timeseries.TimeSeriesStoreListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ReadOnlyTimeSeriesStoreCache
implements ReadOnlyTimeSeriesStore {
    private final Map<String, DoubleTimeSeries> doubleTimeSeriesMap;

    public ReadOnlyTimeSeriesStoreCache(DoubleTimeSeries ... doubleTimeSeriesList) {
        this(Arrays.asList(doubleTimeSeriesList));
    }

    public ReadOnlyTimeSeriesStoreCache(List<DoubleTimeSeries> doubleTimeSeriesList) {
        Objects.requireNonNull(doubleTimeSeriesList);
        this.doubleTimeSeriesMap = new HashMap<String, DoubleTimeSeries>(doubleTimeSeriesList.size());
        for (DoubleTimeSeries doubleTimeSeries : doubleTimeSeriesList) {
            this.doubleTimeSeriesMap.put(doubleTimeSeries.getMetadata().getName(), doubleTimeSeries);
        }
    }

    @Override
    public Set<String> getTimeSeriesNames(TimeSeriesFilter filter) {
        return this.doubleTimeSeriesMap.keySet();
    }

    @Override
    public boolean timeSeriesExists(String timeSeriesName) {
        return this.doubleTimeSeriesMap.containsKey(timeSeriesName);
    }

    @Override
    public Optional<TimeSeriesMetadata> getTimeSeriesMetadata(String timeSeriesName) {
        Objects.requireNonNull(timeSeriesName);
        return Optional.ofNullable(this.doubleTimeSeriesMap.get(timeSeriesName)).map(TimeSeries::getMetadata);
    }

    @Override
    public List<TimeSeriesMetadata> getTimeSeriesMetadata(Set<String> timeSeriesNames) {
        Objects.requireNonNull(timeSeriesNames);
        return timeSeriesNames.stream().map(this::getTimeSeriesMetadata).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Override
    public Set<Integer> getTimeSeriesDataVersions() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getTimeSeriesDataVersions(String timeSeriesName) {
        return Collections.emptySet();
    }

    @Override
    public Optional<DoubleTimeSeries> getDoubleTimeSeries(String timeSeriesName, int version) {
        return Optional.ofNullable(this.doubleTimeSeriesMap.get(timeSeriesName));
    }

    @Override
    public List<DoubleTimeSeries> getDoubleTimeSeries(Set<String> timeSeriesNames, int version) {
        return timeSeriesNames.stream().map(timeSeriesName -> this.getDoubleTimeSeries((String)timeSeriesName, version)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Override
    public List<DoubleTimeSeries> getDoubleTimeSeries(int version) {
        return new ArrayList<DoubleTimeSeries>(this.doubleTimeSeriesMap.values());
    }

    @Override
    public Optional<StringTimeSeries> getStringTimeSeries(String timeSeriesName, int version) {
        return Optional.empty();
    }

    @Override
    public List<StringTimeSeries> getStringTimeSeries(Set<String> timeSeriesNames, int version) {
        return Collections.emptyList();
    }

    private static UnsupportedOperationException createNotImplementedException() {
        return new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void addListener(TimeSeriesStoreListener listener) {
        throw ReadOnlyTimeSeriesStoreCache.createNotImplementedException();
    }

    @Override
    public void removeListener(TimeSeriesStoreListener listener) {
        throw ReadOnlyTimeSeriesStoreCache.createNotImplementedException();
    }
}

