/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.powsybl.timeseries.AbstractTimeSeriesIndex;
import com.powsybl.timeseries.TimeSeries;
import com.powsybl.timeseries.TimeSeriesIndex;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.threeten.extra.Interval;

public class RegularTimeSeriesIndex
extends AbstractTimeSeriesIndex {
    public static final String TYPE = "regularIndex";
    private static final Duration MAX_DAYS = Duration.ofDays(73000L);
    private final Instant startInstant;
    private final Instant endInstant;
    private final Duration timeStep;
    private final int pointCount;

    public RegularTimeSeriesIndex(Instant startInstant, Instant endInstant, Duration timeStep) {
        if (timeStep.isNegative()) {
            throw new IllegalArgumentException("Bad timeStep value " + timeStep);
        }
        if (timeStep.compareTo(Duration.between(startInstant, endInstant)) > 0) {
            throw new IllegalArgumentException("TimeStep " + timeStep + " is longer than interval " + Duration.between(startInstant, endInstant));
        }
        long computedPointCount = RegularTimeSeriesIndex.computePointCount(startInstant, endInstant, timeStep);
        if (computedPointCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Point Count " + computedPointCount + " is bigger than max allowed value 2147483647");
        }
        this.startInstant = startInstant;
        this.endInstant = endInstant;
        this.timeStep = timeStep;
        this.pointCount = (int)computedPointCount;
    }

    @Deprecated(since="6.7.0")
    public RegularTimeSeriesIndex(long startTime, long endTime, long spacing) {
        this(Instant.ofEpochMilli(startTime), Instant.ofEpochMilli(endTime), Duration.ofMillis(spacing));
    }

    public static RegularTimeSeriesIndex create(Instant start, Instant end, Duration spacing) {
        Objects.requireNonNull(start);
        Objects.requireNonNull(end);
        Objects.requireNonNull(spacing);
        return new RegularTimeSeriesIndex(start, end, spacing);
    }

    public static RegularTimeSeriesIndex create(Interval interval, Duration spacing) {
        Objects.requireNonNull(interval);
        return RegularTimeSeriesIndex.create(interval.getStart(), interval.getEnd(), spacing);
    }

    public static RegularTimeSeriesIndex parseJson(JsonParser parser) {
        Objects.requireNonNull(parser);
        try {
            JsonToken token;
            Instant startInstant = null;
            Instant endInstant = null;
            Duration timeStep = null;
            block22: while ((token = parser.nextToken()) != null) {
                switch (token) {
                    case FIELD_NAME: {
                        String fieldName;
                        switch (fieldName = parser.currentName()) {
                            case "startTime": {
                                startInstant = Instant.ofEpochMilli(parser.nextLongValue(-1L));
                                continue block22;
                            }
                            case "endTime": {
                                endInstant = Instant.ofEpochMilli(parser.nextLongValue(-1L));
                                continue block22;
                            }
                            case "spacing": {
                                timeStep = Duration.ofMillis(parser.nextLongValue(-1L));
                                continue block22;
                            }
                            case "startInstant": {
                                startInstant = RegularTimeSeriesIndex.parseNanoTokenToInstant(parser);
                                continue block22;
                            }
                            case "endInstant": {
                                endInstant = RegularTimeSeriesIndex.parseNanoTokenToInstant(parser);
                                continue block22;
                            }
                            case "timeStep": {
                                timeStep = Duration.ofNanos(parser.nextLongValue(-1L));
                                continue block22;
                            }
                        }
                        throw new IllegalStateException("Unexpected field " + fieldName);
                    }
                    case END_OBJECT: {
                        if (startInstant == null || endInstant == null || timeStep == null) {
                            throw new IllegalStateException("Incomplete regular time series index json");
                        }
                        return new RegularTimeSeriesIndex(startInstant, endInstant, timeStep);
                    }
                }
            }
            throw new IllegalStateException("Should not happen");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Deprecated(since="6.7.0")
    public long getStartTime() {
        return this.startInstant.toEpochMilli();
    }

    public Instant getStartInstant() {
        return this.startInstant;
    }

    @Deprecated(since="6.7.0")
    public long getEndTime() {
        return this.endInstant.toEpochMilli();
    }

    public Instant getEndInstant() {
        return this.endInstant;
    }

    @Deprecated(since="6.7.0")
    public long getSpacing() {
        return this.timeStep.toMillis();
    }

    public Duration getTimeStep() {
        return this.timeStep;
    }

    private static long computePointCount(Instant startTime, Instant endTime, Duration spacing) {
        if (startTime == null || endTime == null || spacing == null) {
            throw new IllegalArgumentException("startTime, endTime, and spacing cannot be null.");
        }
        Duration duration = Duration.between(startTime, endTime);
        if (duration.compareTo(MAX_DAYS) > 0 || spacing.compareTo(MAX_DAYS) > 0) {
            throw new IllegalArgumentException("Time range or spacing exceeds " + MAX_DAYS.toDays() + " days.");
        }
        return Math.round((double)duration.toNanos() / (double)spacing.toNanos()) + 1L;
    }

    @Override
    public int getPointCount() {
        return this.pointCount;
    }

    @Override
    public Instant getInstantAt(int point) {
        return this.startInstant.plus(this.timeStep.multipliedBy(point));
    }

    public int hashCode() {
        return Objects.hash(this.startInstant, this.endInstant, this.timeStep);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimeSeriesIndex) {
            RegularTimeSeriesIndex otherIndex = (RegularTimeSeriesIndex)obj;
            return this.startInstant.equals(otherIndex.startInstant) && this.endInstant.equals(otherIndex.endInstant) && this.timeStep.equals(otherIndex.timeStep);
        }
        return false;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void writeJson(JsonGenerator generator, TimeSeriesIndex.ExportFormat timeFormat) {
        Objects.requireNonNull(generator);
        try {
            generator.writeStartObject();
            if (timeFormat == TimeSeriesIndex.ExportFormat.MILLISECONDS) {
                generator.writeNumberField("startTime", this.startInstant.toEpochMilli());
                generator.writeNumberField("endTime", this.endInstant.toEpochMilli());
                generator.writeNumberField("spacing", this.timeStep.toMillis());
            } else {
                generator.writeNumberField("startInstant", new BigInteger(TimeSeries.writeInstantToNanoString(this.startInstant)));
                generator.writeNumberField("endInstant", new BigInteger(TimeSeries.writeInstantToNanoString(this.endInstant)));
                generator.writeNumberField("timeStep", this.timeStep.toNanos());
            }
            generator.writeEndObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Iterator<Instant> iterator() {
        return new Iterator<Instant>(){
            Instant time;
            {
                this.time = RegularTimeSeriesIndex.this.startInstant;
            }

            @Override
            public boolean hasNext() {
                return this.time.compareTo(RegularTimeSeriesIndex.this.endInstant) <= 0;
            }

            @Override
            public Instant next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Instant instant = this.time;
                this.time = this.time.plus(RegularTimeSeriesIndex.this.timeStep);
                return instant;
            }
        };
    }

    @Override
    public Stream<Instant> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 1040), false);
    }

    public String toString() {
        return "RegularTimeSeriesIndex(startInstant=" + this.startInstant + ", endInstant=" + this.endInstant + ", timeStep=" + this.timeStep + ")";
    }

    private static Instant parseNanoTokenToInstant(JsonParser parser) throws IOException {
        parser.nextToken();
        return TimeSeries.parseNanosToInstant(parser.getValueAsString());
    }
}

