/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries;

import com.powsybl.timeseries.AbstractTimeSeries;
import com.powsybl.timeseries.BigDoubleBuffer;
import com.powsybl.timeseries.CompressedDoubleDataChunk;
import com.powsybl.timeseries.DataChunk;
import com.powsybl.timeseries.DoubleDataChunk;
import com.powsybl.timeseries.DoublePoint;
import com.powsybl.timeseries.DoubleTimeSeries;
import com.powsybl.timeseries.TimeSeriesMetadata;
import java.nio.DoubleBuffer;
import java.util.List;
import java.util.function.Consumer;

public class StoredDoubleTimeSeries
extends AbstractTimeSeries<DoublePoint, DoubleDataChunk, DoubleTimeSeries>
implements DoubleTimeSeries {
    private static final double[] NAN_ARRAY = new double[]{Double.NaN};

    public StoredDoubleTimeSeries(TimeSeriesMetadata metadata, DoubleDataChunk ... chunks) {
        super(metadata, (DataChunk[])chunks);
    }

    public StoredDoubleTimeSeries(TimeSeriesMetadata metadata, List<DoubleDataChunk> chunks) {
        super(metadata, chunks);
    }

    @Override
    protected CompressedDoubleDataChunk createGapFillingChunk(int i, int length) {
        return new CompressedDoubleDataChunk(i, length, NAN_ARRAY, new int[]{length});
    }

    @Override
    protected DoubleTimeSeries createTimeSeries(DoubleDataChunk chunk) {
        return new StoredDoubleTimeSeries(this.metadata, chunk);
    }

    private void forEachChunk(Consumer<DoubleDataChunk> consumer) {
        this.chunks.forEach(consumer);
    }

    @Override
    public void fillBuffer(DoubleBuffer buffer, int timeSeriesOffset) {
        this.forEachChunk(chunk -> chunk.fillBuffer(buffer, timeSeriesOffset));
    }

    @Override
    public void fillBuffer(BigDoubleBuffer buffer, long timeSeriesOffset) {
        this.forEachChunk(chunk -> chunk.fillBuffer(buffer, timeSeriesOffset));
    }

    @Override
    public double[] toArray() {
        DoubleBuffer buffer = DoubleBuffer.allocate(this.metadata.getIndex().getPointCount());
        for (int i = 0; i < this.metadata.getIndex().getPointCount(); ++i) {
            buffer.put(i, Double.NaN);
        }
        this.fillBuffer(buffer, 0);
        return buffer.array();
    }
}

