/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries;

import com.powsybl.timeseries.AbstractTimeSeries;
import com.powsybl.timeseries.BigStringBuffer;
import com.powsybl.timeseries.CompactStringBuffer;
import com.powsybl.timeseries.CompressedStringDataChunk;
import com.powsybl.timeseries.DataChunk;
import com.powsybl.timeseries.StringDataChunk;
import com.powsybl.timeseries.StringPoint;
import com.powsybl.timeseries.TimeSeries;
import com.powsybl.timeseries.TimeSeriesMetadata;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Consumer;

public class StringTimeSeries
extends AbstractTimeSeries<StringPoint, StringDataChunk, StringTimeSeries>
implements TimeSeries<StringPoint, StringTimeSeries> {
    private static final String[] NULL_ARRAY = new String[]{null};

    public StringTimeSeries(TimeSeriesMetadata metadata, StringDataChunk ... chunks) {
        super(metadata, (DataChunk[])chunks);
    }

    public StringTimeSeries(TimeSeriesMetadata metadata, List<StringDataChunk> chunks) {
        super(metadata, chunks);
    }

    @Override
    protected CompressedStringDataChunk createGapFillingChunk(int i, int length) {
        return new CompressedStringDataChunk(i, length, NULL_ARRAY, new int[]{length});
    }

    @Override
    protected StringTimeSeries createTimeSeries(StringDataChunk chunk) {
        return new StringTimeSeries(this.metadata, chunk);
    }

    private void forEachChunk(Consumer<StringDataChunk> consumer) {
        this.chunks.forEach(consumer);
    }

    public void fillBuffer(CompactStringBuffer buffer, int timeSeriesOffset) {
        this.forEachChunk(chunk -> chunk.fillBuffer(buffer, timeSeriesOffset));
    }

    public void fillBuffer(BigStringBuffer buffer, long timeSeriesOffset) {
        this.forEachChunk(chunk -> chunk.fillBuffer(buffer, timeSeriesOffset));
    }

    public String[] toArray() {
        CompactStringBuffer buffer = new CompactStringBuffer(ByteBuffer::allocate, this.metadata.getIndex().getPointCount());
        this.chunks.forEach(chunk -> chunk.fillBuffer(buffer, 0));
        return buffer.toArray();
    }
}

