/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Stopwatch;
import com.google.common.primitives.Doubles;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.timeseries.AbstractPoint;
import com.powsybl.timeseries.CalculatedTimeSeries;
import com.powsybl.timeseries.DataChunk;
import com.powsybl.timeseries.DoubleDataChunk;
import com.powsybl.timeseries.DoublePoint;
import com.powsybl.timeseries.InfiniteTimeSeriesIndex;
import com.powsybl.timeseries.IrregularTimeSeriesIndex;
import com.powsybl.timeseries.RegularTimeSeriesIndex;
import com.powsybl.timeseries.StoredDoubleTimeSeries;
import com.powsybl.timeseries.StringDataChunk;
import com.powsybl.timeseries.StringTimeSeries;
import com.powsybl.timeseries.TimeSeriesCsvConfig;
import com.powsybl.timeseries.TimeSeriesDataType;
import com.powsybl.timeseries.TimeSeriesException;
import com.powsybl.timeseries.TimeSeriesIndex;
import com.powsybl.timeseries.TimeSeriesMetadata;
import com.powsybl.timeseries.TimeSeriesNameResolver;
import com.powsybl.timeseries.TimeseriesReports;
import com.powsybl.timeseries.UncompressedDoubleDataChunk;
import com.powsybl.timeseries.UncompressedStringDataChunk;
import com.powsybl.timeseries.ast.NodeCalc;
import com.univocity.parsers.common.ParsingContext;
import com.univocity.parsers.common.ResultIterator;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import gnu.trove.list.array.TDoubleArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface TimeSeries<P extends AbstractPoint, T extends TimeSeries<P, T>>
extends Iterable<P> {
    public static final Logger LOGGER = LoggerFactory.getLogger(TimeSeries.class);
    public static final int DEFAULT_VERSION_NUMBER_FOR_UNVERSIONED_TIMESERIES = -1;

    public TimeSeriesMetadata getMetadata();

    public void synchronize(TimeSeriesIndex var1);

    public Stream<P> stream();

    @Override
    public Iterator<P> iterator();

    public List<T> split(int var1);

    public void setTimeSeriesNameResolver(TimeSeriesNameResolver var1);

    public static StoredDoubleTimeSeries createDouble(String name, TimeSeriesIndex index) {
        return TimeSeries.createDouble(name, index, new double[0]);
    }

    public static StoredDoubleTimeSeries createDouble(String name, TimeSeriesIndex index, double ... values) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(index);
        Objects.requireNonNull(values);
        ArrayList<DoubleDataChunk> chunks = new ArrayList<DoubleDataChunk>();
        if (values.length > 0) {
            if (index.getPointCount() != values.length) {
                throw new IllegalArgumentException("Bad number of values " + values.length + ", expected " + index.getPointCount());
            }
            chunks.add(new UncompressedDoubleDataChunk(0, values));
        }
        return new StoredDoubleTimeSeries(new TimeSeriesMetadata(name, TimeSeriesDataType.DOUBLE, index), (List<DoubleDataChunk>)chunks);
    }

    public static StringTimeSeries createString(String name, TimeSeriesIndex index) {
        return TimeSeries.createString(name, index, new String[0]);
    }

    public static int computeChunkCount(TimeSeriesIndex index, int newChunkSize) {
        return (int)Math.ceil((double)index.getPointCount() / (double)newChunkSize);
    }

    public static StringTimeSeries createString(String name, TimeSeriesIndex index, String ... values) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(index);
        Objects.requireNonNull(values);
        ArrayList<StringDataChunk> chunks = new ArrayList<StringDataChunk>();
        if (values.length > 0) {
            if (index.getPointCount() != values.length) {
                throw new IllegalArgumentException("Bad number of values " + values.length + ", expected " + index.getPointCount());
            }
            chunks.add(new UncompressedStringDataChunk(0, values));
        }
        return new StringTimeSeries(new TimeSeriesMetadata(name, TimeSeriesDataType.STRING, index), (List<StringDataChunk>)chunks);
    }

    public static <P extends AbstractPoint, T extends TimeSeries<P, T>> List<List<T>> split(List<T> timeSeriesList, int newChunkSize) {
        Objects.requireNonNull(timeSeriesList);
        if (timeSeriesList.isEmpty()) {
            throw new IllegalArgumentException("Time series list is empty");
        }
        if (newChunkSize < 1) {
            throw new IllegalArgumentException("Invalid chunk size: " + newChunkSize);
        }
        Set indexes = timeSeriesList.stream().map(ts -> ts.getMetadata().getIndex()).filter(index -> !(index instanceof InfiniteTimeSeriesIndex)).collect(Collectors.toSet());
        if (indexes.isEmpty()) {
            throw new IllegalArgumentException("Cannot split a list of time series with only infinite index");
        }
        if (indexes.size() != 1) {
            throw new IllegalArgumentException("Cannot split a list of time series with different time indexes: " + indexes);
        }
        TimeSeriesIndex index2 = (TimeSeriesIndex)indexes.iterator().next();
        if (newChunkSize > index2.getPointCount()) {
            throw new IllegalArgumentException("New chunk size " + newChunkSize + " is greater than point count " + index2.getPointCount());
        }
        int chunkCount = TimeSeries.computeChunkCount(index2, newChunkSize);
        ArrayList<List<T>> splitList = new ArrayList<List<T>>(chunkCount);
        for (int i = 0; i < chunkCount; ++i) {
            splitList.add(new ArrayList(timeSeriesList.size()));
        }
        for (TimeSeries timeSeries : timeSeriesList) {
            List<T> split = timeSeries.split(newChunkSize);
            for (int i = 0; i < chunkCount; ++i) {
                ((List)splitList.get(i)).add((TimeSeries)split.get(i));
            }
        }
        return splitList;
    }

    public static Map<Integer, List<TimeSeries>> parseCsv(Path file) {
        return TimeSeries.parseCsv(file, new TimeSeriesCsvConfig(), ReportNode.NO_OP);
    }

    public static Map<Integer, List<TimeSeries>> parseCsv(String csv) {
        return TimeSeries.parseCsv(csv, new TimeSeriesCsvConfig(), ReportNode.NO_OP);
    }

    public static Map<Integer, List<TimeSeries>> parseCsv(Path file, TimeSeriesCsvConfig timeSeriesCsvConfig) {
        return TimeSeries.parseCsv(file, timeSeriesCsvConfig, ReportNode.NO_OP);
    }

    public static Map<Integer, List<TimeSeries>> parseCsv(String csv, TimeSeriesCsvConfig timeSeriesCsvConfig) {
        return TimeSeries.parseCsv(csv, timeSeriesCsvConfig, ReportNode.NO_OP);
    }

    public static Map<Integer, List<TimeSeries>> parseCsv(String csv, TimeSeriesCsvConfig timeSeriesCsvConfig, ReportNode reportNode) {
        Map<Integer, List<TimeSeries>> map;
        BufferedReader reader = new BufferedReader(new StringReader(csv));
        try {
            map = TimeSeries.parseCsv(reader, timeSeriesCsvConfig, reportNode);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        reader.close();
        return map;
    }

    public static Map<Integer, List<TimeSeries>> parseCsv(Path file, TimeSeriesCsvConfig timeSeriesCsvConfig, ReportNode reportNode) {
        Map<Integer, List<TimeSeries>> map;
        block8: {
            BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);
            try {
                map = TimeSeries.parseCsv(reader, timeSeriesCsvConfig, reportNode);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            reader.close();
        }
        return map;
    }

    public static double parseDouble(String token) {
        return token.isEmpty() ? Double.NaN : Double.parseDouble(token);
    }

    public static String checkString(String token) {
        return token.isEmpty() ? null : token;
    }

    public static void readCsvValues(ResultIterator<String[], ParsingContext> iterator, CsvParsingContext context, Map<Integer, List<TimeSeries>> timeSeriesPerVersion, ReportNode reportNode) {
        Consumer<String[]> lineparser;
        int currentVersion = Integer.MIN_VALUE;
        Consumer<String[]> consumer = context.timeSeriesCsvConfig.isSkipDuplicateTimeEntry() ? context::parseLineDuplicate : (lineparser = context::parseLine);
        while (iterator.hasNext()) {
            String[] tokens = (String[])iterator.next();
            if (tokens.length != context.expectedTokens()) {
                throw new TimeSeriesException("Columns of line " + context.timesSize() + " are inconsistent with header");
            }
            int version = context.getVersion(tokens, reportNode);
            if (currentVersion == Integer.MIN_VALUE) {
                currentVersion = version;
            } else if (version != currentVersion) {
                timeSeriesPerVersion.put(currentVersion, context.createTimeSeries());
                context.reInit();
                currentVersion = version;
            }
            lineparser.accept(tokens);
        }
        timeSeriesPerVersion.put(currentVersion, context.createTimeSeries());
    }

    public static CsvParsingContext readCsvHeader(ResultIterator<String[], ParsingContext> iterator, TimeSeriesCsvConfig timeSeriesCsvConfig) {
        if (!iterator.hasNext()) {
            throw new TimeSeriesException("CSV header is missing");
        }
        String[] tokens = (String[])iterator.next();
        TimeSeries.checkCsvHeader(timeSeriesCsvConfig, tokens);
        ArrayList<String> duplicates = new ArrayList<String>();
        HashSet<String> namesWithoutDuplicates = new HashSet<String>();
        for (String token : tokens) {
            if (namesWithoutDuplicates.add(token)) continue;
            duplicates.add(token);
        }
        if (!duplicates.isEmpty()) {
            throw new TimeSeriesException("Bad CSV header, there are duplicates in time series names " + duplicates);
        }
        List<String> names = Arrays.asList(tokens).subList(timeSeriesCsvConfig.versioned() ? 2 : 1, tokens.length);
        return new CsvParsingContext(names, timeSeriesCsvConfig);
    }

    public static void checkCsvHeader(TimeSeriesCsvConfig timeSeriesCsvConfig, String[] tokens) {
        String separatorStr = Character.toString(timeSeriesCsvConfig.separator());
        if (!(!timeSeriesCsvConfig.versioned() || tokens.length >= 3 && "time".equalsIgnoreCase(tokens[0]) && "version".equalsIgnoreCase(tokens[1]))) {
            throw new TimeSeriesException("Bad CSV header, should be \ntime" + separatorStr + "version" + separatorStr + "...");
        }
        if (tokens.length < 2 || !"time".equalsIgnoreCase(tokens[0])) {
            throw new TimeSeriesException("Bad CSV header, should be \ntime" + separatorStr + "...");
        }
    }

    public static Map<Integer, List<TimeSeries>> parseCsv(BufferedReader reader, TimeSeriesCsvConfig timeSeriesCsvConfig) {
        return TimeSeries.parseCsv(reader, timeSeriesCsvConfig, ReportNode.NO_OP);
    }

    public static Map<Integer, List<TimeSeries>> parseCsv(BufferedReader reader, TimeSeriesCsvConfig timeSeriesCsvConfig, ReportNode reportNode) {
        Objects.requireNonNull(reader);
        Stopwatch stopwatch = Stopwatch.createStarted();
        HashMap<Integer, List<TimeSeries>> timeSeriesPerVersion = new HashMap<Integer, List<TimeSeries>>();
        CsvParserSettings settings = new CsvParserSettings();
        ((CsvFormat)settings.getFormat()).setDelimiter(timeSeriesCsvConfig.separator());
        ((CsvFormat)settings.getFormat()).setQuoteEscape('\"');
        ((CsvFormat)settings.getFormat()).setLineSeparator(System.lineSeparator());
        settings.setMaxColumns(timeSeriesCsvConfig.getMaxColumns());
        CsvParser csvParser = new CsvParser(settings);
        ResultIterator iterator = csvParser.iterate((Reader)reader).iterator();
        CsvParsingContext context = TimeSeries.readCsvHeader((ResultIterator<String[], ParsingContext>)iterator, timeSeriesCsvConfig);
        TimeSeries.readCsvValues((ResultIterator<String[], ParsingContext>)iterator, context, timeSeriesPerVersion, reportNode);
        long timing = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        LOGGER.info("{} time series loaded from CSV in {} ms", (Object)timeSeriesPerVersion.values().stream().mapToInt(List::size).sum(), (Object)timing);
        TimeseriesReports.timeseriesLoadingTimeDuration(reportNode, timeSeriesPerVersion.values().stream().mapToInt(List::size).sum(), timing);
        return timeSeriesPerVersion;
    }

    public void writeJson(JsonGenerator var1);

    public String toJson();

    public static void writeJson(JsonGenerator generator, List<? extends TimeSeries> timeSeriesList) {
        Objects.requireNonNull(timeSeriesList);
        try {
            generator.writeStartArray();
            for (TimeSeries timeSeries : timeSeriesList) {
                timeSeries.writeJson(generator);
            }
            generator.writeEndArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void writeJson(Writer writer, List<? extends TimeSeries> timeSeriesList) {
        JsonUtil.writeJson((Writer)writer, (T generator) -> TimeSeries.writeJson(generator, timeSeriesList));
    }

    public static void writeJson(Path file, List<? extends TimeSeries> timeSeriesList) {
        JsonUtil.writeJson((Path)file, (T generator) -> TimeSeries.writeJson(generator, timeSeriesList));
    }

    public static String toJson(List<? extends TimeSeries> timeSeriesList) {
        return JsonUtil.toJson((T generator) -> TimeSeries.writeJson(generator, timeSeriesList));
    }

    public static void parseChunks(JsonParser parser, TimeSeriesMetadata metadata, List<TimeSeries> timeSeriesList) {
        Objects.requireNonNull(metadata);
        ArrayList<DoubleDataChunk> doubleChunks = new ArrayList<DoubleDataChunk>();
        ArrayList<StringDataChunk> stringChunks = new ArrayList<StringDataChunk>();
        DataChunk.parseJson(parser, doubleChunks, stringChunks);
        if (metadata.getDataType() == TimeSeriesDataType.DOUBLE) {
            if (!stringChunks.isEmpty()) {
                throw new TimeSeriesException("String chunks found in a double time series");
            }
            timeSeriesList.add(new StoredDoubleTimeSeries(metadata, (List<DoubleDataChunk>)doubleChunks));
        } else if (metadata.getDataType() == TimeSeriesDataType.STRING) {
            if (!doubleChunks.isEmpty()) {
                throw new TimeSeriesException("Double chunks found in a string time series");
            }
            timeSeriesList.add(new StringTimeSeries(metadata, (List<StringDataChunk>)stringChunks));
        } else {
            throw new TimeSeriesException("Unexpected time series data type " + metadata.getDataType());
        }
    }

    public static List<TimeSeries> parseJson(JsonParser parser) {
        return TimeSeries.parseJson(parser, false);
    }

    public static List<TimeSeries> parseJson(JsonParser parser, boolean single) {
        Objects.requireNonNull(parser);
        ArrayList<TimeSeries> timeSeriesList = new ArrayList<TimeSeries>();
        try {
            JsonToken token;
            TimeSeriesMetadata metadata = null;
            String name = null;
            while ((token = parser.nextToken()) != null) {
                if (token == JsonToken.FIELD_NAME) {
                    String fieldName;
                    switch (fieldName = parser.currentName()) {
                        case "metadata": {
                            metadata = TimeSeriesMetadata.parseJson(parser);
                            break;
                        }
                        case "chunks": {
                            if (metadata == null) {
                                throw new TimeSeriesException("metadata is null");
                            }
                            TimeSeries.parseChunks(parser, metadata, timeSeriesList);
                            metadata = null;
                            break;
                        }
                        case "name": {
                            name = parser.nextTextValue();
                            break;
                        }
                        case "expr": {
                            Objects.requireNonNull(name);
                            NodeCalc nodeCalc = NodeCalc.parseJson(parser);
                            timeSeriesList.add(new CalculatedTimeSeries(name, nodeCalc));
                            break;
                        }
                    }
                    continue;
                }
                if (token != JsonToken.END_OBJECT || !single) continue;
                break;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return timeSeriesList;
    }

    public static List<TimeSeries> parseJson(String json) {
        return (List)JsonUtil.parseJson((String)json, TimeSeries::parseJson);
    }

    public static List<TimeSeries> parseJson(Reader reader) {
        return (List)JsonUtil.parseJson((Reader)reader, TimeSeries::parseJson);
    }

    public static List<TimeSeries> parseJson(Path file) {
        return (List)JsonUtil.parseJson((Path)file, TimeSeries::parseJson);
    }

    public static Instant parseDoubleToInstant(String doubleString) {
        BigDecimal bd = new BigDecimal(doubleString);
        BigDecimal seconds = bd.setScale(0, RoundingMode.DOWN);
        BigDecimal nanos = bd.subtract(seconds).multiply(BigDecimal.valueOf(1000000000L));
        return Instant.ofEpochSecond(seconds.longValue(), nanos.longValue());
    }

    public static Instant parseMicrosToInstant(String token) {
        return TimeSeries.parsePreciseDateToInstant(token, 6);
    }

    public static Instant parseNanosToInstant(String token) {
        return TimeSeries.parsePreciseDateToInstant(token, 9);
    }

    public static Instant parsePreciseDateToInstant(String timestamp, int precision) {
        long multiplier = (long)Math.pow(10.0, 9.0 - (double)precision);
        return timestamp.length() > precision ? Instant.ofEpochSecond(Long.parseLong(timestamp.substring(0, timestamp.length() - precision)), Long.parseLong(timestamp.substring(timestamp.length() - precision)) * multiplier) : Instant.ofEpochSecond(0L, Long.parseLong(timestamp) * multiplier);
    }

    public static String writeInstantToMicroString(Instant instant) {
        return TimeSeries.writeInstantToString(instant, 6);
    }

    public static String writeInstantToNanoString(Instant instant) {
        return TimeSeries.writeInstantToString(instant, 9);
    }

    public static String writeInstantToString(Instant instant, int precision) {
        long scale;
        long seconds = instant.getEpochSecond();
        int nanos = instant.getNano();
        long divisor = (long)Math.pow(10.0, 9.0 - (double)precision);
        long fraction = (long)nanos / divisor;
        if ((long)nanos % divisor * 2L >= divisor) {
            ++fraction;
        }
        if (fraction >= (scale = (long)Math.pow(10.0, precision)) && seconds > 0L) {
            ++seconds;
            fraction = 0L;
        }
        if (seconds > 0L) {
            String format = "%0" + precision + "d";
            String fractionStr = String.format(format, fraction);
            return seconds + fractionStr;
        }
        return String.valueOf(fraction);
    }

    public static class CsvParsingContext {
        private final List<String> names;
        private final TimeSeriesCsvConfig timeSeriesCsvConfig;
        private final int fixedColumns;
        private final TimeSeriesDataType[] dataTypes;
        private final Object[] values;
        private final List<Instant> instants = new ArrayList<Instant>();
        private TimeSeriesIndex refIndex;

        CsvParsingContext(List<String> names) {
            this(names, new TimeSeriesCsvConfig());
        }

        CsvParsingContext(List<String> names, TimeSeriesCsvConfig timeSeriesCsvConfig) {
            this.names = names;
            this.timeSeriesCsvConfig = timeSeriesCsvConfig;
            this.fixedColumns = timeSeriesCsvConfig.versioned() ? 2 : 1;
            this.dataTypes = new TimeSeriesDataType[names.size()];
            this.values = new Object[names.size()];
        }

        private static TimeSeriesException assertDataType(TimeSeriesDataType dataType) {
            return new TimeSeriesException("Unexpected data type " + dataType);
        }

        private TDoubleArrayList createDoubleValues() {
            TDoubleArrayList doubleValues = new TDoubleArrayList();
            if (!this.instants.isEmpty()) {
                doubleValues.fill(0, this.instants.size(), Double.NaN);
            }
            return doubleValues;
        }

        private List<String> createStringValues() {
            ArrayList<String> stringValues = new ArrayList<String>();
            if (!this.instants.isEmpty()) {
                for (int j = 0; j < this.instants.size(); ++j) {
                    stringValues.add(null);
                }
            }
            return stringValues;
        }

        int getVersion(String[] tokens, ReportNode reportNode) {
            int version = -1;
            if (this.timeSeriesCsvConfig.versioned() && (version = Integer.parseInt(tokens[1])) == -1) {
                String line = String.join((CharSequence)";", tokens);
                if (this.timeSeriesCsvConfig.withStrictVersioningImport()) {
                    throw new TimeSeriesException(String.format("The version number for a versioned TimeSeries cannot be equals to the default version number (%s) at line \"%s\"", -1, line));
                }
                TimeseriesReports.warnsOnTimeseriesVersionNumber(reportNode, -1, line);
                LOGGER.warn("The version number for a versioned TimeSeries should not be equals to the default version number ({}) at line \"{}}\"", (Object)-1, (Object)line);
            }
            return version;
        }

        int timesSize() {
            return this.instants.size();
        }

        int expectedTokens() {
            return this.names.size() + this.fixedColumns;
        }

        void parseToken(int i, String token) {
            if (this.dataTypes[i - this.fixedColumns] == null) {
                if (Doubles.tryParse((String)token) != null) {
                    this.dataTypes[i - this.fixedColumns] = TimeSeriesDataType.DOUBLE;
                    TDoubleArrayList doubleValues = this.createDoubleValues();
                    doubleValues.add(TimeSeries.parseDouble(token));
                    this.values[i - this.fixedColumns] = doubleValues;
                } else {
                    this.dataTypes[i - this.fixedColumns] = TimeSeriesDataType.STRING;
                    List<String> stringValues = this.createStringValues();
                    stringValues.add(TimeSeries.checkString(token));
                    this.values[i - this.fixedColumns] = stringValues;
                }
            } else if (this.dataTypes[i - this.fixedColumns] == TimeSeriesDataType.DOUBLE) {
                ((TDoubleArrayList)this.values[i - this.fixedColumns]).add(TimeSeries.parseDouble(token));
            } else if (this.dataTypes[i - this.fixedColumns] == TimeSeriesDataType.STRING) {
                ((List)this.values[i - this.fixedColumns]).add(TimeSeries.checkString(token));
            } else {
                throw CsvParsingContext.assertDataType(this.dataTypes[i - this.fixedColumns]);
            }
        }

        void parseLineDuplicate(String[] tokens) {
            Instant time = this.parseTokenTime(tokens[0]);
            if (this.instants.isEmpty() || !this.instants.get(this.instants.size() - 1).equals(time)) {
                this.parseTokenData(tokens);
                this.instants.add(time);
            } else {
                LOGGER.warn("Row with the same time have already been read, the row will be skipped");
            }
        }

        void parseLine(String[] tokens) {
            this.parseTokenData(tokens);
            this.instants.add(this.parseTokenTime(tokens[0]));
        }

        void parseTokenData(String[] tokens) {
            for (int i = this.fixedColumns; i < tokens.length; ++i) {
                String token = tokens[i] != null ? tokens[i].trim() : "";
                this.parseToken(i, token);
            }
        }

        Instant parseTokenTime(String token) {
            TimeFormat timeFormat = this.timeSeriesCsvConfig.timeFormat();
            return switch (timeFormat) {
                default -> throw new IncompatibleClassChangeError();
                case TimeFormat.DATE_TIME -> ZonedDateTime.parse(token).toInstant();
                case TimeFormat.FRACTIONS_OF_SECOND -> TimeSeries.parseDoubleToInstant(token);
                case TimeFormat.MILLIS -> Instant.ofEpochMilli(Long.parseLong(token));
                case TimeFormat.MICROS -> TimeSeries.parseMicrosToInstant(token);
                case TimeFormat.NANOS -> TimeSeries.parseNanosToInstant(token);
            };
        }

        void reInit() {
            this.instants.clear();
            for (int i = 0; i < this.dataTypes.length; ++i) {
                if (this.dataTypes[i] == TimeSeriesDataType.DOUBLE) {
                    ((TDoubleArrayList)this.values[i]).clear();
                    continue;
                }
                if (this.dataTypes[i] == TimeSeriesDataType.STRING) {
                    ((List)this.values[i]).clear();
                    continue;
                }
                throw CsvParsingContext.assertDataType(this.dataTypes[i]);
            }
        }

        List<TimeSeries> createTimeSeries() {
            TimeSeriesIndex index = this.getTimeSeriesIndex();
            if (this.refIndex != null && !index.equals(this.refIndex)) {
                throw new TimeSeriesException("All version of the data must have the same index: " + this.refIndex + " != " + index);
            }
            this.refIndex = index;
            ArrayList<TimeSeries> timeSeriesList = new ArrayList<TimeSeries>(this.names.size());
            for (int i = 0; i < this.names.size(); ++i) {
                DataChunk<DoublePoint, DoubleDataChunk> chunk;
                if (Objects.isNull(this.names.get(i))) {
                    LOGGER.warn("Timeseries without name");
                    continue;
                }
                TimeSeriesMetadata metadata = new TimeSeriesMetadata(this.names.get(i), this.dataTypes[i], index);
                if (this.dataTypes[i] == TimeSeriesDataType.DOUBLE) {
                    TDoubleArrayList doubleValues = (TDoubleArrayList)this.values[i];
                    chunk = new UncompressedDoubleDataChunk(0, doubleValues.toArray()).tryToCompress();
                    timeSeriesList.add(new StoredDoubleTimeSeries(metadata, new DoubleDataChunk[]{chunk}));
                    continue;
                }
                if (this.dataTypes[i] == TimeSeriesDataType.STRING) {
                    List stringValues = (List)this.values[i];
                    chunk = new UncompressedStringDataChunk(0, stringValues.toArray(new String[0])).tryToCompress();
                    timeSeriesList.add(new StringTimeSeries(metadata, new StringDataChunk[]{chunk}));
                    continue;
                }
                throw CsvParsingContext.assertDataType(this.dataTypes[i - this.fixedColumns]);
            }
            return timeSeriesList;
        }

        private TimeSeriesIndex getTimeSeriesIndex() {
            Duration spacing = this.checkRegularSpacing();
            if (spacing != null) {
                return new RegularTimeSeriesIndex(this.instants.get(0), this.instants.get(this.instants.size() - 1), spacing);
            }
            return IrregularTimeSeriesIndex.create(this.instants);
        }

        private Duration checkRegularSpacing() {
            if (this.instants.size() < 2) {
                throw new TimeSeriesException("At least 2 rows are expected");
            }
            Duration spacing = null;
            for (int i = 1; i < this.instants.size(); ++i) {
                Duration duration = Duration.between(this.instants.get(i - 1), this.instants.get(i));
                if (spacing == null) {
                    spacing = duration;
                    continue;
                }
                if (duration.equals(spacing)) continue;
                return null;
            }
            return spacing;
        }
    }

    public static enum TimeFormat {
        DATE_TIME,
        MILLIS,
        MICROS,
        NANOS,
        FRACTIONS_OF_SECOND;

    }
}

