/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries;

import com.powsybl.timeseries.TimeSeries;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class TimeSeriesCsvConfig {
    private static final int DEFAULT_MAX_COLUMNS = 20000;
    private static final boolean DEFAULT_SKIP_DUPLICATE = false;
    private final DateTimeFormatter dateTimeFormatter;
    private final boolean versioned;
    private final TimeSeries.TimeFormat timeFormat;
    private final char separator;
    private final int maxColumns;
    private final boolean strictVersioningImport;
    private final boolean skipDuplicateTimeEntry;

    public TimeSeriesCsvConfig() {
        this(ZoneId.systemDefault(), ';', true, TimeSeries.TimeFormat.DATE_TIME, 20000, true, false);
    }

    public TimeSeriesCsvConfig(ZoneId zoneId) {
        this(zoneId, ';', true, TimeSeries.TimeFormat.DATE_TIME, 20000, true, false);
    }

    public TimeSeriesCsvConfig(char separator, boolean versioned, TimeSeries.TimeFormat timeFormat) {
        this(ZoneId.systemDefault(), separator, versioned, timeFormat, 20000, true, false);
    }

    public TimeSeriesCsvConfig(char separator, boolean versioned, TimeSeries.TimeFormat timeFormat, boolean strictVersioningImport) {
        this(ZoneId.systemDefault(), separator, versioned, timeFormat, 20000, strictVersioningImport, false);
    }

    public TimeSeriesCsvConfig(char separator, boolean versioned, TimeSeries.TimeFormat timeFormat, boolean strictVersioningImport, boolean skipDuplicateTimeEntry) {
        this(ZoneId.systemDefault(), separator, versioned, timeFormat, 20000, strictVersioningImport, skipDuplicateTimeEntry);
    }

    public TimeSeriesCsvConfig(ZoneId zoneId, char separator, boolean versioned, TimeSeries.TimeFormat timeFormat) {
        this(zoneId, separator, versioned, timeFormat, 20000, true, false);
    }

    public TimeSeriesCsvConfig(ZoneId zoneId, char separator, boolean versioned, TimeSeries.TimeFormat timeFormat, boolean strictVersioningImport) {
        this(zoneId, separator, versioned, timeFormat, 20000, strictVersioningImport, false);
    }

    public TimeSeriesCsvConfig(ZoneId zoneId, char separator, boolean versioned, TimeSeries.TimeFormat timeFormat, int maxColumns, boolean strictVersioningImport) {
        this(zoneId, separator, versioned, timeFormat, maxColumns, strictVersioningImport, false);
    }

    public TimeSeriesCsvConfig(ZoneId zoneId, char separator, boolean versioned, TimeSeries.TimeFormat timeFormat, int maxColumns, boolean strictVersioningImport, boolean skipDuplicateTimeEntry) {
        this.dateTimeFormatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(zoneId);
        this.separator = separator;
        this.versioned = versioned;
        this.timeFormat = timeFormat;
        this.maxColumns = maxColumns;
        this.strictVersioningImport = strictVersioningImport;
        this.skipDuplicateTimeEntry = skipDuplicateTimeEntry;
    }

    public char separator() {
        return this.separator;
    }

    public boolean versioned() {
        return this.versioned;
    }

    public TimeSeries.TimeFormat timeFormat() {
        return this.timeFormat;
    }

    public DateTimeFormatter dateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    public int getMaxColumns() {
        return this.maxColumns;
    }

    public boolean withStrictVersioningImport() {
        return this.strictVersioningImport;
    }

    public boolean isSkipDuplicateTimeEntry() {
        return this.skipDuplicateTimeEntry;
    }
}

