/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.powsybl.timeseries.InfiniteTimeSeriesIndex;
import com.powsybl.timeseries.IrregularTimeSeriesIndex;
import com.powsybl.timeseries.RegularTimeSeriesIndex;
import com.powsybl.timeseries.TimeSeries;
import com.powsybl.timeseries.TimeSeriesDataType;
import com.powsybl.timeseries.TimeSeriesIndex;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class TimeSeriesMetadata {
    private final String name;
    private final TimeSeriesDataType dataType;
    private final Map<String, String> tags;
    private final TimeSeriesIndex index;

    public TimeSeriesMetadata(String name, TimeSeriesDataType dataType, TimeSeriesIndex index) {
        this(name, dataType, Collections.unmodifiableMap(new LinkedHashMap()), index);
    }

    public TimeSeriesMetadata(String name, TimeSeriesDataType dataType, Map<String, String> tags, TimeSeriesIndex index) {
        this.name = Objects.requireNonNull(name);
        this.dataType = Objects.requireNonNull(dataType);
        this.tags = Collections.unmodifiableMap(Objects.requireNonNull(tags));
        this.index = Objects.requireNonNull(index);
    }

    public String getName() {
        return this.name;
    }

    public TimeSeriesDataType getDataType() {
        return this.dataType;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public TimeSeriesIndex getIndex() {
        return this.index;
    }

    public void writeJson(JsonGenerator generator) {
        try {
            generator.writeStartObject();
            generator.writeStringField("name", this.name);
            generator.writeStringField("dataType", this.dataType.name());
            generator.writeFieldName("tags");
            generator.writeStartArray();
            for (Map.Entry<String, String> e : this.tags.entrySet()) {
                generator.writeStartObject();
                generator.writeStringField(e.getKey(), e.getValue());
                generator.writeEndObject();
            }
            generator.writeEndArray();
            generator.writeFieldName(this.index.getType());
            this.index.writeJson(generator);
            generator.writeEndObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static void parseFieldName(JsonParser parser, JsonParsingContext context, TimeSeries.TimeFormat timeFormat) throws IOException {
        String fieldName = parser.currentName();
        if (context.insideTags) {
            context.tags.put(fieldName, parser.nextTextValue());
        } else {
            switch (fieldName) {
                case "metadata": {
                    break;
                }
                case "name": {
                    context.name = parser.nextTextValue();
                    break;
                }
                case "dataType": {
                    context.dataType = TimeSeriesDataType.valueOf(parser.nextTextValue());
                    break;
                }
                case "tags": {
                    context.insideTags = true;
                    break;
                }
                case "regularIndex": {
                    context.index = RegularTimeSeriesIndex.parseJson(parser);
                    break;
                }
                case "irregularIndex": {
                    context.index = IrregularTimeSeriesIndex.parseJson(parser, timeFormat == TimeSeries.TimeFormat.MILLIS ? TimeSeriesIndex.ExportFormat.MILLISECONDS : TimeSeriesIndex.ExportFormat.NANOSECONDS);
                    break;
                }
                case "infiniteIndex": {
                    context.index = InfiniteTimeSeriesIndex.parseJson(parser);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected field name " + fieldName);
                }
            }
        }
    }

    public static TimeSeriesMetadata parseJson(JsonParser parser) {
        return TimeSeriesMetadata.parseJson(parser, TimeSeries.TimeFormat.MILLIS);
    }

    public static TimeSeriesMetadata parseJson(JsonParser parser, TimeSeries.TimeFormat timeFormat) {
        try {
            JsonToken token;
            JsonParsingContext context = new JsonParsingContext();
            block7: while ((token = parser.nextToken()) != null) {
                switch (token) {
                    case FIELD_NAME: {
                        TimeSeriesMetadata.parseFieldName(parser, context, timeFormat);
                        continue block7;
                    }
                    case END_ARRAY: {
                        if (!context.insideTags) continue block7;
                        context.insideTags = false;
                        continue block7;
                    }
                    case END_OBJECT: {
                        if (context.insideTags) continue block7;
                        if (context.isComplete()) {
                            return new TimeSeriesMetadata(context.name, context.dataType, context.tags, context.index);
                        }
                        throw new IllegalStateException("Incomplete time series metadata json");
                    }
                }
            }
            throw new IllegalStateException("should not happen");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.dataType, this.tags, this.index});
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimeSeriesMetadata) {
            TimeSeriesMetadata other = (TimeSeriesMetadata)obj;
            return this.name.equals(other.name) && this.dataType == other.dataType && this.tags.equals(other.tags) && this.index.equals(other.index);
        }
        return false;
    }

    public String toString() {
        return "TimeSeriesMetadata(name=" + this.name + ", dataType=" + this.dataType + ", tags=" + this.tags + ", index=" + this.index + ")";
    }

    private static final class JsonParsingContext {
        private String name;
        private TimeSeriesDataType dataType;
        private final Map<String, String> tags = new LinkedHashMap<String, String>();
        private TimeSeriesIndex index;
        private boolean insideTags = false;

        private JsonParsingContext() {
        }

        public boolean isComplete() {
            return this.name != null && this.dataType != null && this.index != null;
        }
    }
}

