/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.commons.util.trove.TDoubleArrayListHack;
import com.powsybl.commons.util.trove.TIntArrayListHack;
import com.powsybl.timeseries.AbstractUncompressedDataChunk;
import com.powsybl.timeseries.BigDoubleBuffer;
import com.powsybl.timeseries.CompressedDoubleDataChunk;
import com.powsybl.timeseries.DataChunk;
import com.powsybl.timeseries.DoubleDataChunk;
import com.powsybl.timeseries.DoublePoint;
import com.powsybl.timeseries.TimeSeriesDataType;
import com.powsybl.timeseries.TimeSeriesIndex;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;

public class UncompressedDoubleDataChunk
extends AbstractUncompressedDataChunk
implements DoubleDataChunk {
    private final double[] values;

    public UncompressedDoubleDataChunk(int offset, double[] values) {
        super(offset);
        this.values = Objects.requireNonNull(values);
    }

    public double[] getValues() {
        return this.values;
    }

    @Override
    public int getLength() {
        return this.values.length;
    }

    @Override
    public int getEstimatedSize() {
        return 8 * this.values.length;
    }

    @Override
    public TimeSeriesDataType getDataType() {
        return TimeSeriesDataType.DOUBLE;
    }

    private void forEachValueIndex(DoubleIntConsumer consumer) {
        for (int i = 0; i < this.values.length; ++i) {
            consumer.accept(this.values[i], this.offset + i);
        }
    }

    @Override
    public void fillBuffer(DoubleBuffer buffer, int timeSeriesOffset) {
        Objects.requireNonNull(buffer);
        this.forEachValueIndex((v, i) -> buffer.put(timeSeriesOffset + i, v));
    }

    @Override
    public void fillBuffer(BigDoubleBuffer buffer, long timeSeriesOffset) {
        Objects.requireNonNull(buffer);
        this.forEachValueIndex((v, i) -> buffer.put(timeSeriesOffset + (long)i, v));
    }

    @Override
    public DoubleDataChunk tryToCompress() {
        TDoubleArrayListHack stepValues = new TDoubleArrayListHack();
        TIntArrayListHack stepLengths = new TIntArrayListHack();
        int estimatedSize = this.getEstimatedSize();
        for (double value : this.values) {
            if (stepValues.isEmpty()) {
                stepValues.add(value);
                stepLengths.add(1);
            } else {
                int previousIndex = stepValues.size() - 1;
                double previousValue = stepValues.getQuick(previousIndex);
                if (previousValue == value) {
                    stepLengths.set(previousIndex, stepLengths.getQuick(previousIndex) + 1);
                } else {
                    stepValues.add(value);
                    stepLengths.add(1);
                }
            }
            if (CompressedDoubleDataChunk.getEstimatedSize(stepValues.size(), stepLengths.size()) < estimatedSize) continue;
            return this;
        }
        return new CompressedDoubleDataChunk(this.offset, this.values.length, stepValues.toArray(), stepLengths.toArray());
    }

    @Override
    public DataChunk.Split<DoublePoint, DoubleDataChunk> splitAt(int splitIndex) {
        if (splitIndex <= this.offset || splitIndex > this.offset + this.values.length - 1) {
            throw new IllegalArgumentException("Split index " + splitIndex + " out of chunk range ]" + this.offset + ", " + (this.offset + this.values.length - 1) + "]");
        }
        double[] values1 = new double[splitIndex - this.offset];
        double[] values2 = new double[this.values.length - values1.length];
        System.arraycopy(this.values, 0, values1, 0, values1.length);
        System.arraycopy(this.values, values1.length, values2, 0, values2.length);
        return new DataChunk.Split<DoublePoint, DoubleDataChunk>(new UncompressedDoubleDataChunk(this.offset, values1), new UncompressedDoubleDataChunk(splitIndex, values2));
    }

    @Override
    public DoubleDataChunk append(DoubleDataChunk otherChunk) {
        if (this.getOffset() + this.getLength() != otherChunk.getOffset()) {
            throw new IllegalArgumentException("Chunks are not successive. First offset is " + this.getOffset() + " and first size is " + this.getLength() + "; second offset should be " + (this.getOffset() + this.getLength()) + "but is " + otherChunk.getOffset());
        }
        if (!(otherChunk instanceof UncompressedDoubleDataChunk)) {
            throw new IllegalArgumentException("The chunks to merge have to have the same implentation. One of them is " + this.getClass() + ", the other one is " + otherChunk.getClass());
        }
        UncompressedDoubleDataChunk chunk = (UncompressedDoubleDataChunk)otherChunk;
        return new UncompressedDoubleDataChunk(this.offset, ArrayUtils.addAll((double[])this.getValues(), (double[])chunk.getValues()));
    }

    @Override
    public Stream<DoublePoint> stream(TimeSeriesIndex index) {
        Objects.requireNonNull(index);
        return IntStream.range(0, this.values.length).mapToObj(i -> new DoublePoint(this.offset + i, index.getInstantAt(this.offset + i), this.values[i]));
    }

    @Override
    public Iterator<DoublePoint> iterator(final TimeSeriesIndex index) {
        Objects.requireNonNull(index);
        return new Iterator<DoublePoint>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < UncompressedDoubleDataChunk.this.values.length;
            }

            @Override
            public DoublePoint next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                DoublePoint point = new DoublePoint(UncompressedDoubleDataChunk.this.offset + this.i, index.getInstantAt(UncompressedDoubleDataChunk.this.offset + this.i), UncompressedDoubleDataChunk.this.values[this.i]);
                ++this.i;
                return point;
            }
        };
    }

    @Override
    protected void writeValuesJson(JsonGenerator generator) throws IOException {
        generator.writeArray(this.values, 0, this.values.length);
    }

    public int hashCode() {
        return Objects.hash(this.offset, Arrays.hashCode(this.values));
    }

    public boolean equals(Object obj) {
        if (obj instanceof UncompressedDoubleDataChunk) {
            UncompressedDoubleDataChunk other = (UncompressedDoubleDataChunk)obj;
            return this.offset == other.offset && Arrays.equals(this.values, other.values);
        }
        return false;
    }

    @FunctionalInterface
    private static interface DoubleIntConsumer {
        public void accept(double var1, int var3);
    }
}

