/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.timeseries.AbstractUncompressedDataChunk;
import com.powsybl.timeseries.BigStringBuffer;
import com.powsybl.timeseries.CompactStringBuffer;
import com.powsybl.timeseries.CompressedStringDataChunk;
import com.powsybl.timeseries.DataChunk;
import com.powsybl.timeseries.StringDataChunk;
import com.powsybl.timeseries.StringPoint;
import com.powsybl.timeseries.TimeSeriesDataType;
import com.powsybl.timeseries.TimeSeriesIndex;
import gnu.trove.list.array.TIntArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.ObjIntConsumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;

public class UncompressedStringDataChunk
extends AbstractUncompressedDataChunk
implements StringDataChunk {
    private final String[] values;
    private final int estimatedSize;

    public UncompressedStringDataChunk(int offset, String[] values) {
        super(offset);
        this.values = Objects.requireNonNull(values);
        this.estimatedSize = UncompressedStringDataChunk.computeEstimatedSize(values);
    }

    private static int computeEstimatedSize(String[] values) {
        int estimatedSize = 0;
        for (String value : values) {
            if (value == null) continue;
            estimatedSize += value.length() * 2;
        }
        return estimatedSize;
    }

    public String[] getValues() {
        return this.values;
    }

    @Override
    public int getLength() {
        return this.values.length;
    }

    @Override
    public int getEstimatedSize() {
        return this.estimatedSize;
    }

    @Override
    public TimeSeriesDataType getDataType() {
        return TimeSeriesDataType.STRING;
    }

    private void forEachValueIndex(ObjIntConsumer<String> consumer) {
        for (int i = 0; i < this.values.length; ++i) {
            consumer.accept(this.values[i], this.offset + i);
        }
    }

    @Override
    public void fillBuffer(CompactStringBuffer buffer, int timeSeriesOffset) {
        Objects.requireNonNull(buffer);
        this.forEachValueIndex((v, i) -> buffer.putString(timeSeriesOffset + i, (String)v));
    }

    @Override
    public void fillBuffer(BigStringBuffer buffer, long timeSeriesOffset) {
        Objects.requireNonNull(buffer);
        this.forEachValueIndex((v, i) -> buffer.putString(timeSeriesOffset + (long)i, (String)v));
    }

    @Override
    public StringDataChunk tryToCompress() {
        ArrayList<String> stepValues = new ArrayList<String>();
        TIntArrayList stepLengths = new TIntArrayList();
        int compressedEstimatedSize = 0;
        for (String value : this.values) {
            if (stepValues.isEmpty()) {
                stepValues.add(value);
                stepLengths.add(1);
                compressedEstimatedSize += CompressedStringDataChunk.getStepEstimatedSize(value);
            } else {
                int previousIndex = stepValues.size() - 1;
                String previousValue = (String)stepValues.get(previousIndex);
                if (Objects.equals(previousValue, value)) {
                    stepLengths.set(previousIndex, stepLengths.getQuick(previousIndex) + 1);
                } else {
                    stepValues.add(value);
                    stepLengths.add(1);
                    compressedEstimatedSize += CompressedStringDataChunk.getStepEstimatedSize(value);
                }
            }
            if (compressedEstimatedSize <= this.estimatedSize) continue;
            return this;
        }
        return new CompressedStringDataChunk(this.offset, this.values.length, stepValues.toArray(new String[0]), stepLengths.toArray());
    }

    @Override
    public DataChunk.Split<StringPoint, StringDataChunk> splitAt(int splitIndex) {
        if (splitIndex <= this.offset || splitIndex > this.offset + this.values.length - 1) {
            throw new IllegalArgumentException("Split index " + splitIndex + " out of chunk range ]" + this.offset + ", " + (this.offset + this.values.length - 1) + "]");
        }
        String[] values1 = new String[splitIndex - this.offset];
        String[] values2 = new String[this.values.length - values1.length];
        System.arraycopy(this.values, 0, values1, 0, values1.length);
        System.arraycopy(this.values, values1.length, values2, 0, values2.length);
        return new DataChunk.Split<StringPoint, StringDataChunk>(new UncompressedStringDataChunk(this.offset, values1), new UncompressedStringDataChunk(splitIndex, values2));
    }

    @Override
    public StringDataChunk append(StringDataChunk otherChunk) {
        if (this.getOffset() + this.getLength() != otherChunk.getOffset()) {
            throw new IllegalArgumentException("Chunks are not successive. First offset is " + this.getOffset() + " and first size is " + this.getLength() + "; second offset should be " + (this.getOffset() + this.getLength()) + "but is " + otherChunk.getOffset());
        }
        if (!(otherChunk instanceof UncompressedStringDataChunk)) {
            throw new IllegalArgumentException("The chunks to merge have to have the same implentation. One of them is " + this.getClass() + ", the other one is " + otherChunk.getClass());
        }
        UncompressedStringDataChunk chunk = (UncompressedStringDataChunk)otherChunk;
        return new UncompressedStringDataChunk(this.offset, (String[])ArrayUtils.addAll((Object[])this.getValues(), (Object[])chunk.getValues()));
    }

    @Override
    public Stream<StringPoint> stream(TimeSeriesIndex index) {
        Objects.requireNonNull(index);
        return IntStream.range(0, this.values.length).mapToObj(i -> new StringPoint(this.offset + i, index.getInstantAt(this.offset + i), this.values[i]));
    }

    @Override
    public Iterator<StringPoint> iterator(final TimeSeriesIndex index) {
        Objects.requireNonNull(index);
        return new Iterator<StringPoint>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < UncompressedStringDataChunk.this.values.length;
            }

            @Override
            public StringPoint next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                StringPoint point = new StringPoint(UncompressedStringDataChunk.this.offset + this.i, index.getInstantAt(UncompressedStringDataChunk.this.offset + this.i), UncompressedStringDataChunk.this.values[this.i]);
                ++this.i;
                return point;
            }
        };
    }

    @Override
    protected void writeValuesJson(JsonGenerator generator) throws IOException {
        generator.writeStartArray();
        for (String value : this.values) {
            generator.writeString(value);
        }
        generator.writeEndArray();
    }

    public int hashCode() {
        return Objects.hash(this.offset, Arrays.hashCode(this.values));
    }

    public boolean equals(Object obj) {
        if (obj instanceof UncompressedStringDataChunk) {
            UncompressedStringDataChunk other = (UncompressedStringDataChunk)obj;
            return this.offset == other.offset && Arrays.equals(this.values, other.values);
        }
        return false;
    }
}

