/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries.ast;

import com.powsybl.timeseries.ast.NodeCalc;
import com.powsybl.timeseries.ast.NodeCalcVisitor;
import com.powsybl.timeseries.ast.NodeCalcVisitors;
import java.util.Deque;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractBinaryNodeCalc
implements NodeCalc {
    protected NodeCalc left;
    protected NodeCalc right;

    protected AbstractBinaryNodeCalc(NodeCalc left, NodeCalc right) {
        this.left = Objects.requireNonNull(left);
        this.right = Objects.requireNonNull(right);
    }

    protected abstract <R, A> R accept(NodeCalcVisitor<R, A> var1, A var2, R var3, R var4);

    @Override
    public <R, A> R accept(NodeCalcVisitor<R, A> visitor, A arg, int depth) {
        if (depth < NodeCalcVisitors.RECURSION_THRESHOLD) {
            Pair<NodeCalc, NodeCalc> p = visitor.iterate(this, arg);
            R leftValue = null;
            NodeCalc leftNode = (NodeCalc)p.getLeft();
            if (leftNode != null) {
                leftValue = leftNode.accept(visitor, arg, depth + 1);
            }
            R rightValue = null;
            NodeCalc rightNode = (NodeCalc)p.getRight();
            if (rightNode != null) {
                rightValue = rightNode.accept(visitor, arg, depth + 1);
            }
            return this.accept(visitor, arg, leftValue, rightValue);
        }
        return NodeCalcVisitors.visit(this, arg, visitor);
    }

    @Override
    public <R, A> void acceptIterate(NodeCalcVisitor<R, A> visitor, A arg, Deque<Object> nodesStack) {
        Pair<NodeCalc, NodeCalc> p = visitor.iterate(this, arg);
        Object leftNode = p.getLeft();
        leftNode = leftNode == null ? NodeCalcVisitors.NULL : leftNode;
        Object rightNode = p.getRight();
        rightNode = rightNode == null ? NodeCalcVisitors.NULL : rightNode;
        nodesStack.push(leftNode);
        nodesStack.push(rightNode);
    }

    protected abstract <R, A> R acceptHandle(NodeCalcVisitor<R, A> var1, A var2, R var3, R var4);

    @Override
    public <R, A> R acceptHandle(NodeCalcVisitor<R, A> visitor, A arg, Deque<Object> resultsStack) {
        Object rightResult = resultsStack.pop();
        rightResult = rightResult == NodeCalcVisitors.NULL ? null : rightResult;
        Object leftResult = resultsStack.pop();
        leftResult = leftResult == NodeCalcVisitors.NULL ? null : leftResult;
        return (R)this.acceptHandle(visitor, arg, leftResult, rightResult);
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public NodeCalc getLeft() {
        return this.left;
    }

    public void setLeft(NodeCalc left) {
        this.left = Objects.requireNonNull(left);
    }

    public NodeCalc getRight() {
        return this.right;
    }

    public void setRight(NodeCalc right) {
        this.right = Objects.requireNonNull(right);
    }
}

