/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries.ast;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.powsybl.timeseries.TimeSeriesException;
import com.powsybl.timeseries.ast.AbstractSingleChildNodeCalc;
import com.powsybl.timeseries.ast.NodeCalc;
import java.io.IOException;

public abstract class AbstractMinMaxNodeCalc
extends AbstractSingleChildNodeCalc {
    protected final double value;

    protected AbstractMinMaxNodeCalc(NodeCalc child, double value) {
        super(child);
        this.value = value;
    }

    protected abstract String getJsonName();

    @Override
    public void writeJson(JsonGenerator generator) throws IOException {
        generator.writeFieldName(this.getJsonName());
        generator.writeStartObject();
        this.child.writeJson(generator);
        generator.writeNumberField("value", this.value);
        generator.writeEndObject();
    }

    static void parseFieldName(JsonParser parser, JsonToken token, ParsingContext context) throws IOException {
        String fieldName = parser.currentName();
        if ("value".equals(fieldName)) {
            parser.nextValue();
            context.value = parser.getValueAsDouble();
        } else if (context.child == null) {
            context.child = NodeCalc.parseJson(parser, token);
        } else {
            throw new TimeSeriesException("Only 1 operand expected for a min/max");
        }
    }

    protected static ParsingContext parseJson2(JsonParser parser) throws IOException {
        JsonToken token;
        ParsingContext context = new ParsingContext();
        block5: while ((token = parser.nextToken()) != null) {
            switch (token) {
                case START_OBJECT: {
                    continue block5;
                }
                case END_OBJECT: {
                    if (context.child == null || Double.isNaN(context.value)) {
                        throw new TimeSeriesException("Invalid min/max node calc JSON");
                    }
                    return context;
                }
                case FIELD_NAME: {
                    AbstractMinMaxNodeCalc.parseFieldName(parser, token, context);
                    continue block5;
                }
            }
            throw NodeCalc.createUnexpectedToken(token);
        }
        throw NodeCalc.createUnexpectedToken(token);
    }

    protected static class ParsingContext {
        NodeCalc child = null;
        double value = Double.NaN;

        protected ParsingContext() {
        }
    }
}

