/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries.ast;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.powsybl.timeseries.TimeSeriesException;
import com.powsybl.timeseries.ast.LiteralNodeCalc;
import com.powsybl.timeseries.ast.NodeCalc;
import com.powsybl.timeseries.ast.NodeCalcVisitor;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Deque;
import java.util.Objects;

public class BigDecimalNodeCalc
implements LiteralNodeCalc {
    static final String NAME = "bigDecimal";
    private final BigDecimal value;

    public BigDecimalNodeCalc(BigDecimal value) {
        this.value = Objects.requireNonNull(value);
    }

    @Override
    public double toDouble() {
        return this.value.doubleValue();
    }

    @Override
    public <R, A> R accept(NodeCalcVisitor<R, A> visitor, A arg, int depth) {
        return visitor.visit(this, arg);
    }

    @Override
    public <R, A> R acceptHandle(NodeCalcVisitor<R, A> visitor, A arg, Deque<Object> resultsStack) {
        return visitor.visit(this, arg);
    }

    @Override
    public <R, A> void acceptIterate(NodeCalcVisitor<R, A> visitor, A arg, Deque<Object> nodesStack) {
    }

    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public void writeJson(JsonGenerator generator) throws IOException {
        generator.writeNumberField(NAME, this.value);
    }

    static NodeCalc parseJson(JsonParser parser) throws IOException {
        JsonToken token = parser.nextToken();
        if (token != null) {
            if (token == JsonToken.VALUE_NUMBER_INT) {
                return new BigDecimalNodeCalc(BigDecimal.valueOf(parser.getLongValue()));
            }
            if (token == JsonToken.VALUE_NUMBER_FLOAT) {
                return new BigDecimalNodeCalc(BigDecimal.valueOf(parser.getDoubleValue()));
            }
            throw NodeCalc.createUnexpectedToken(token);
        }
        throw new TimeSeriesException("Invalid big decimal node calc JSON");
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BigDecimalNodeCalc) {
            BigDecimalNodeCalc bigDecimalNodeCalc = (BigDecimalNodeCalc)obj;
            return bigDecimalNodeCalc.value.equals(this.value);
        }
        return false;
    }
}

