/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries.ast;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.powsybl.timeseries.TimeSeriesException;
import com.powsybl.timeseries.ast.AbstractBinaryNodeCalc;
import com.powsybl.timeseries.ast.NodeCalc;
import com.powsybl.timeseries.ast.NodeCalcVisitor;
import java.io.IOException;
import java.util.Objects;

public class BinaryOperation
extends AbstractBinaryNodeCalc {
    static final String NAME = "binaryOp";
    private final Operator operator;

    public static BinaryOperation plus(NodeCalc left, NodeCalc right) {
        return new BinaryOperation(left, right, Operator.PLUS);
    }

    public static BinaryOperation minus(NodeCalc left, NodeCalc right) {
        return new BinaryOperation(left, right, Operator.MINUS);
    }

    public static BinaryOperation multiply(NodeCalc left, NodeCalc right) {
        return new BinaryOperation(left, right, Operator.MULTIPLY);
    }

    public static BinaryOperation div(NodeCalc left, NodeCalc right) {
        return new BinaryOperation(left, right, Operator.DIVIDE);
    }

    public static BinaryOperation lessThan(NodeCalc left, NodeCalc right) {
        return new BinaryOperation(left, right, Operator.LESS_THAN);
    }

    public static BinaryOperation lessThanOrEqualsTo(NodeCalc left, NodeCalc right) {
        return new BinaryOperation(left, right, Operator.LESS_THAN_OR_EQUALS_TO);
    }

    public static BinaryOperation greaterThan(NodeCalc left, NodeCalc right) {
        return new BinaryOperation(left, right, Operator.GREATER_THAN);
    }

    public static BinaryOperation greaterThanOrEqualsTo(NodeCalc left, NodeCalc right) {
        return new BinaryOperation(left, right, Operator.GREATER_THAN_OR_EQUALS_TO);
    }

    public static BinaryOperation equals(NodeCalc left, NodeCalc right) {
        return new BinaryOperation(left, right, Operator.EQUALS);
    }

    public static BinaryOperation notEquals(NodeCalc left, NodeCalc right) {
        return new BinaryOperation(left, right, Operator.NOT_EQUALS);
    }

    BinaryOperation(NodeCalc left, NodeCalc right, Operator operator) {
        super(left, right);
        this.operator = Objects.requireNonNull(operator);
    }

    @Override
    public <R, A> R accept(NodeCalcVisitor<R, A> visitor, A arg, R leftValue, R rightValue) {
        return visitor.visit(this, arg, leftValue, rightValue);
    }

    @Override
    public <R, A> R acceptHandle(NodeCalcVisitor<R, A> visitor, A arg, R leftResult, R rightResult) {
        return visitor.visit(this, arg, leftResult, rightResult);
    }

    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public void writeJson(JsonGenerator generator) throws IOException {
        generator.writeFieldName(NAME);
        generator.writeStartObject();
        generator.writeStringField("op", this.operator.name());
        this.left.writeJson(generator);
        this.right.writeJson(generator);
        generator.writeEndObject();
    }

    static void parseFieldName(JsonParser parser, JsonToken token, ParsingContext context) throws IOException {
        String fieldName = parser.currentName();
        if ("op".equals(fieldName)) {
            context.operator = Operator.valueOf(parser.nextTextValue());
        } else if (context.left == null) {
            context.left = NodeCalc.parseJson(parser, token);
        } else if (context.right == null) {
            context.right = NodeCalc.parseJson(parser, token);
        } else {
            throw new TimeSeriesException("2 operands expected for a binary operation");
        }
    }

    static NodeCalc parseJson(JsonParser parser) throws IOException {
        JsonToken token;
        ParsingContext context = new ParsingContext();
        block5: while ((token = parser.nextToken()) != null) {
            switch (token) {
                case START_OBJECT: {
                    continue block5;
                }
                case END_OBJECT: {
                    if (context.left == null || context.right == null || context.operator == null) {
                        throw new TimeSeriesException("Invalid binary operation node calc JSON");
                    }
                    return new BinaryOperation(context.left, context.right, context.operator);
                }
                case FIELD_NAME: {
                    BinaryOperation.parseFieldName(parser, token, context);
                    continue block5;
                }
            }
            throw NodeCalc.createUnexpectedToken(token);
        }
        throw NodeCalc.createUnexpectedToken(token);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.left, this.right, this.operator, NAME});
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BinaryOperation) {
            BinaryOperation binaryOperation = (BinaryOperation)obj;
            return binaryOperation.left.equals(this.left) && binaryOperation.right.equals(this.right) && binaryOperation.operator == this.operator;
        }
        return false;
    }

    public static enum Operator {
        PLUS("+"),
        MINUS("-"),
        MULTIPLY("*"),
        DIVIDE("/"),
        LESS_THAN("<"),
        LESS_THAN_OR_EQUALS_TO("<="),
        GREATER_THAN(">"),
        GREATER_THAN_OR_EQUALS_TO(">="),
        EQUALS("=="),
        NOT_EQUALS("!=");

        private final String str;

        private Operator(String str) {
            this.str = Objects.requireNonNull(str);
        }

        public String toString() {
            return this.str;
        }
    }

    static class ParsingContext {
        NodeCalc left;
        NodeCalc right;
        Operator operator;

        ParsingContext() {
        }
    }
}

