/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries.ast;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.timeseries.ast.AbstractSingleChildNodeCalc;
import com.powsybl.timeseries.ast.NodeCalc;
import com.powsybl.timeseries.ast.NodeCalcVisitor;
import com.powsybl.timeseries.ast.NodeCalcVisitors;
import java.io.IOException;
import java.util.Deque;
import java.util.Objects;

public class CachedNodeCalc
extends AbstractSingleChildNodeCalc {
    static final String NAME = "cached";

    public CachedNodeCalc(NodeCalc child) {
        super(child);
    }

    @Override
    public <R, A> R accept(NodeCalcVisitor<R, A> visitor, A arg, int depth) {
        if (depth < NodeCalcVisitors.RECURSION_THRESHOLD) {
            NodeCalc child = visitor.iterate(this, arg);
            Object childValue = null;
            if (child != null) {
                childValue = child.accept(visitor, arg, depth + 1);
            }
            return visitor.visit(this, arg, childValue);
        }
        return NodeCalcVisitors.visit(this, arg, visitor);
    }

    @Override
    public <R, A> void acceptIterate(NodeCalcVisitor<R, A> visitor, A arg, Deque<Object> nodesStack) {
        NodeCalc childNode = visitor.iterate(this, arg);
        nodesStack.push(childNode == null ? NodeCalcVisitors.NULL : childNode);
    }

    @Override
    public <R, A> R acceptHandle(NodeCalcVisitor<R, A> visitor, A arg, Deque<Object> resultsStack) {
        Object childResult = resultsStack.pop();
        childResult = childResult == NodeCalcVisitors.NULL ? null : childResult;
        return (R)visitor.visit(this, arg, childResult);
    }

    @Override
    public void writeJson(JsonGenerator generator) throws IOException {
        this.child.writeJson(generator);
    }

    public int hashCode() {
        return Objects.hash(NAME, this.child);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CachedNodeCalc) {
            CachedNodeCalc cachedNodeCalc = (CachedNodeCalc)obj;
            return cachedNodeCalc.child.equals(this.child);
        }
        return false;
    }
}

