/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries.ast;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.powsybl.timeseries.TimeSeriesException;
import com.powsybl.timeseries.ast.LiteralNodeCalc;
import com.powsybl.timeseries.ast.NodeCalc;
import com.powsybl.timeseries.ast.NodeCalcVisitor;
import java.io.IOException;
import java.util.Deque;
import java.util.Objects;

public class DoubleNodeCalc
implements LiteralNodeCalc {
    static final String NAME = "double";
    public static final NodeCalc ONE = new DoubleNodeCalc(1.0);
    private final double value;

    public DoubleNodeCalc(double value) {
        this.value = value;
    }

    @Override
    public double toDouble() {
        return this.value;
    }

    @Override
    public <R, A> R accept(NodeCalcVisitor<R, A> visitor, A arg, int depth) {
        return visitor.visit(this, arg);
    }

    @Override
    public <R, A> R acceptHandle(NodeCalcVisitor<R, A> visitor, A arg, Deque<Object> resultsStack) {
        return visitor.visit(this, arg);
    }

    @Override
    public <R, A> void acceptIterate(NodeCalcVisitor<R, A> visitor, A arg, Deque<Object> nodesStack) {
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public void writeJson(JsonGenerator generator) throws IOException {
        generator.writeNumberField(NAME, this.value);
    }

    static NodeCalc parseJson(JsonParser parser) throws IOException {
        JsonToken token = parser.nextToken();
        if (token != null) {
            if (token == JsonToken.VALUE_NUMBER_FLOAT) {
                return new DoubleNodeCalc(parser.getDoubleValue());
            }
            if (token == JsonToken.VALUE_NUMBER_INT) {
                return new DoubleNodeCalc(parser.getIntValue());
            }
            throw NodeCalc.createUnexpectedToken(token);
        }
        throw new TimeSeriesException("Invalid double node calc JSON");
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DoubleNodeCalc) {
            DoubleNodeCalc doubleNodeCalc = (DoubleNodeCalc)obj;
            return doubleNodeCalc.value == this.value;
        }
        return false;
    }
}

