/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries.ast;

import com.fasterxml.jackson.core.JsonParser;
import com.powsybl.timeseries.ast.AbstractMinMaxNodeCalc;
import com.powsybl.timeseries.ast.NodeCalc;
import com.powsybl.timeseries.ast.NodeCalcVisitor;
import com.powsybl.timeseries.ast.NodeCalcVisitors;
import java.io.IOException;
import java.util.Deque;
import java.util.Objects;

public class MaxNodeCalc
extends AbstractMinMaxNodeCalc {
    static final String NAME = "max";

    public MaxNodeCalc(NodeCalc child, double max) {
        super(child, max);
    }

    public double getMax() {
        return this.value;
    }

    @Override
    public <R, A> R accept(NodeCalcVisitor<R, A> visitor, A arg, int depth) {
        if (depth < NodeCalcVisitors.RECURSION_THRESHOLD) {
            NodeCalc child = visitor.iterate(this, arg);
            Object childValue = null;
            if (child != null) {
                childValue = child.accept(visitor, arg, depth + 1);
            }
            return visitor.visit(this, arg, childValue);
        }
        return NodeCalcVisitors.visit(this, arg, visitor);
    }

    @Override
    public <R, A> R acceptHandle(NodeCalcVisitor<R, A> visitor, A arg, Deque<Object> resultsStack) {
        Object childResult = resultsStack.pop();
        childResult = childResult == NodeCalcVisitors.NULL ? null : childResult;
        return (R)visitor.visit(this, arg, childResult);
    }

    @Override
    public <R, A> void acceptIterate(NodeCalcVisitor<R, A> visitor, A arg, Deque<Object> nodesStack) {
        NodeCalc childNode = visitor.iterate(this, arg);
        nodesStack.push(childNode == null ? NodeCalcVisitors.NULL : childNode);
    }

    @Override
    protected String getJsonName() {
        return NAME;
    }

    static NodeCalc parseJson(JsonParser parser) throws IOException {
        AbstractMinMaxNodeCalc.ParsingContext context = MaxNodeCalc.parseJson2(parser);
        return new MaxNodeCalc(context.child, context.value);
    }

    public int hashCode() {
        return this.child.hashCode() + Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MaxNodeCalc) {
            MaxNodeCalc maxNodeCalc = (MaxNodeCalc)obj;
            return maxNodeCalc.child.equals(this.child) && maxNodeCalc.value == this.value;
        }
        return false;
    }
}

