/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries.ast;

import com.fasterxml.jackson.core.JsonParser;
import com.powsybl.timeseries.ast.AbstractMinMaxNodeCalc;
import com.powsybl.timeseries.ast.NodeCalc;
import com.powsybl.timeseries.ast.NodeCalcVisitor;
import com.powsybl.timeseries.ast.NodeCalcVisitors;
import java.io.IOException;
import java.util.Deque;
import java.util.Objects;

public class MinNodeCalc
extends AbstractMinMaxNodeCalc {
    static final String NAME = "min";

    public MinNodeCalc(NodeCalc child, double min) {
        super(child, min);
    }

    public double getMin() {
        return this.value;
    }

    @Override
    public <R, A> R accept(NodeCalcVisitor<R, A> visitor, A arg, int depth) {
        if (depth < NodeCalcVisitors.RECURSION_THRESHOLD) {
            NodeCalc child = visitor.iterate(this, arg);
            Object childValue = null;
            if (child != null) {
                childValue = child.accept(visitor, arg, depth + 1);
            }
            return visitor.visit(this, arg, childValue);
        }
        return NodeCalcVisitors.visit(this, arg, visitor);
    }

    @Override
    public <R, A> R acceptHandle(NodeCalcVisitor<R, A> visitor, A arg, Deque<Object> resultsStack) {
        Object childResult = resultsStack.pop();
        childResult = childResult == NodeCalcVisitors.NULL ? null : childResult;
        return (R)visitor.visit(this, arg, childResult);
    }

    @Override
    public <R, A> void acceptIterate(NodeCalcVisitor<R, A> visitor, A arg, Deque<Object> nodesStack) {
        NodeCalc childNode = visitor.iterate(this, arg);
        nodesStack.push(childNode == null ? NodeCalcVisitors.NULL : childNode);
    }

    @Override
    protected String getJsonName() {
        return NAME;
    }

    static NodeCalc parseJson(JsonParser parser) throws IOException {
        AbstractMinMaxNodeCalc.ParsingContext context = MinNodeCalc.parseJson2(parser);
        return new MinNodeCalc(context.child, context.value);
    }

    public int hashCode() {
        return this.child.hashCode() + Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MinNodeCalc) {
            MinNodeCalc minNodeCalc = (MinNodeCalc)obj;
            return minNodeCalc.child.equals(this.child) && minNodeCalc.value == this.value;
        }
        return false;
    }
}

