/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries.ast;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.timeseries.TimeSeriesException;
import com.powsybl.timeseries.ast.BigDecimalNodeCalc;
import com.powsybl.timeseries.ast.BinaryMaxCalc;
import com.powsybl.timeseries.ast.BinaryMinCalc;
import com.powsybl.timeseries.ast.BinaryOperation;
import com.powsybl.timeseries.ast.DoubleNodeCalc;
import com.powsybl.timeseries.ast.FloatNodeCalc;
import com.powsybl.timeseries.ast.IntegerNodeCalc;
import com.powsybl.timeseries.ast.MaxNodeCalc;
import com.powsybl.timeseries.ast.MinNodeCalc;
import com.powsybl.timeseries.ast.NodeCalcVisitor;
import com.powsybl.timeseries.ast.TimeNodeCalc;
import com.powsybl.timeseries.ast.TimeSeriesNameNodeCalc;
import com.powsybl.timeseries.ast.UnaryOperation;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Deque;
import java.util.Objects;

public interface NodeCalc {
    public <R, A> R accept(NodeCalcVisitor<R, A> var1, A var2, int var3);

    public <R, A> void acceptIterate(NodeCalcVisitor<R, A> var1, A var2, Deque<Object> var3);

    public <R, A> R acceptHandle(NodeCalcVisitor<R, A> var1, A var2, Deque<Object> var3);

    public void writeJson(JsonGenerator var1) throws IOException;

    public static void writeJson(NodeCalc node, JsonGenerator generator) {
        try {
            generator.writeStartObject();
            node.writeJson(generator);
            generator.writeEndObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String toJson(NodeCalc node) {
        Objects.requireNonNull(node);
        return JsonUtil.toJson((T generator) -> NodeCalc.writeJson(node, generator));
    }

    public static NodeCalc parseJson(String json) {
        return (NodeCalc)JsonUtil.parseJson((String)json, NodeCalc::parseJson);
    }

    public static NodeCalc parseJson(JsonParser parser) {
        Objects.requireNonNull(parser);
        try {
            JsonToken token;
            NodeCalc nodeCalc = null;
            boolean continueLoop = true;
            block6: while (continueLoop && (token = parser.nextToken()) != null) {
                switch (token) {
                    case START_OBJECT: {
                        continue block6;
                    }
                    case END_OBJECT: {
                        continueLoop = false;
                        continue block6;
                    }
                }
                nodeCalc = NodeCalc.parseJson(parser, token);
            }
            return nodeCalc;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static TimeSeriesException createUnexpectedToken(JsonToken token) {
        return new TimeSeriesException("Unexpected JSON token: " + token);
    }

    public static NodeCalc parseJson(JsonParser parser, JsonToken token) throws IOException {
        Objects.requireNonNull(parser);
        Objects.requireNonNull(token);
        if (token == JsonToken.FIELD_NAME) {
            String fieldName;
            switch (fieldName = parser.currentName()) {
                case "integer": {
                    return IntegerNodeCalc.parseJson(parser);
                }
                case "float": {
                    return FloatNodeCalc.parseJson(parser);
                }
                case "double": {
                    return DoubleNodeCalc.parseJson(parser);
                }
                case "bigDecimal": {
                    return BigDecimalNodeCalc.parseJson(parser);
                }
                case "binaryOp": {
                    return BinaryOperation.parseJson(parser);
                }
                case "unaryOp": {
                    return UnaryOperation.parseJson(parser);
                }
                case "min": {
                    return MinNodeCalc.parseJson(parser);
                }
                case "max": {
                    return MaxNodeCalc.parseJson(parser);
                }
                case "timeSeriesName": {
                    return TimeSeriesNameNodeCalc.parseJson(parser);
                }
                case "time": {
                    return TimeNodeCalc.parseJson(parser);
                }
                case "binaryMin": {
                    return BinaryMinCalc.parseJson(parser);
                }
                case "binaryMax": {
                    return BinaryMaxCalc.parseJson(parser);
                }
            }
        }
        throw NodeCalc.createUnexpectedToken(token);
    }
}

