/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries.ast;

import com.powsybl.timeseries.ast.AbstractBinaryNodeCalc;
import com.powsybl.timeseries.ast.AbstractSingleChildNodeCalc;
import com.powsybl.timeseries.ast.BinaryMaxCalc;
import com.powsybl.timeseries.ast.BinaryMinCalc;
import com.powsybl.timeseries.ast.BinaryOperation;
import com.powsybl.timeseries.ast.CachedNodeCalc;
import com.powsybl.timeseries.ast.MaxNodeCalc;
import com.powsybl.timeseries.ast.MinNodeCalc;
import com.powsybl.timeseries.ast.NodeCalc;
import com.powsybl.timeseries.ast.NodeCalcModifier;
import com.powsybl.timeseries.ast.TimeNodeCalc;
import com.powsybl.timeseries.ast.UnaryOperation;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class NodeCalcDuplicateDetector
extends NodeCalcModifier<Map<NodeCalc, Set<NodeCalc>>> {
    public static Map<NodeCalc, Set<NodeCalc>> detectDuplicates(NodeCalc nodeCalc) {
        return new NodeCalcDuplicateDetector().detect(nodeCalc);
    }

    private Map<NodeCalc, Set<NodeCalc>> detect(NodeCalc nodeCalc) {
        IdentityHashMap<NodeCalc, Set<NodeCalc>> parents = new IdentityHashMap<NodeCalc, Set<NodeCalc>>(100);
        nodeCalc.accept(this, parents, 0);
        return parents;
    }

    @Override
    public NodeCalc visit(BinaryOperation nodeCalc, Map<NodeCalc, Set<NodeCalc>> parents, NodeCalc left, NodeCalc right) {
        return this.visitBinaryNodeCalc(nodeCalc, parents, left, right);
    }

    @Override
    public NodeCalc visit(BinaryMinCalc nodeCalc, Map<NodeCalc, Set<NodeCalc>> parents, NodeCalc left, NodeCalc right) {
        return this.visitBinaryNodeCalc(nodeCalc, parents, left, right);
    }

    @Override
    public NodeCalc visit(BinaryMaxCalc nodeCalc, Map<NodeCalc, Set<NodeCalc>> parents, NodeCalc left, NodeCalc right) {
        return this.visitBinaryNodeCalc(nodeCalc, parents, left, right);
    }

    @Override
    public NodeCalc visit(UnaryOperation nodeCalc, Map<NodeCalc, Set<NodeCalc>> parents, NodeCalc child) {
        return this.visitSingleChildNodeCalc(nodeCalc, parents, child);
    }

    @Override
    public NodeCalc visit(MinNodeCalc nodeCalc, Map<NodeCalc, Set<NodeCalc>> parents, NodeCalc child) {
        return this.visitSingleChildNodeCalc(nodeCalc, parents, child);
    }

    @Override
    public NodeCalc visit(MaxNodeCalc nodeCalc, Map<NodeCalc, Set<NodeCalc>> parents, NodeCalc child) {
        return this.visitSingleChildNodeCalc(nodeCalc, parents, child);
    }

    @Override
    public NodeCalc visit(TimeNodeCalc nodeCalc, Map<NodeCalc, Set<NodeCalc>> parents, NodeCalc child) {
        return this.visitSingleChildNodeCalc(nodeCalc, parents, child);
    }

    @Override
    public NodeCalc visit(CachedNodeCalc nodeCalc, Map<NodeCalc, Set<NodeCalc>> parents, NodeCalc child) {
        this.visitSingleChildNodeCalc(nodeCalc, parents, child);
        return null;
    }

    private void visitNodeCalc(NodeCalc parent, NodeCalc child, Map<NodeCalc, Set<NodeCalc>> parents) {
        if (parents.containsKey(child)) {
            parents.get(child).add(parent);
        } else {
            Set nodeCalcParents = Collections.newSetFromMap(new IdentityHashMap());
            nodeCalcParents.add(parent);
            parents.put(child, nodeCalcParents);
        }
    }

    private NodeCalc visitBinaryNodeCalc(AbstractBinaryNodeCalc parent, Map<NodeCalc, Set<NodeCalc>> parents, NodeCalc left, NodeCalc right) {
        if (left != null) {
            this.visitNodeCalc(parent, left, parents);
        }
        if (right != null) {
            this.visitNodeCalc(parent, right, parents);
        }
        return parent;
    }

    private NodeCalc visitSingleChildNodeCalc(AbstractSingleChildNodeCalc parent, Map<NodeCalc, Set<NodeCalc>> parents, NodeCalc child) {
        if (child != null) {
            this.visitNodeCalc(parent, child, parents);
        }
        return parent;
    }
}

