/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries.ast;

import com.powsybl.timeseries.DoubleMultiPoint;
import com.powsybl.timeseries.ast.AbstractBinaryNodeCalc;
import com.powsybl.timeseries.ast.BigDecimalNodeCalc;
import com.powsybl.timeseries.ast.BinaryMaxCalc;
import com.powsybl.timeseries.ast.BinaryMinCalc;
import com.powsybl.timeseries.ast.BinaryOperation;
import com.powsybl.timeseries.ast.CachedNodeCalc;
import com.powsybl.timeseries.ast.DoubleNodeCalc;
import com.powsybl.timeseries.ast.FloatNodeCalc;
import com.powsybl.timeseries.ast.IntegerNodeCalc;
import com.powsybl.timeseries.ast.MaxNodeCalc;
import com.powsybl.timeseries.ast.MinNodeCalc;
import com.powsybl.timeseries.ast.NodeCalc;
import com.powsybl.timeseries.ast.NodeCalcVisitor;
import com.powsybl.timeseries.ast.TimeNodeCalc;
import com.powsybl.timeseries.ast.TimeSeriesNameNodeCalc;
import com.powsybl.timeseries.ast.TimeSeriesNumNodeCalc;
import com.powsybl.timeseries.ast.UnaryOperation;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class NodeCalcEvaluator
implements NodeCalcVisitor<Double, EvalContext> {
    public static double eval(NodeCalc nodeCalc, DoubleMultiPoint multiPoint) {
        return new NodeCalcEvaluator().evaluateWithCache(nodeCalc, multiPoint);
    }

    private double evaluateWithCache(NodeCalc nodeCalc, DoubleMultiPoint multiPoint) {
        EvalContext evalContext = new EvalContext(multiPoint, new IdentityHashMap<NodeCalc, Double>());
        return nodeCalc.accept(this, evalContext, 0);
    }

    @Override
    public Double visit(IntegerNodeCalc nodeCalc, EvalContext evalContext) {
        return nodeCalc.toDouble();
    }

    @Override
    public Double visit(FloatNodeCalc nodeCalc, EvalContext evalContext) {
        return nodeCalc.toDouble();
    }

    @Override
    public Double visit(DoubleNodeCalc nodeCalc, EvalContext evalContext) {
        return nodeCalc.getValue();
    }

    @Override
    public Double visit(BigDecimalNodeCalc nodeCalc, EvalContext evalContext) {
        return nodeCalc.toDouble();
    }

    @Override
    public Double visit(BinaryOperation nodeCalc, EvalContext evalContext, Double left, Double right) {
        double leftValue = left;
        double rightValue = right;
        return switch (nodeCalc.getOperator()) {
            default -> throw new IncompatibleClassChangeError();
            case BinaryOperation.Operator.PLUS -> leftValue + rightValue;
            case BinaryOperation.Operator.MINUS -> leftValue - rightValue;
            case BinaryOperation.Operator.MULTIPLY -> leftValue * rightValue;
            case BinaryOperation.Operator.DIVIDE -> leftValue / rightValue;
            case BinaryOperation.Operator.LESS_THAN -> leftValue < rightValue ? 1.0 : 0.0;
            case BinaryOperation.Operator.LESS_THAN_OR_EQUALS_TO -> leftValue <= rightValue ? 1.0 : 0.0;
            case BinaryOperation.Operator.GREATER_THAN -> leftValue > rightValue ? 1.0 : 0.0;
            case BinaryOperation.Operator.GREATER_THAN_OR_EQUALS_TO -> leftValue >= rightValue ? 1.0 : 0.0;
            case BinaryOperation.Operator.EQUALS -> leftValue == rightValue ? 1.0 : 0.0;
            case BinaryOperation.Operator.NOT_EQUALS -> leftValue != rightValue ? 1.0 : 0.0;
        };
    }

    @Override
    public Double visit(UnaryOperation nodeCalc, EvalContext evalContext, Double child) {
        double childValue = child;
        return switch (nodeCalc.getOperator()) {
            default -> throw new IncompatibleClassChangeError();
            case UnaryOperation.Operator.ABS -> Math.abs(childValue);
            case UnaryOperation.Operator.NEGATIVE -> -childValue;
            case UnaryOperation.Operator.POSITIVE -> childValue;
        };
    }

    @Override
    public NodeCalc iterate(UnaryOperation nodeCalc, EvalContext evalContext) {
        return nodeCalc.getChild();
    }

    @Override
    public Double visit(MinNodeCalc nodeCalc, EvalContext evalContext, Double child) {
        double childValue = child;
        return Math.min(childValue, nodeCalc.getMin());
    }

    @Override
    public NodeCalc iterate(MinNodeCalc nodeCalc, EvalContext evalContext) {
        return nodeCalc.getChild();
    }

    @Override
    public Double visit(MaxNodeCalc nodeCalc, EvalContext evalContext, Double child) {
        double childValue = child;
        return Math.max(childValue, nodeCalc.getMax());
    }

    @Override
    public NodeCalc iterate(MaxNodeCalc nodeCalc, EvalContext evalContext) {
        return nodeCalc.getChild();
    }

    @Override
    public Double visit(CachedNodeCalc nodeCalc, EvalContext evalContext, Double child) {
        double childValue;
        if (child == null) {
            childValue = evalContext.cache.get(nodeCalc);
        } else {
            childValue = child;
            evalContext.cache.put(nodeCalc, childValue);
        }
        return childValue;
    }

    @Override
    public NodeCalc iterate(CachedNodeCalc nodeCalc, EvalContext evalContext) {
        return evalContext.cache.containsKey(nodeCalc) ? null : nodeCalc.getChild();
    }

    @Override
    public Double visit(TimeNodeCalc nodeCalc, EvalContext evalContext, Double child) {
        return evalContext.multiPoint.getTime();
    }

    @Override
    public NodeCalc iterate(TimeNodeCalc nodeCalc, EvalContext evalContext) {
        return null;
    }

    @Override
    public Double visit(TimeSeriesNumNodeCalc nodeCalc, EvalContext evalContext) {
        if (evalContext.multiPoint == null) {
            throw new IllegalStateException("Multi point is null");
        }
        return evalContext.multiPoint.getValue(nodeCalc.getTimeSeriesNum());
    }

    @Override
    public Double visit(TimeSeriesNameNodeCalc nodeCalc, EvalContext evalContext) {
        throw new IllegalStateException("NodeCalc should have been resolved before");
    }

    @Override
    public Double visit(BinaryMinCalc nodeCalc, EvalContext evalContext, Double left, Double right) {
        double leftValue = left;
        double rightValue = right;
        return Math.min(leftValue, rightValue);
    }

    @Override
    public Double visit(BinaryMaxCalc nodeCalc, EvalContext evalContext, Double left, Double right) {
        double leftValue = left;
        double rightValue = right;
        return Math.max(leftValue, rightValue);
    }

    @Override
    public Pair<NodeCalc, NodeCalc> iterate(AbstractBinaryNodeCalc nodeCalc, EvalContext evalContext) {
        return Pair.of((Object)nodeCalc.getLeft(), (Object)nodeCalc.getRight());
    }

    static class EvalContext {
        DoubleMultiPoint multiPoint;
        Map<NodeCalc, Double> cache;

        EvalContext(DoubleMultiPoint point, Map<NodeCalc, Double> cache) {
            this.multiPoint = point;
            this.cache = cache;
        }
    }
}

