/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries.ast;

import com.powsybl.timeseries.ast.AbstractBinaryNodeCalc;
import com.powsybl.timeseries.ast.BigDecimalNodeCalc;
import com.powsybl.timeseries.ast.BinaryMaxCalc;
import com.powsybl.timeseries.ast.BinaryMinCalc;
import com.powsybl.timeseries.ast.BinaryOperation;
import com.powsybl.timeseries.ast.CachedNodeCalc;
import com.powsybl.timeseries.ast.DoubleNodeCalc;
import com.powsybl.timeseries.ast.FloatNodeCalc;
import com.powsybl.timeseries.ast.IntegerNodeCalc;
import com.powsybl.timeseries.ast.MaxNodeCalc;
import com.powsybl.timeseries.ast.MinNodeCalc;
import com.powsybl.timeseries.ast.NodeCalc;
import com.powsybl.timeseries.ast.NodeCalcVisitor;
import com.powsybl.timeseries.ast.TimeNodeCalc;
import com.powsybl.timeseries.ast.TimeSeriesNameNodeCalc;
import com.powsybl.timeseries.ast.TimeSeriesNumNodeCalc;
import com.powsybl.timeseries.ast.UnaryOperation;
import org.apache.commons.lang3.tuple.Pair;

public class NodeCalcPrinter
implements NodeCalcVisitor<String, Void> {
    public static String print(NodeCalc nodeCalc) {
        return nodeCalc.accept(new NodeCalcPrinter(), null, 0);
    }

    @Override
    public String visit(IntegerNodeCalc nodeCalc, Void arg) {
        return Integer.toString(nodeCalc.getValue());
    }

    @Override
    public String visit(FloatNodeCalc nodeCalc, Void arg) {
        return Float.toString(nodeCalc.getValue());
    }

    @Override
    public String visit(DoubleNodeCalc nodeCalc, Void arg) {
        return Double.toString(nodeCalc.getValue());
    }

    @Override
    public String visit(BigDecimalNodeCalc nodeCalc, Void arg) {
        return nodeCalc.getValue().toString();
    }

    @Override
    public String visit(BinaryOperation nodeCalc, Void arg, String left, String right) {
        return "(" + left + " " + nodeCalc.getOperator() + " " + right + ")";
    }

    @Override
    public String visit(UnaryOperation nodeCalc, Void arg, String child) {
        return "(" + child + ")." + nodeCalc.getOperator() + "()";
    }

    @Override
    public String visit(MinNodeCalc nodeCalc, Void arg, String child) {
        return child + ".min(" + nodeCalc.getMin() + ")";
    }

    @Override
    public String visit(MaxNodeCalc nodeCalc, Void arg, String child) {
        return child + ".max(" + nodeCalc.getMax() + ")";
    }

    @Override
    public String visit(CachedNodeCalc nodeCalc, Void arg, String child) {
        return child;
    }

    @Override
    public String visit(TimeNodeCalc nodeCalc, Void arg, String child) {
        return "(" + child + ").time()";
    }

    @Override
    public String visit(TimeSeriesNameNodeCalc nodeCalc, Void arg) {
        return "timeSeries['" + nodeCalc.getTimeSeriesName() + "']";
    }

    @Override
    public String visit(TimeSeriesNumNodeCalc nodeCalc, Void arg) {
        return "timeSeries[" + nodeCalc.getTimeSeriesNum() + "]";
    }

    @Override
    public String visit(BinaryMinCalc nodeCalc, Void arg, String left, String right) {
        return "min(" + left + ", " + right + ")";
    }

    @Override
    public String visit(BinaryMaxCalc nodeCalc, Void arg, String left, String right) {
        return "max(" + left + ", " + right + ")";
    }

    @Override
    public NodeCalc iterate(TimeNodeCalc nodeCalc, Void arg) {
        return nodeCalc.getChild();
    }

    @Override
    public NodeCalc iterate(UnaryOperation nodeCalc, Void arg) {
        return nodeCalc.getChild();
    }

    @Override
    public NodeCalc iterate(MinNodeCalc nodeCalc, Void arg) {
        return nodeCalc.getChild();
    }

    @Override
    public NodeCalc iterate(MaxNodeCalc nodeCalc, Void arg) {
        return nodeCalc.getChild();
    }

    @Override
    public NodeCalc iterate(CachedNodeCalc nodeCalc, Void arg) {
        return nodeCalc.getChild();
    }

    @Override
    public Pair<NodeCalc, NodeCalc> iterate(AbstractBinaryNodeCalc nodeCalc, Void arg) {
        return Pair.of((Object)nodeCalc.getLeft(), (Object)nodeCalc.getRight());
    }
}

