/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.timeseries.ast;

import com.powsybl.timeseries.ast.CachedNodeCalc;
import com.powsybl.timeseries.ast.NodeCalc;
import com.powsybl.timeseries.ast.NodeCalcCloner;
import com.powsybl.timeseries.ast.TimeSeriesNameNodeCalc;
import com.powsybl.timeseries.ast.TimeSeriesNumNodeCalc;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;

public class NodeCalcResolver
extends NodeCalcCloner<Void> {
    private final Map<String, Integer> timeSeriesNums;
    private final Map<CachedNodeCalc, CachedNodeCalc> cachedNodeCalcMap;

    public NodeCalcResolver(Map<String, Integer> timeSeriesNums) {
        this.timeSeriesNums = Objects.requireNonNull(timeSeriesNums);
        this.cachedNodeCalcMap = new IdentityHashMap<CachedNodeCalc, CachedNodeCalc>();
    }

    public static NodeCalc resolve(NodeCalc nodeCalc, Map<String, Integer> timeSeriesNums) {
        Objects.requireNonNull(nodeCalc);
        return nodeCalc.accept(new NodeCalcResolver(timeSeriesNums), null, 0);
    }

    @Override
    public NodeCalc visit(TimeSeriesNameNodeCalc nodeCalc, Void arg) {
        Integer num = this.timeSeriesNums.get(nodeCalc.getTimeSeriesName());
        if (num == null) {
            throw new IllegalStateException("Num of time series " + nodeCalc.getTimeSeriesName() + " not found");
        }
        return new TimeSeriesNumNodeCalc(num);
    }

    @Override
    public NodeCalc visit(CachedNodeCalc nodeCalc, Void arg, NodeCalc child) {
        this.cachedNodeCalcMap.putIfAbsent(nodeCalc, new CachedNodeCalc(child));
        return this.cachedNodeCalcMap.get(nodeCalc);
    }
}

